/** @file HL_sys_main.c 
 *   @brief Application main file
 *   @date 11-Dec-2018
 *   @version 04.07.01
 *
 *   This file contains an empty main function,
 *   which can be used for the application.
 */

/* 
 * Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_gio.h"
#include "HL_sci.h"
#include "F021.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
void Internal_FLASH_write(uint32 addr, uint8* buff, uint8 len);
uint8 write_buff[16]={0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35};
char read_buff[16]={ 0 };
//uint8 write_buff[16]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x11,0x22,0x33,0x44,0x55,0x66,0x77};
/* USER CODE END */

uint8 wr_buff[480]={0};
uint8 re_buff[480]={0};
int main(void)
{
/* USER CODE BEGIN (3) */
    int i;
    uint8_t SendBuf[8]={0,1,2,3,4,5,6,7};
    gioInit();
    sciInit();
#if 0
    Flash_WriteData(Fapi_FlashBank0,3,0,write_buff,16);
    Flash_WriteData(Fapi_FlashBank0,3,10,write_buff,16);
    Flash_WriteData(Fapi_FlashBank0,3,20,write_buff,16);
    Flash_WriteData(Fapi_FlashBank0,3,0,read_buff,48);
#else
    Internal_FLASH_write(0x00018000, write_buff, 16);
    Internal_FLASH_write(0x00018010, write_buff, 16);
    Internal_FLASH_write(0x00018020, write_buff, 16);
    Internal_FLASH_write(0x00018030, write_buff, 16);
    Internal_FLASH_write(0x00018040, write_buff, 16);
    Fapi_doMarginReadByByte((uint8_t *)0x00018000,read_buff,16,Fapi_AutoEccGeneration);
#endif
    while(1)
    {
        gioToggleBit(gioPORTB,7);
        for(i=0;i<10000000;i++);
    }

/* USER CODE END */

    return 0;
}

/* USER CODE BEGIN (4) */
void sciNotification(sciBASE_t *sci, uint32 flags)
{
    unsigned char byte = sci->RD;//ȡյSCI->RD
    sciSendByte(sci,byte);
}
void Internal_FLASH_write(uint32 addr, uint8* buff, uint8 len)
{
    Fapi_StatusType oReturnCheck = Fapi_Status_Success;
    oReturnCheck = Fapi_initializeFlashBanks(180);
    if((oReturnCheck == Fapi_Status_Success) && (FLASH_CONTROL_REGISTER->FmStat.FMSTAT_BITS.BUSY != Fapi_Status_FsmBusy))
    {

        if( (addr >= 0x00000000) &&(addr <= 0x003FFFFF) )
        {
            if(addr <= 0x003FFFFF)
            oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank0);
            else
            oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank1);
            oReturnCheck = Fapi_enableMainBankSectors(0xffff);
        }
        else if( (addr >= 0xF0200000 ) && (addr<= 0xF021FFFF))
        {
            oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank7);
            oReturnCheck = Fapi_enableEepromBankSectors(0xffffffff ,0xffffffff);
        }
        while(FLASH_CONTROL_REGISTER->FmStat.FMSTAT_BITS.BUSY == Fapi_Status_FsmBusy);
        oReturnCheck = Fapi_issueProgrammingCommand((uint32_t*)(addr), buff, len, 0, 0, Fapi_AutoEccGeneration);
        /* Place specific example code here */
        /* Wait for FSM to finish */
        while(FLASH_CONTROL_REGISTER->FmStat.FMSTAT_BITS.BUSY == Fapi_Status_FsmBusy);
    }
}



/* USER CODE END */
