/*******************************************************************************
*  Description:  Wireless demostration software
*
* Thomas Almholt
* Texas Instruments, Inc, October 2010
* Built with IAR Embedded Workbench Version: 4.21
********************************************************************************
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/
#define DCO_MULT_1MHZ           30
#define DCO_MULT_4MHZ           122
#define DCO_MULT_8MHZ           244
#define DCO_MULT_12MHZ          366
#define DCO_MULT_16MHZ          488
#define DCO_MULT_20MHZ          610
#define DCO_MULT_25MHZ          763

#define DCORSEL_1MHZ            DCORSEL_2
#define DCORSEL_4MHZ            DCORSEL_4
#define DCORSEL_8MHZ            DCORSEL_4
#define DCORSEL_12MHZ           DCORSEL_5
#define DCORSEL_16MHZ           DCORSEL_5
#define DCORSEL_20MHZ           DCORSEL_6
#define DCORSEL_25MHZ           DCORSEL_7

// CC State machine definition
#define CC_BOOT        1
#define CC_IDLE        2
#define CC_SETUP       3
#define CC_TX_ACTIVE   4
#define CC_RX_ACTIVE   5
#define CC_RF_ACTIVE   6

// Memu system state machine variables
#define MENU_SETUP      20
#define MENU_RESTART    21
#define MENU_IDLE       22
#define MENU_RF_IDLE    23
#define MENU_TX_UNMOD   24
#define MENU_TX_nMCU    25
#define MENU_TX_wMCU    26
#define MENU_RX_STATIC  27
#define MENU_RX_SINGLE  28
#define MENU_RX_SWEEP   29
#define MENU_TX_BER     30
#define MENU_RX_BER     31

// Size of UART buffer
#define UART_BUFF_SIZE 80
#define RSSI_OFFSET 72

typedef struct trx_cfg {
  unsigned char trx_mode;            // mode of operation in progress
  unsigned char cc_state;            // lastest state of CC device
  unsigned char cc_device_id;        // ID from CC device (is it a CC1101 or CC2500)
  unsigned long start_freq;          // start frequency for all tasks
  unsigned long stop_freq;           // stop frequency for all sweeps operations
  unsigned int  no_burst;            // number of TX burst requested
  unsigned int  tx_pwr;              // actual TX power to be used
  unsigned int  bit_rate;            // TRX bitrate
  unsigned int  freq_dev;            // frequency deviation used
  unsigned int  rx_bw;               // rx bandwidth used in receive mode
  unsigned int  ch_spc;              // channel spacing to be used by CC device
  unsigned char b_length;            // burst length in bytes.
  unsigned char rf_channel;          // current RF channel
} trx_cfg_struct;


/*-------------------------------------------------------------
 *  Code that is independent of location of radio device
 * ------------------------------------------------------------*/ 
void main_menu(trx_cfg_struct *trx_cfg);
char parse_ui_cmd(trx_cfg_struct *trx_cfg, char *ui_cmd);
void uartSendString(char *UART_Text);

/*-------------------------------------------------------------
 *  Code that is dependent of location of radio device
 * ------------------------------------------------------------*/ 
void rf_default_setup(trx_cfg_struct *trx_cfg, char RF_IDx);
void rf_initial_setup(trx_cfg_struct *trx_cfg, char RF_IDx);
void rf_send_setup(trx_cfg_struct *trx_cfg, char RF_IDx);
void rf_get_setup(trx_cfg_struct *trx_cfg, char RF_IDx);
void unmodulated_tx(trx_cfg_struct *trx_cfg, char RF_IDx);
void modulated_tx_no_mcu(trx_cfg_struct *trx_cfg, char RF_IDx);
void rx_static(trx_cfg_struct *trx_cfg, char RF_IDx);
void tx_ber(unsigned char *txBuffer, trx_cfg_struct *trx_cfg, char RF_IDx);
void rx_ber(unsigned char *txBuffer, trx_cfg_struct *trx_cfg, char RF_IDx);
void rx_sweep(unsigned char *txBuffer, trx_cfg_struct *trx_cfg, char RF_IDx);
void rx_scan(unsigned char *txBuffer, trx_cfg_struct *trx_cfg, char RF_IDx);
void print_rf_settings(char RF_IDx);
int calculate_rssi(unsigned char cc_rssi);
void generate_hopping_table(unsigned char *hop_table);

/*-------------------------------------------------------------
 *  Global variable used for indicating end-of-line from ISR
 * ------------------------------------------------------------*/ 
extern volatile char uart_eol;
extern char halUsbReceiveBuffer[];
extern unsigned char bufferSize;
