/******************************************************************************
    Filename: hal_spi.c

    Copyright 2007 Texas Instruments, Inc.
******************************************************************************/

/* ****************************************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS, 
* EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF 
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY 
* OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND 
* NON-INFRINGEMENT OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD
* TO THE PROGRAM OR YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR 
* INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR 
* NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY 
* OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. EXCLUDED 
* DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION, 
* COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS,
* OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S AGGREGATE 
* LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE PROGRAM 
* EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted by Texas 
* Instruments is distributed as "freeware".  You may, only under TI's copyright
* in the Program, use and modify the Program without any charge or restriction.  
* You may distribute to third parties, provided that you transfer a copy of this
* license to the third party and the third party agrees to these terms by its 
* first use of the Program. You must reproduce the copyright notice and any 
* other legend of ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains copyrighted material, 
* trade secrets and other TI proprietary information and is protected by 
* copyright laws, international copyright treaties, and trade secret laws, as
* well as other intellectual property laws.  To protect TI's rights in the 
* Program, you agree not to decompile, reverse engineer, disassemble or 
* otherwise translate any object code versions of the Program to a human-
* readable form.  You agree that in no event will you alter, remove or destroy
* any copyright notice included in the Program.  TI reserves all rights not 
* specifically granted under this license. Except as specifically provided 
* herein, nothing in this agreement shall be construed as conferring by 
* implication, estoppel, or otherwise, upon you, any license or other right
* under any TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
*******************************************************************************/
#include "hal_spi_config.h"
#include "hal_msp430.h"

//----------------------------------------------------------------------------------
//  void halSpiWrite(uint8 addr, const uint8 *buffer, uint16 length)
//
//  DESCRIPTION:
//    Write data to device, starting at internal device address "addr".
//    The device will increment the address internally for every new byte
//    that is written. For single byte write, set length to 1.
//----------------------------------------------------------------------------------
uint8 halSpiWrite(uint8 addr, const uint8* data, uint16 length) {
    uint16 i;
    uint8 rc;

    HAL_SPI_BEGIN;
#ifdef HAL_SPI_INTERFACE_BITBANG
    rc = halSpiBitbangOut(addr);
    for (i = 0; i < length; i++)
    {
        halSpiBitbangOut(data[i]);
    }
#else
    HAL_SPI_TXBUF_SET(addr);
    HAL_SPI_WAIT_TXFIN;
    rc = HAL_SPI_RXBUF;
    for (i = 0; i < length; i++)
    {
      HAL_SPI_TXBUF_SET(data[i]);
      HAL_SPI_WAIT_TXBUF;
    }
#ifndef HAL_SPI_INTERFACE_USI
    HAL_SPI_WAIT_TXFIN;
#endif
#endif
    HAL_SPI_END;
    return(rc);

}

//----------------------------------------------------------------------------------
//  uint8 halSpiRead(uint8 addr, uint8* data, uint16 length)
//
//  DESCRIPTION:
//    Read data from device, starting at internal device address "addr".
//    The device will increment the address internally for every new byte
//    that is read. Note that the master device needs to write a dummy byte
//    (in this case 0) for every new byte in order to generate the clock to
//    clock out the data. For single byte read, set length to 1.
//----------------------------------------------------------------------------------
uint8 halSpiRead(uint8 addr, uint8* data, uint16 length) {
    uint16 i;
    uint8 rc;

    HAL_SPI_BEGIN;
#ifdef HAL_SPI_INTERFACE_BITBANG
    rc = halSpiBitbangOut(addr);
    for (i = 0; i < length; i++)
    {
        data[i] = halSpiBitbangIn();
    }
#else
    HAL_SPI_TXBUF_SET(addr);
    HAL_SPI_WAIT_TXFIN;
    rc = HAL_SPI_RXBUF;
    for (i = 0; i < length; i++)
    {
        HAL_SPI_TXBUF_SET(0);        // Dummy write to read data byte
        HAL_SPI_WAIT_TXFIN;
        data[i] = HAL_SPI_RXBUF;     // Store data from last data RX
    }
#endif
    HAL_SPI_END;
    return(rc);
}


//----------------------------------------------------------------------------------
//  uint8 halSpiStrobe(uint8 cmd)
//
//  DESCRIPTION:
//    Special write function, writing only one byte (cmd) to the device.
//----------------------------------------------------------------------------------
uint8 halSpiStrobe(uint8 cmd) {
    uint8 rc;

    HAL_SPI_BEGIN;
#ifdef HAL_SPI_INTERFACE_BITBANG
    rc = halSpiBitbangOut(cmd);
#else
    HAL_SPI_TXBUF_SET(cmd);
    HAL_SPI_WAIT_TXFIN;
    rc = HAL_SPI_RXBUF;
#endif
    HAL_SPI_END;
    return(rc);
}

//----------------------------------------------------------------------------------
//  void halSpiWrite(uint8 addr, const uint8 *buffer, uint16 length)
//
//  DESCRIPTION:
//    Write data to device, starting at internal device address "addr".
//    The device will increment the address internally for every new byte
//    that is written. For single byte write, set length to 1.
//----------------------------------------------------------------------------------
void halSpiWrite16(uint16 data) {

   HAL_SPI_CS_ASSERT;
#ifdef HAL_SPI_INTERFACE_BITBANG
   uint16 i;
   halSpiBitbangOut(addr);
    for (i = 0; i < length; i++) {
        halSpiBitbangOut(data[i]);
    }
#else
    HAL_SPI_WAIT_TXFIN;
    HAL_SPI_TXBUF_SET((data&0xFF00)>>8);
    HAL_SPI_WAIT_TXFIN;
    HAL_SPI_TXBUF_SET(data&0x00FF);
#endif
    HAL_SPI_CS_DEASSERT;
}