/*******************************************************************************
    @file hal_usb.h

    Copyright 2008 Texas Instruments, Inc.
***************************************************************************/
#define F2_UART_INTF_USCIA0 0xA0

#define F5_UART_INTF_USCIA0 0xA1
#define F5_UART_INTF_USCIA1 0xA2
#define F5_UART_INTF_USCIA2 0xA3

#define FR5x_UART_INTF_USCIA0 0xA4
/*******************************************************************************
* Select which port will be used for interface to UART
* Valid selectios are:
* UART_INTF_USCIA0  (Ez430-RF2500)
* UART_INTF_USCIA1  (MSP430F5438 Experimeters board)
* UART_INTF_USCIA2  (MARVK)
*******************************************************************************/
#define UART_SER_INTF  F5_UART_INTF_USCIA0

#if UART_SER_INTF == F2_UART_INTF_USCIA0        // Interface to UART
  #define USB_PORT_OUT      P3OUT
  #define USB_PORT_SEL      P3SEL
  #define USB_PORT_DIR      P3DIR
  #define USB_PORT_REN      P3REN
  #define USB_PIN_TXD       BIT4
  #define USB_PIN_RXD       BIT5
#elif UART_SER_INTF == F5_UART_INTF_USCIA1
  #define USB_PORT_OUT      P5OUT
  #define USB_PORT_SEL      P5SEL
  #define USB_PORT_DIR      P5DIR
  #define USB_PORT_REN      P5REN
  #define USB_PIN_TXD       BIT6
  #define USB_PIN_RXD       BIT7
#elif UART_SER_INTF == F5_UART_INTF_USCIA2
  #define USB_PORT_OUT      P9OUT
  #define USB_PORT_SEL      P9SEL
  #define USB_PORT_DIR      P9DIR
  #define USB_PORT_REN      P9REN
  #define USB_PIN_TXD       BIT4
  #define USB_PIN_RXD       BIT5
#elif UART_SER_INTF == F5_UART_INTF_USCIA0        // Interface to UART
  #define USB_PORT_OUT      P3OUT
  #define USB_PORT_SEL      P3SEL
  #define USB_PORT_DIR      P3DIR
  #define USB_PORT_REN      P3REN
  #define USB_PIN_TXD       BIT4
  #define USB_PIN_RXD       BIT5
#elif UART_SER_INTF == FR5x_UART_INTF_USCIA0     // Interface to UART pins
  #define USB_PORT_OUT      P2OUT
  #define USB_PORT_SEL0      P2SEL0
  #define USB_PORT_SEL1      P2SEL1
  #define USB_PORT_DIR      P2DIR
  #define USB_PORT_REN      P2REN
  #define USB_PIN_TXD       BIT0
  #define USB_PIN_RXD       BIT1
#endif
/*-------------------------------------------------------------
 *                  Function Prototypes 
 * ------------------------------------------------------------*/ 
void halUsbInit(void);
void halUsbShutDown(void);
void halUsbSendChar(char character);
void halUsbSendString(char string[], unsigned char length);

