/*******************************************************************************
*  Description:  This file contains definitions specific to the CC1100/2500.
*  The configuration registers, strobe commands, and status registers are 
*  defined, as well as some common masks for these registers.
*
*  MSP430/CC2520 Interface Code Library v1.0
*
*  T. Almholt
*  Texas Instruments, Inc, July 2011
*  IAR Embedded Workbench v3.41
********************************************************************************
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

// Address definitions

// FREG definitions (BSET/BCLR supported)
#define FRMFILT0                0x000
#define FRMFILT1                0x001
#define SRCMATCH                0x002
#define SRCSHORTEN0             0x004
#define SRCSHORTEN1             0x005
#define SRCSHORTEN2             0x006
#define SRCEXTEN0               0x008
#define SRCEXTEN1               0x009
#define SRCEXTEN2               0x00A
#define FRMCTRL0                0x00C
#define FRMCTRL1                0x00D
#define RXENABLE0               0x00E
#define RXENABLE1               0x00F
#define EXCFLAG0                0x010
#define EXCFLAG1                0x011
#define EXCFLAG2                0x012
#define EXCMASKA0               0x014
#define EXCMASKA1               0x015
#define EXCMASKA2               0x016
#define EXCMASKB0               0x018
#define EXCMASKB1               0x019
#define EXCMASKB2               0x01A
#define EXCBINDX0               0x01C
#define EXCBINDX1               0x01D
#define EXCBINDY0               0x01E
#define EXCBINDY1               0x01F
#define GPIOCTRL0               0x020
#define GPIOCTRL1               0x021
#define GPIOCTRL2               0x022
#define GPIOCTRL3               0x023
#define GPIOCTRL4               0x024
#define GPIOCTRL5               0x025
#define GPIOPOLARITY            0x026
#define GPIOCTRL                0x028
#define DPUCON                  0x02A
#define DPUSTAT                 0x02C
#define FREQCTRL                0x02E
#define FREQTUNE                0x02F
#define TXPOWER                 0x030
#define TXCTRL                  0x031
#define FSMSTAT0                0x032
#define FSMSTAT1                0x033
#define FIFOPCTRL               0x034
#define FSMCTRL                 0x035
#define CCACTRL0                0x036
#define CCACTRL1                0x037
#define RSSI                    0x038
#define RSSISTAT                0x039
#define TXFIFO_BUF              0x03A
#define RXFIRST                 0x03C
#define RXFIFOCNT               0x03E
#define TXFIFOCNT               0x03F

// SREG definitions (BSET/BCLR unsupported)
#define CHIPID                  0x040
#define VERSION                 0x042
#define EXTCLOCK                0x044
#define MDMCTRL0                0x046
#define MDMCTRL1                0x047
#define FREQEST                 0x048
#define RXCTRL                  0x04A
#define FSCTRL                  0x04C
#define FSCAL0                  0x04E
#define FSCAL1                  0x04F
#define FSCAL2                  0x050
#define FSCAL3                  0x051
#define AGCCTRL0                0x052
#define AGCCTRL1                0x053
#define AGCCTRL2                0x054
#define AGCCTRL3                0x055
#define ADCTEST0                0x056
#define ADCTEST1                0x057
#define ADCTEST2                0x058
#define MDMTEST0                0x05A
#define MDMTEST1                0x05B
#define DACTEST0                0x05C
#define DACTEST1                0x05D
#define ATEST                   0x05E
#define DACTEST2                0x05F
#define PTEST0                  0x060
#define PTEST1                  0x061
#define RESERVED                0x062
#define DPUBIST                 0x07A
#define ACTBIST                 0x07C
#define RAMBIST                 0x07E

// RAM size definitions
#define RAM_START_ADDR          0x100
#define RAM_SIZE                640

// RX and TX buffer definitions
#define RAM_TXBUF               0x100
#define RAM_RXBUF               0x180

// Security work buffer definitions
#define RAM_CBCTEMPL            0x360
#define RAM_CBCTEMPH            0x370

// Source address matching definitions
#define RAM_SRCTABLEBASE        0x380
#define RAM_SRCRESMASK0         0x3E0
#define RAM_SRCRESMASK1         0x3E1
#define RAM_SRCRESMASK2         0x3E2
#define RAM_SRCRESINDEX         0x3E3
#define RAM_SRCEXTPENDEN0       0x3E4
#define RAM_SRCEXTPENDEN1       0x3E5
#define RAM_SRCEXTPENDEN2       0x3E6
#define RAM_SRCSHORTPENDEN0     0x3E7
#define RAM_SRCSHORTPENDEN1     0x3E8
#define RAM_SRCSHORTPENDEN2     0x3E9

// Local address definitions
#define RAM_EXTADDR             0x3EA
#define RAM_PANID               0x3F2
#define RAM_SHORTADDR           0x3F4

// Command strobes (identifiers to be used with GPIO and exception binding)
#define STR_SIBUFEX             0x00
#define STR_SRXMASKBITCLR       0x01
#define STR_SRXMASKBITSET       0x02
#define STR_SRXON               0x03
#define STR_SSAMPLECCA          0x04
#define STR_SACK                0x05
#define STR_SACKPEND            0x06
#define STR_SNACK               0x07
#define STR_STXON               0x08
#define STR_STXONCCA            0x09
#define STR_SFLUSHRX            0x0A
#define STR_SFLUSHTX            0x0B
#define STR_SRXFIFOPOP          0x0C
#define STR_STXCAL              0x0D
#define STR_SRFOFF              0x0E
#define STR_SXOSCOFF            0x0F

// Exceptions
#define EXC_RF_IDLE             0
#define EXC_TX_FRM_DONE         1
#define EXC_TX_ACK_DONE         2
#define EXC_TX_UNDERFLOW        3
#define EXC_TX_OVERFLOW         4
#define EXC_RX_UNDERFLOW        5
#define EXC_RX_OVERFLOW         6
#define EXC_RXENABLE_ZERO       7
#define EXC_RX_FRM_DONE         8
#define EXC_RX_FRM_ACCEPTED     9
#define EXC_SRC_MATCH_DONE      10
#define EXC_SRC_MATCH_FOUND     11
#define EXC_FIFOP               12
#define EXC_SFD                 13
#define EXC_DPU_DONE_L          14
#define EXC_DPU_DONE_H          15
#define EXC_MEMADDR_ERROR       16
#define EXC_USAGE_ERROR         17
#define EXC_OPERAND_ERROR       18
#define EXC_SPI_ERROR           19
#define EXC_RF_NO_LOCK          20
#define EXC_RX_FRM_ABORTED      21
#define EXC_RXBUFMOV_TIMEOUT    22

// CC2520 FSM state defintions
#define FSM_IDLE                 0
#define FSM_FS_RX_CAL            2
#define FSM_RX_RESET             3
#define FSM_RX_S_CLK             4
#define FSM_RX_ON                5
#define FSM_RX_W_SFD             6
#define FSM_RD_LEN               7
#define FSM_RX_RD_FCF0           8
#define FSM_RX_RD_FCF1           9
#define FSM_RX_RD_SEQ           10
#define FSM_RX_PKT              12
#define FSM_RX_FINAL            13
#define FSM_RXRX_WAIT           14
#define FSM_FIFO_RESET          16
#define FSM_RX_OVERFLOW         17
#define FSM_FS_LB_CAL_WAIT      20
#define FSM_LB_RESET            21
#define FSM_LB_S_CLK            22
#define FSM_LB_PRE              23
#define FSM_LB_PKT              24
#define FSM_LB_FINAL            25
#define FSM_RX_INF              31
#define FSM_FS_TX_CAL           32
#define FSM_FS_TX_CAL_WAIT      33
#define FSM_TX_RESET            34
#define FSM_TX_S_CLK            35
#define FSM_TX_PRE              36
#define FSM_LEN                 37
#define FSM_PKT                 38
#define FSM_TX_FINAL            39
#define FSM_TXRX_TRANSIT        40
#define FSM_PA_SETTLE           41
#define FSM_TX_MOD_DOWNRAMP     42
#define FSM_FS_ACK_CAL          48
#define FSM_TX_ACK_RESET        49
#define FSM_TX_ACK_S_CLK        50
#define FSM_TX_ACK_PRE          51
#define FSM_TX_ACK_LEN          52
#define FSM_TX_ACK_PKT          53
#define FSM_TX_ACK_FIN_PKT      54
#define FSM_TX_ACK_DELAY        55
#define FSM_TX_UNDERFLOW        56
#define FSM_TX_TURNOFF          57
#define FSM_TX_INF              63

// CC2520 FSMSTAT0/1 register bits
#define FSMSTAT_FSM_STATE_BV    0x003F
#define FSMSTAT_CAL_RUNNING_BV  0x0040
#define FSMSTAT_CAL_DONE_BV     0x0080
#define FSMSTAT_RX_ACTIVE_BV    0x0100
#define FSMSTAT_TX_ACTIVE_BV    0x0200
#define FSMSTAT_LOCK_STATUS_BV  0x0400
#define FSMSTAT_SAMPLED_CCA_BV  0x0800
#define FSMSTAT_CCA_BV          0x1000
#define FSMSTAT_SFD_BV          0x2000
#define FSMSTAT_FIFOP_BV        0x4000
#define FSMSTAT_FIFO_BV         0x8000

// CC2520 status byte
#define STB_XOSC_STABLE_BV      0x80
#define STB_RSSI_VALID_BV       0x40
#define STB_EXC_CHB_BV          0x20
#define STB_EXC_CHA_BV          0x10
#define STB_DPUH_ACTIVE_BV      0x08
#define STB_DPUL_ACTIVE_BV      0x04
#define STB_TX_ACTIVE_BV        0x02
#define STB_RX_ACTIVE_BV        0x01

// CC2520 GPIO output definitions
#define GPIO_EXC_CH_A           0x21
#define GPIO_EXC_CH_B           0x22
#define GPIO_EXC_CH_INVA        0x23
#define GPIO_EXC_CH_INVB        0x24
#define GPIO_EXC_CH_RX          0x25
#define GPIO_EXC_CH_ERR         0x26
#define GPIO_FIFO               0x27
#define GPIO_FIFOP              0x28
#define GPIO_CCA                0x29
#define GPIO_SFD                0x2A
#define GPIO_RSSI_VALID         0x2C
#define GPIO_SAMPLED_CCA        0x2D
#define GPIO_SNIFFER_CLK        0x31
#define GPIO_SNIFFER_DATA       0x32
#define GPIO_RX_ACTIVE          0x43
#define GPIO_TX_ACTIVE          0x44
#define GPIO_LOW                0x7E
#define GPIO_HIGH               0x7F

// Instruction implementation
#define INS_SNOP                0x00
#define INS_IBUFLD              0x02
#define INS_SIBUFEX             0x03
#define INS_SSAMPLECCA          0x04
#define INS_SRES                0x0F
#define INS_MEMRD               0x10
#define INS_MEMWR               0x20
#define INS_RXBUF               0x30
#define INS_RXBUFCP             0x38
#define INS_RXBUFMOV            0x32
#define INS_TXBUF               0x3A
#define INS_TXBUFCP             0x3E
#define INS_RANDOM              0x3C
#define INS_SXOSCON             0x40
#define INS_STXCAL              0x41
#define INS_SRXON               0x42
#define INS_STXON               0x43
#define INS_STXONCCA            0x44
#define INS_SRFOFF              0x45
#define INS_SXOSCOFF            0x46
#define INS_SFLUSHRX            0x47
#define INS_SFLUSHTX            0x48
#define INS_SACK                0x49
#define INS_SACKPEND            0x4A
#define INS_SNACK               0x4B
#define INS_SRXMASKBITSET       0x4C
#define INS_SRXMASKBITCLR       0x4D
#define INS_RXMASKAND           0x4E
#define INS_RXMASKOR            0x4F
#define INS_MEMCP               0x50
#define INS_MEMCPR              0x52
#define INS_MEMXCP              0x54
#define INS_MEMXWR              0x56
#define INS_BCLR                0x58
#define INS_BSET                0x59
#define INS_CTR                 0x60
#define INS_CBCMAC              0x64
#define INS_UCBCMAC             0x66
#define INS_CCM                 0x68
#define INS_UCCM                0x6A
#define INS_ECB                 0x70
#define INS_ECBO                0x72
#define INS_ECBX                0x74
#define INS_ECBXO               0x76
#define INS_INC                 0x78
#define INS_ABORT               0x7F
#define INS_REGRD               0x80
#define INS_REGWR               0xC0