/******************************************************************************
*    Filename: hal_fem.c
*              This driver controls the settings of the SKY65313 1 watt FEM.
*
*    Copyright 2007 Texas Instruments, Inc.
******************************************************************************/
#include "msp430.h"
#include "CCx_hal.h"

// Operation Mode Control Voltage Internal States
// CTL1 (Pin 2)  CTL2 (Pin 3)  CTL3 (Pin 4)   
// Receive         0 1 0
// Receive bypass  0 1 1
// Transmit        1 1 x
// Shutdown        x 0 x

//----------------------------------------------------------------------------------
//  void hal_fem_shutdown(void)
//
//  DESCRIPTION:
//  Shut down the SKY65313 FEM
//----------------------------------------------------------------------------------
void hal_fem_shutdown(void) {
    
    HAL_FEM_VPC_CLR();        
    HAL_FEM_CTL_CLR_1();  
    HAL_FEM_CTL_CLR_2();  
    HAL_FEM_CTL_CLR_3();  
    HAL_RFSW_CTL_CLR_1(); 
    HAL_RFSW_CTL_SET_2();
}

//----------------------------------------------------------------------------------
//  void hal_fem_pa_on(void)
//
//  DESCRIPTION:
//  Turn on PA and set gain to maximum 
//----------------------------------------------------------------------------------
void hal_fem_pa_on(void) {
    
    HAL_FEM_CTL_SET_1();  
    HAL_FEM_CTL_SET_2();  
    HAL_FEM_CTL_CLR_3();  
    HAL_RFSW_CTL_CLR_1(); 
    HAL_RFSW_CTL_SET_2();
    HAL_FEM_VPC_SET();
}


//----------------------------------------------------------------------------------
//  void hal_fem_lna_on(void)
//
//  DESCRIPTION:
//  Turn LNA on and set LNA to maximum
//----------------------------------------------------------------------------------
void hal_fem_lna_on(void) {
    
    HAL_FEM_VPC_CLR();        
    HAL_FEM_CTL_CLR_1();  
    HAL_FEM_CTL_SET_2();  
    HAL_FEM_CTL_CLR_3();  
    HAL_RFSW_CTL_SET_1(); 
    HAL_RFSW_CTL_CLR_2();
}

//----------------------------------------------------------------------------------
//  void hal_fem_bypass_on(void)
//
//  DESCRIPTION:
//  Bypass LNA (in the case of high signals strength) and shut down LNA
//----------------------------------------------------------------------------------
void hal_fem_lna_bypass(void) {
    
    HAL_FEM_VPC_CLR();        
    HAL_FEM_CTL_CLR_1();  
    HAL_FEM_CTL_SET_2();  
    HAL_FEM_CTL_SET_3();  
    HAL_RFSW_CTL_CLR_1(); 
    HAL_RFSW_CTL_SET_2();
}
