/*******************************************************************************
*  Description:  This file contains definitions specific to the hardware board.
*  Specifically, the definitions include hardware connections with the
*  CCxxxx connector port, LEDs, and switches.
*
*  MSP430/CC1100-2500 Interface Code Library v1.0
*
*  K. Quiring
*  Texas Instruments, Inc, July 2006
*  IAR Embedded Workbench v3.41
*******************************************************************************/

/* Select one of 4 configuration files */
//#include "CCx_hal_MSP2274.h"
//#include "CCx_hal_CC2520MVK.h"
//#include "CCx_hal_Exp5438A.h"
//#include "CCx_hal_TrxEB.h"
//#include "CCx_hal_FR57xx.h"
//#include "CCx_hal_CC430_uMVK.h"
#include "CCx_hal_EM-CC430.h"
//#include "CCx_hal_CC430_MVK.h"
//#include "CCx_hal_CC430_MVK_SKY65313.h"
//#include "CCx_hal_CC430_MVK_CC1190.h"

/* Select the family of radio to use */
#include "CCxx00_utils.h"
#include "CCxx00_phy.h"
//#include "CC112x_utils.h"
//#include "CC112x_phy.h"
//#include "CC2520_utils.h"
//#include "CC2520_phy.h"


/*******************************************************************************
* Defines used to select between RF slot A and RF slot B, not change needed
*******************************************************************************/

#define FALSE 0
#define TRUE  1

// ID's for keeping track of two radios attached to the same SPI port
#define RF_SLOTA 5
#define RF_SLOTB 6
#define RF_CC430 7

// CC Chip versions
#define DEV_UNKNOWN       10
#define DEV_CC1100        11
#define DEV_CC1101        12
#define DEV_CC2500        13
#define DEV_CC430x        14
#define DEV_CC1120        15
#define DEV_CC1125        16
#define DEV_CC2520        17


#define RADIO_GENERAL_ERROR     0x00
#define RADIO_CRC_OK            0x80
#define RADIO_IDLE              0x81
#define RADIO_RX_MODE           0x82
#define RADIO_TX_MODE           0x83
#define RADIO_RX_ACTIVE         0x84
#define RADIO_TX_ACTIVE         0x85
#define RADIO_SLEEP             0x86
