/*******************************************************************************
*  Description:  This file contains definitions specific to the hardware board.
*  Specifically, the definitions include hardware connections with the
*  CCxxxx connector port, LEDs, and switches.
*
*  MSP430/CC1100-2500 Interface Code Library v1.0
*
*  K. Quiring
*  Texas Instruments, Inc, July 2006-2011
*  IAR Embedded Workbench v5.10
*******************************************************************************/

/*******************************************************************************
* Select which port will be used for interface to CCxxxx, valid options are:
*
* CC_SER_INTF_NULL    CC_SER_INTF_USART0   CC_SER_INTF_USART1
* CC_SER_INTF_USCIA0  CC_SER_INTF_USCIA1   CC_SER_INTF_USCIA2  
* CC_SER_INTF_USCIA3  CC_SER_INTF_USCIB0   CC_SER_INTF_USCIB1
* CC_SER_INTF_USCIB2  CC_SER_INTF_USCIB3   CC_SER_INTF_USI   
* CC_SER_INTF_BITBANG CC_SER_INTF_FRxUSCIB0
* 
*******************************************************************************/
#define CC_RF_SER_INTF       CC_SER_INTF_FRxUSCIB0  // Interface to CCxxxx
#define MSP430_F5xx

/* definition of what port and pin the two indicator LEDs are attached */
#define CC_LED1_PxOUT      PJOUT
#define CC_LED1_PxDIR      PJDIR
#define CC_LED1            BIT0             
#define CC_LED2_PxOUT      PJOUT
#define CC_LED2_PxDIR      PJDIR
#define CC_LED2            BIT1             

/* Chip Select for RF_SLOTA */
#define CC_CSAn_PxOUT       P1OUT          
#define CC_CSAn_PxDIR       P1DIR
#define CC_CSAn_PIN         BIT3

/* RF_SLOTA uses GDO0 for runtime interupts */
#define CC_GDO0_PxOUT      P4OUT
#define CC_GDO0_PxIN       P4IN
#define CC_GDO0_PxDIR      P4DIR
#define CC_GDO0_PxIE       P4IE
#define CC_GDO0_PxIES      P4IES
#define CC_GDO0_PxIFG      P4IFG
#define CC_GDO0_PIN        BIT1

/* Chip Select for RF_SLOTB */
#define CC_CSBn_PxOUT       P1OUT          
#define CC_CSBn_PxDIR       P1DIR
#define CC_CSBn_PIN         BIT3

/* RF_SLOTB uses GDO2 for runtime interupts */
#define CC_GDO2_PxOUT      P2OUT
#define CC_GDO2_PxIN       P2IN
#define CC_GDO2_PxDIR      P2DIR
#define CC_GDO2_PxIE       P2IE
#define CC_GDO2_PxIES      P2IES
#define CC_GDO2_PxIFG      P2IFG
#define CC_GDO2_PIN        BIT3            

#define HAL_LED1_ON()   CC_LED1_PxOUT |= CC_LED1
#define HAL_LED2_ON()   CC_LED2_PxOUT |= CC_LED2
#define HAL_LED3_ON()   CC_LED3_PxOUT |= CC_LED3
#define HAL_LED4_ON()   CC_LED4_PxOUT |= CC_LED4

#define HAL_LED1_OFF()   CC_LED1_PxOUT &= ~CC_LED1
#define HAL_LED2_OFF()   CC_LED2_PxOUT &= ~CC_LED2
#define HAL_LED3_OFF()   CC_LED3_PxOUT &= ~CC_LED3
#define HAL_LED4_OFF()   CC_LED4_PxOUT &= ~CC_LED4

#define HAL_LED1_TOGGLE()   CC_LED1_PxOUT ^= CC_LED1
#define HAL_LED2_TOGGLE()   CC_LED2_PxOUT ^= CC_LED2
#define HAL_LED3_TOGGLE()   CC_LED3_PxOUT ^= CC_LED3
#define HAL_LED4_TOGGLE()   CC_LED4_PxOUT ^= CC_LED4