/*******************************************************************************
*  Description:  CCxx00_drv.c function declarations
*
*  Demo Application for CCxx00_drv.h Interface Code Library v1.2
*
*  K. Quiring & T. Almholt
*  Texas Instruments, Inc.
*  July 2006, December 2010
*  IAR Embedded Workbench v5.10
********************************************************************************
* Version:  1.2
* Comments: Added support for antenna diversity thru the use of multiple radios
*           Added support for collision detection, and various help functions.
*           Changed comments for better readability
* Author  : Thomas Almholt, Texas Instruments, October 2010
*
* Version:  1.1
* Comments: Fixed several bugs where it is stuck in a infinite while loop
*           Added support for 5xx
*
* Version:  1.00
* Comments: Initial Release Version
*******************************************************************************/

/*******************************************************************************
*  Basic Packet Send functions
*******************************************************************************/
void RFSendPacket(unsigned char *txBuffer, unsigned short size, char RF_IDx);
void RFSendPacket_wCCA(unsigned char *txBuffer, unsigned short size, char RF_IDx);

/*******************************************************************************
*  Basic Packet Recieve functions
*******************************************************************************/
char RFReceivePacket(unsigned char *rxBuffer, unsigned short *length, char RF_IDx);
char RFReceiveFixedPacket(unsigned char *rxBuffer, unsigned short *length, char RF_IDx);

/*******************************************************************************
* Wait for the RX burst to arrive, but with timeout option
******************************************************************************/
unsigned short mac_wait_trx(unsigned short max_hold, char RF_IDx);