/******************************************************************************
*            CopyRight(C), Jingkai Electronic technology (shanghai) Co.,LTD.
* File Name: msp430fr57xx_dma_i2c.c
* Author: xujun
* Date: 2019-09-20
* Description: MSP430FR57XX I2C Driver
* History:
* 1.Author: xujun
*   Date: 2019-09-20
*   Description: Initial
* 2.Author:
*   Date:
*   Description:
******************************************************************************/
#include "msp430fr57xx_dma_hal.h"

void HAL_DMA_Para_Config(DMA_ParaTypeDef_t para)
{
    switch (para->dma_chan)        //选择当前设置哪个DMA通道
    {
        case 0: 
            DMA0CTL =   para->dma_ctrl;
            DMA0SA =    para->dma_src_address & 0xFFFFF;
            DMA0DA =    para->dma_dest_address & 0xFFFFF;
            DMA0SZ =    para->dma_size;
            DMACTL0 |=   (para->dma_trg & 0x1F);                 //Trigger Source
            
            DMA0CTL |=  DMAIE;
            DMA0CTL |=  DMAEN;
            break;                                      //指针 = 0通道控制
        case 1: 
            DMA1CTL =   para->dma_ctrl;
            DMA1SA =    para->dma_src_address & 0xFFFFF;
            DMA1DA =    para->dma_dest_address & 0xFFFFF;
            DMA1SZ =    para->dma_size;
            DMACTL0 |=   ((para->dma_trg & 0x1F) << 8);          //Trigger Source
            
            DMA1CTL |=  DMAIE;
            DMA1CTL |=  DMAEN;
            break;                                      //指针 = 1通道控制
        case 2: 
            DMA2CTL =   para->dma_ctrl;
            DMA2SA =    para->dma_src_address & 0xFFFFF;
            DMA2DA =    para->dma_dest_address & 0xFFFFF;
            DMA2SZ =    para->dma_size;
            DMACTL1 |=   (para->dma_trg & 0x1F);                 //Trigger Source
            
            DMA2CTL |=  DMAIE;
            DMA2CTL |=  DMAEN;
            break;                                      //指针 = 2通道控制
    }
}

void HAL_DMA_Start_IT(DMA_ParaTypeDef_t para)
{
    HAL_DMA_Para_Config(para);
}