/******************************************************************************
*            CopyRight(C), Jingkai Electronic technology (shanghai) Co.,LTD.
* File Name: msp430fr57xx_dma_i2c.c
* Author: xujun
* Date: 2019-09-20
* Description: MSP430FR57XX I2C Driver
* History:
* 1.Author: xujun
*   Date: 2019-09-20
*   Description: Initial
* 2.Author:
*   Date:
*   Description:
******************************************************************************/
#include "msp430fr57xx_i2c_hal.h"
#include "msp430fr57xx_dma_hal.h"

void HAL_I2C_Init(unsigned char address)
{
    UCB0CTLW0 |= UCSWRST;		//reset I2C Module
	UCB0CTLW0 |= UCMODE_3 + UCSYNC;		//I2C Slave

	UCB0I2COA0 = address + UCOAEN;			//I2C ADDRESS

	//Set P1.6 & P1.7 on I2C MODE
	P1SEL1 |= BIT6 + BIT7;
	P1SEL0 &= ~BIT6;
	P1SEL0 &= ~BIT7;

	UCB0CTLW0 &= ~UCSWRST;		//release reset I2C Module
	UCB0IE__I2C |= UCSTPIE;	//Enable I2C INTERRUPT
}


void HAL_I2C_Slave_Receive_DMA(unsigned char* buf,unsigned short len)
{
    DMA_ParaTypeDef i2c_dma_cfg;
    i2c_dma_cfg.dma_chan = 0;
    i2c_dma_cfg.dma_trg = 18;
    i2c_dma_cfg.dma_src_address = (unsigned int)&UCB0RXBUF;
    i2c_dma_cfg.dma_dest_address = (unsigned int)buf;
    i2c_dma_cfg.dma_size = len;
    i2c_dma_cfg.dma_ctrl = (0x00 << 12) //Single Transfer
                          |(0x03 << 10) //Dest Inc
                          |(0x00 << 8) //Src Unchange
                          |(0x01 << 7)
                          |(0x01 << 6);
    HAL_DMA_Start_IT(&i2c_dma_cfg);
    return;
}

void HAL_I2C_Slave_Transfer_DMA(unsigned char*buf,unsigned short len)
{
    DMA_ParaTypeDef i2c_dma_cfg;
    i2c_dma_cfg.dma_chan = 1;
    i2c_dma_cfg.dma_trg = 19;
    i2c_dma_cfg.dma_src_address = (unsigned int)buf;
    i2c_dma_cfg.dma_dest_address = (unsigned int)&UCB0TXBUF;
    i2c_dma_cfg.dma_size = len;
    i2c_dma_cfg.dma_ctrl = (0x00 << 12) //Single Transfer
                          |(0x00 << 10) //Dest Inc
                          |(0x03 << 8) //Src Unchange
                          |(0x01 << 7)
                          |(0x01 << 6);
    HAL_DMA_Start_IT(&i2c_dma_cfg);
}