#include "include.h"


unsigned char g_u8ReadByte = 0;


/*********************************************************************
                      *ƣvoid I2c_Write_Byte( unsigned char l_u8Byte )

                      *ܣI2Cдֽ

                      *ڲдֽڣ l_u8Byte 

                      *ڲ

                      *ע
*********************************************************************/
void I2c_Write_Byte( unsigned char l_u8Byte )
{
  while(UCB0CTL1 & UCTXSTP);               //   ȷֹͣλѷ,߿
  UCB0CTL1 |= UCTXSTT + UCTR;              //   ʼź+дģʽ
  delay_ms(3); 
  
  UCB0TXBUF = l_u8Byte ;                   //  д뵥
  delay_ms(3);
  while((UCB0IFG & UCTXIFG)==0);
  
  UCB0CTL1 |= UCTXSTP;                      //  ֹͣź
  while((UCB0CTL1 & UCTXSTP)==1);          //   ȴֹͣźǷѷ 
  
}

/*********************************************************************
                      *ƣunsigned char I2c_Read_Byte( void )

                      *ܣI2Cֽ

                      *ڲ

                      *ڲֽڣ g_u8ReadByte 

                      *ע
*********************************************************************/
unsigned char I2c_Read_Byte( void )
{
  while (UCB0CTL1 & UCTXSTP);               // ȷֹͣλѷ,߿
  UCB0CTL1 |= UCTXSTT;                      // ʼź
  delay_ms(3); 
  
  UCB0CTL1 &= ~UCTR;                        // Ϊģʽ
  
  while((UCB0CTL1 & UCTXSTT)==1);           // ȷ

  delay_ms(10);                             // һʵʱ
  
  while((UCB0IFG&UCRXIFG)==0);              // ȴһ
  UCB0CTL1 |= UCTXSTP+ UCTXNACK;            // ֹͣź,Ӧź 
  g_u8ReadByte = UCB0RXBUF;                 // һ
  
  return g_u8ReadByte;
}

/*********************************************************************
                      *ƣunsigned char Special_I2C_ReadReg ( unsigned char l_u8Address )

                      *ܣI2CȡĴ

                      *ڲĴַ l_u8Address 

                      *ڲĴݣ g_u8ReadByte 

                      *ע
*********************************************************************/
unsigned char Special_I2C_ReadReg ( unsigned char l_u8Address )
{
  while (UCB0CTL1 & UCTXSTP);               // ȷֹͣλѷ,߿
  UCB0CTL1 |= UCTXSTT + UCTR;               // ʼź+дģʽ
  delay_ms(3); 
  
  UCB0TXBUF = l_u8Address;                  // дַ  
  while((UCB0IFG & UCTXIFG)==0);
  delay_ms(3);
  
  UCB0CTL1 &= ~UCTR;                        // Ϊģʽ
  delay_ms(3); 
  
  UCB0CTL1 |= UCTXSTT;                      // ʼź
  while((UCB0CTL1 & UCTXSTT)==1);           // ȷ

  delay_ms(10);                             // һʵʱ
  
  while((UCB0IFG&UCRXIFG)==0);              // ȴһ
  UCB0CTL1 |= UCTXSTP+ UCTXNACK;            // ֹͣź,Ӧź 
  g_u8ReadByte = UCB0RXBUF;                 // һ

  
  return g_u8ReadByte;

}

/*********************************************************************
                      *ƣvoid Special_I2C_WriteReg ( unsigned char l_u8Address,unsigned char l_u8Byte )

                      *ܣI2CдĴ

                      *ڲĴַ l_u8Address дֽڣ l_u8Byte 

                      *ڲ

                      *ע
*********************************************************************/
void Special_I2C_WriteReg ( unsigned char l_u8Address,unsigned char l_u8Byte )
{
  while(UCB0CTL1 & UCTXSTP);               //   ȷֹͣλѷ,߿
  UCB0CTL1 |= UCTXSTT + UCTR;              //   ʼź+дģʽ
  delay_ms(3); 
  
  UCB0TXBUF = l_u8Address;                 //  дַ  
  delay_ms(3); 
  while((UCB0IFG & UCTXIFG)==0);           //   üĴʱͻͣ

  
  UCB0TXBUF = l_u8Byte ;                   //  д뵥
  delay_ms(3);
  while((UCB0IFG & UCTXIFG)==0);
 
   
  UCB0CTL1 |= UCTXSTP;                      //  ֹͣź
  while((UCB0CTL1 & UCTXSTP)==1);          //   ȴֹͣźǷѷ         
}
/*********************************************************************
                      *ƣvoid initI2C( void )

                      *ܣI2Cʼ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
void HardWard_I2c_Init( void )
{
  UCB0CTLW0 |= UCSWRST;                     // Enable SW reset
  UCB0CTLW0 |= UCMODE_3 | UCMST | UCSYNC;   // I2C master mode, SMCLK
  UCB0BRW = 160; 
  UCB0CTLW1 = UCASTP_2;
  UCB0I2CSA = HDC1080_I2C_ADDR;             // Slave Address
  P1SEL0 |= BIT2 | BIT3;                    // P1.2 SDA,P1.3 SCL
  UCB0CTLW0 &= ~UCSWRST;                    // Clear SW reset, resume operation

  __bis_SR_register(GIE); 
}

/*********************************************************************
                      *ƣunsigned char Get_HDC1080_TempHumidity( void )

                      *ܣHDC1080ȡʪȺ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
unsigned char Get_HDC1080_TempHumidity( void )
{
  unsigned char l_u8ManufacturerID[2]={0};
  unsigned char l_u8ConfigReg[2]={0};
  unsigned char l_u8revdata[2]={0};
  unsigned char l_u8buff[4]={0};
  unsigned short l_u16Value = 0;
  float l_u64Result = 0;
  /*********ȡHDC1080_Manufacturer_ID*********/
  l_u8ManufacturerID[0] = Special_I2C_ReadReg(0XFE);
  printf("HDC1080_Manufacturer_ID_H8:0X%x\r\n",l_u8ManufacturerID[0]);
  l_u8ManufacturerID[1] = Special_I2C_ReadReg(0XFE);
  printf("HDC1080_Manufacturer_ID_L8:0X%x\r\n",l_u8ManufacturerID[1]);
  
  if(l_u8ManufacturerID[0] != 0x54 || l_u8ManufacturerID[1] != 0x49)
  {
    /* Get Manufacturer ID error */
    return 1;    
  }
  
  /*********ʼHDC1080*********/
  HardWard_I2c_Init();
  l_u8ConfigReg[0]=0x90;
  l_u8ConfigReg[1]=0x00;
  Special_I2C_WriteReg(HDC1080_Configuration,l_u8ConfigReg[0]); //رHeater,ͬʱɼ¶Ⱥʪ(¶ǰ),¶ȷֱΪ14λ,ʪȷֱΪ14λ
  Special_I2C_WriteReg(HDC1080_Configuration,l_u8ConfigReg[1]); //رHeater,ͬʱɼ¶Ⱥʪ(¶ǰ),¶ȷֱΪ14λ,ʪȷֱΪ14λ
  delay_ms(20); 
  l_u8revdata[0] = Special_I2C_ReadReg(HDC1080_Configuration);
  printf("HDC1080_Configuration:0X%x\r\n",l_u8revdata[0]);

  /*********¶ȼ⣬ȡ*********/
  Special_I2C_ReadReg(HDC1080_Temperature);

  printf("/********¶Ȳ********/\r\n");
  delay_ms(50);
  
  printf("/********ȡ¶Ȳ********/\r\n");
  for(unsigned char i=0; i<2; i++)
  {
    l_u8buff[i] = I2c_Read_Byte();
    printf("HDC1080_Temperature:0X%x\r\n",l_u8buff[i]);
  }
  /*********ӡ¶Ƚ*********/
  l_u16Value = ((uint16_t)l_u8buff[0]<<8 | l_u8buff[1]);
  l_u64Result = (float)l_u16Value/65536*165-40;
  printf("Temp = %.2f\r\n",l_u64Result);
  
  /*********ʪȼ⣬ȡ*********/
  Special_I2C_ReadReg(HDC1080_Humidity);
  
   printf("/********ʪȲ********/\r\n");
  delay_ms(50);
  
  printf("/********ȡʪȲ********/\r\n");
  for(unsigned char i=0; i<2; i++)
  {
    l_u8buff[i] = I2c_Read_Byte();
    printf("HDC1080_Temperature:0X%x\r\n",l_u8buff[i]);
  }
  
  /*********ӡʪȽ*********/
  l_u16Value = ((uint16_t)l_u8buff[0]<<8 | l_u8buff[1]);
  l_u64Result = (float)l_u16Value/65536*100;
  printf("Humidity = %.2f\r\n",l_u64Result);
  
  return 0;
}