#include "include.h"

#define MAX_STRBUF_SIZE      32 /* ڽյ */


unsigned char g_u32RevCnt = 0;  /* ַԼӱ */
unsigned char gAr32_u8xString[32]; /* ڽַ */
unsigned char Data_Bag_Length = 0;
unsigned char Data_Length = 0;
/*********************************************************************
                      *ƣvoid Init_GPIO( void )

                      *ܣIOʼ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
void Init_GPIO( void )
{
     P2DIR = 0xFF; 
     P2REN = 0xFF; 
     P2OUT = 0x00; 
}

/*********************************************************************
                      *ƣvoid Transform_Str(unsigned char l_u8Data)

                      *ܣڷ͵ֽں

                      *ڲҪ͵ݣl_u8Data

                      *ڲ

                      *ע
*********************************************************************/
void Transform_Str(unsigned char l_u8Data)
{
      while(!(UCA1IFG&UCTXIFG));
      UCA1TXBUF = l_u8Data;
}

/*********************************************************************
                      *ƣint putchar(int ch)

                      *ܣputcharض庯

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
int putchar(int ch)
{
	UCA1TXBUF = ch;
	while(!(UCA1IFG & UCTXIFG));
	return ch;
}



/*********************************************************************
                      *ƣvoid Usart_Init( void )

                      *ܣڳʼ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
void Usart_Init( void )
{
  Init_GPIO();
  PM5CTL0 &= ~LOCKLPM5;                    

  FRCTL0 = FRCTLPW | NWAITS_1;
  __bis_SR_register(SCG0);                           // disable FLL
  CSCTL3 |= SELREF__REFOCLK;                         // Set REFO as FLL reference source
  CSCTL0 = 0;                                        // clear DCO and MOD registers
  CSCTL1 &= ~(DCORSEL_7);                            // Clear DCO frequency select bits first
  CSCTL1 |= DCORSEL_5;                               // Set DCO = 16MHz
  CSCTL2 = FLLD_0 + 487;                             // DCOCLKDIV = 16MHz
  __delay_cycles(3);
  __bic_SR_register(SCG0);                           // enable FLL
  while(CSCTL7 & (FLLUNLOCK0 | FLLUNLOCK1));         // FLL locked

  CSCTL4 = SELMS__DCOCLKDIV | SELA__REFOCLK;         // set default REFO(~32768Hz) as ACLK source, ACLK = 32768Hz
                                                     // default DCOCLKDIV as MCLK and SMCLK source
  P2SEL0 |= BIT5 | BIT6;                           

  UCA1CTLW0 |= UCSWRST;
  UCA1CTLW0 |= UCSSEL__SMCLK;

  // Baud Rate calculation
  // 16000000/(16*9600) = 8.681
  // Fractional portion = 0.681
  // User's Guide Table 14-4: UCBRSx = 0xD6
  // UCBRFx = int ( (8.681-8)*16) = 11
  UCA1BR0 = 8;                             // 16000000/16/115200
  UCA1BR1 = 0x00;
  UCA1MCTLW = 0xD600 | UCOS16 | UCBRF_11;

  UCA1CTLW0 &= ~UCSWRST;                    // Initialize eUSCI
  UCA1IE |= UCRXIE;                         // Enable USCI_A0 RX interrupt

  __bis_SR_register(GIE);         //  interrupts enabled

}




/*********************************************************************
                      *ƣvoid USCI_A1_ISR(void)

                      *ܣڽж

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
#pragma vector=USCI_A1_VECTOR
__interrupt void USCI_A1_ISR(void)
{
  switch(__even_in_range(UCA1IV,USCI_UART_UCTXCPTIFG))
  {
    case USCI_NONE: break;
    case USCI_UART_UCRXIFG:     //      ж
       gAr32_u8xString[Data_Length]  = UCA1RXBUF;
       Data_Length++;
       if(Data_Length == 32 && UCA1RXBUF == 0xDB)
       {
           Data_Bag_Length =1;
           Data_Length = 0;
           memset(&gAr32_u8xString,0,sizeof(gAr32_u8xString));
       }
      break;
    case USCI_UART_UCTXIFG: break;
    case USCI_UART_UCSTTIFG: break;
    case USCI_UART_UCTXCPTIFG: break;
    default: break;
  }
}

void Search_TempHumidity( void )
{
  if(Data_Bag_Length == 1)
  {
    Get_HDC1080_TempHumidity();
    Data_Bag_Length = 0;
  }
}