#include "include.h"


/*********************************************************************
                      *ƣstatic void Simulative_I2C_Init(void)

                      *ܣI2Cʼ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
static void Simulative_I2C_Init(void)
{
  P1DIR|= BIT2;
  P1DIR|= BIT3;
  PM5CTL0 &= ~LOCKLPM5;
  SCL_H;
  SDA_H;
  
}


/*********************************************************************
                      *ƣstatic void I2C_Start(void)

                      *ܣI2Cʼź

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
static void I2C_Start(void)
{
	SDA_H;
	SCL_H;
	delay_us(10);	
	SDA_L;
	delay_us(10);	
	SCL_L;			
	delay_us(10);		
}


/*********************************************************************
                      *ƣstatic void I2C_Stop(void)

                      *ܣI2Cֹͣź

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
static void I2C_Stop(void)
{
	SDA_OUT;
	SDA_L;
	SCL_H;
	delay_us(10);	
	SDA_H;
	delay_us(10);	
	SCL_L;
}


/*********************************************************************
                      *ƣstatic void I2C_Ack(void)

                      *ܣӦźţͣ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
static void I2C_Ack(void)
{
	SDA_L;
	delay_us(10);		
	SCL_H;
	delay_us(10);	
	SCL_L;
	delay_us(10);		
}


/*********************************************************************
                      *ƣstatic void I2C_NoAck(void)

                      *ܣӦźţͣ

                      *ڲ

                      *ڲ

                      *ע
*********************************************************************/
static void I2C_NoAck(void)
{
	SDA_H;
	delay_us(10);		
	SCL_H;
	delay_us(10);	
	SCL_L;
	delay_us(10);		
}


/*********************************************************************
                      *ƣstatic unsigned char Wait_Ack(void)

                      *ܣ涨ʱڼӻAck

                      *ڲ

                      *ڲ0-յ1-δյ

                      *ע
*********************************************************************/
static unsigned char Wait_Ack(void)
{
	unsigned char tiemout=0;
	
	SDA_H;
	delay_us(10);	
	SDA_IN;	   
	SCL_H;
	delay_us(10);		 
	while(READ_SDA)
	{
		tiemout++;
		if(tiemout>250)
		{
			I2C_Stop();
			return 1;
		}
	}
	SCL_L;
    SDA_OUT;	
	return 0;  
}


/*********************************************************************
                      *ƣstatic unsigned char Send_Byte(unsigned char l_u8Data)

                      *ܣһֽݵSDAź

                      *ڲҪ͵( l_u8Data )

                      *ڲɹ0ʧܷ1

                      *ע
*********************************************************************/
static unsigned char Send_Byte(unsigned char l_u8Data)
{
	unsigned char i;
	for(i=0; i<8; i++)
	{
		SCL_L;
		delay_us(10);	
		if(l_u8Data & 0x80)
		{
			SDA_H;
		}
		else
		{
			SDA_L;
		}
		delay_us(10);	
		SCL_H;
		delay_us(10);	
		l_u8Data = l_u8Data << 1;
	}
	SCL_L;
	delay_us(10);	
	if(Wait_Ack())
	{
		return 1;
	}
  else
  {
    return 0;
  }
}


/*********************************************************************
                      *ƣstatic uint8_t Receive_Byte(void)

                      *ܣSDAźϽһֽ

                      *ڲ

                      *ڲյ( l_u8RecData )

                      *ע
*********************************************************************/
static uint8_t Receive_Byte(void)
{
	unsigned char l_u8Count, l_u8RecData=0;
	SCL_L;
	delay_us(10);	
	SDA_H;
	SDA_IN;
	for(l_u8Count=0; l_u8Count<8; l_u8Count++)
	{
		SCL_H;
		delay_us(10);	
		l_u8RecData <<= 1;
		if(READ_SDA)
		{
			l_u8RecData |= 0x01;
		}
		SCL_L;
		delay_us(10);	
	}
	SDA_OUT;
	return l_u8RecData;
}

/*********************************************************************
                      *ƣunsigned char I2C_WriteByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char l_u8Data)

                      *ܣдһֽڵݵ豸

                      *ڲӻַl_u8SlaveAddrдַl_u8Addrдݣl_u8Data

                      *ڲɹ0ʧܷ1

                      *ע
*********************************************************************/
unsigned char I2C_WriteByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char l_u8Data)
{
	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr&0xFE))
  {
    return 1;
  }

	if(Send_Byte(l_u8Addr))
  {
    return 1;
  }

	if(Send_Byte(l_u8Data))
  {
    return 1;
  }

	I2C_Stop();
  return 0;
}


/*********************************************************************
                      *ƣunsigned char I2C_WriteNByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char* l_u8Data, unsigned char l_u8Length)

                      *ܣдָСݵ豸

                      *ڲӻַl_u8SlaveAddrĴַl_u8Addrдָ루l_u8Data,дݴС(l_u8Length)

                      *ڲɹ0ʧܷ1

                      *ע
*********************************************************************/
unsigned char I2C_WriteNByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char* l_u8Data, unsigned char l_u8Length)
{
	unsigned char i;
	
	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr&0xFE))
  {
    return 1;
  }

	if(Send_Byte(l_u8Addr))
  {
    return 1;
  }

	for(i=0; i<l_u8Length; i++)
	{
	  if(Send_Byte(l_u8Data[i]))
      {
        return 1;
      }
	}

  I2C_Stop();
  return 0;
}


/*********************************************************************
                      *ƣunsigned char I2C_ReadByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char* l_u8Data)

                      *ܣȡһֽڵ

                      *ڲӻַl_u8SlaveAddrȡļĴַl_u8Addrݴ洢ַl_u8Data

                      *ڲɹ0ʧܷ1

                      *ע
*********************************************************************/
unsigned char I2C_ReadByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char* l_u8Data)
{
	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr&0xFE))
  {
    return 1;
  }

	if(Send_Byte(l_u8Addr))
  {
    return 1;
  }

	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr|0x01))
  {
    return 1;
  }

	*l_u8Data = Receive_Byte();
	
	I2C_NoAck();

	I2C_Stop();	
	
	return 0;
}



/*********************************************************************
            *ƣunsigned char I2C_ReadNByte(uint8_t slaveAddr, uint8_t addr, uint8_t* data, uint8_t length)

            *ܣȡָС

            *ڲӻַl_u8SlaveAddrȡݵ׵ַl_u8Addrָ루l_u8DataȡݴСl_u8Length

            *ڲɹ0ʧܷ1

            *ע
*********************************************************************/
unsigned char I2C_ReadNByte(unsigned char l_u8SlaveAddr, unsigned char l_u8Addr, unsigned char* l_u8Data, unsigned char l_u8Length)
{
	unsigned char i;
	
	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr&0xFE))
  {
    return 1;
  }

	if(Send_Byte(l_u8Addr))
  {
    return 1;
  }

	I2C_Start();
	
	if(Send_Byte(l_u8SlaveAddr|0x01))
  {
    return 1;
  }

	for(i=0; i<l_u8Length-1; i++)
	{
	  l_u8Data[i] = Receive_Byte();
		
		I2C_Ack();
	}
	l_u8Data[i] = Receive_Byte();
	
	I2C_NoAck();
	
	I2C_Stop();
  return 0;
}


/*********************************************************************
                      *ƣunsigned char Hdc1080_Init(void)

                      *ܣHDC1080ʼ

                      *ڲ

                      *ڲʼɹ0ʼʧܷ1

                      *ע
*********************************************************************/
unsigned char Hdc1080_Init(void)
{
  unsigned char reg[2];
  Simulative_I2C_Init();
  /* Get Manufacturer ID */
  if(I2C_ReadNByte(0x80, 0xFE, reg, 2))
  {
    /* Read error */
    return 1;
  }
  
  if(reg[0] != 0x54 && reg[1] != 0x49)
  {
    /* Get Manufacturer ID error */
    return 1;    
  }
  /* Get Device ID */
  I2C_ReadNByte(0x80, 0xFF, reg, 2); 
  if(reg[0] != 0x10 && reg[1] != 0x50)
  {
    /* Get Device ID error */
    return 1;   
  }
  /* Configure HDC1080 */
  reg[0]=0x90;
  reg[1]=0x00;
  if(I2C_WriteNByte(0x80, 0x02, reg, 2))
  {
    /* Write error */
    return 1;    
  }
  /* Delay for Startup of HDC1080 */
  printf("HDC1080 Init Success \r\n");
  delay_ms(20);
  return 0;
}

/*********************************************************************
                      *ƣunsigned char Read_Hdc1080_TempHumidity( void )

                      *ܣHDC1080ȡʪȺ

                      *ڲ

                      *ڲɹ0ʧܷ1

                      *ע
*********************************************************************/
unsigned char Read_Hdc1080_TempHumidity( void )
{
  unsigned char i;
  unsigned char l_u8buff[4];
  unsigned short l_u16temp;
  float l_u64Result = 0;
  I2C_Start();
	
	if(Send_Byte(0x80&0xFE))
  {
    return 1;
  }

	if(Send_Byte(0x00))
  {
    return 1;
  }
  /* delay to allow for sufficient conversion time */
  delay_ms(20);
  
	I2C_Start();
	
	if(Send_Byte(0x80|0x01))
  {
    return 1;
  }

	for(i=0; i<3; i++)
	{
	  l_u8buff[i] = Receive_Byte();
		
		I2C_Ack();
	}
	l_u8buff[3] = Receive_Byte();
	
	I2C_NoAck();
	
	I2C_Stop();
  
  l_u16temp = ((uint16_t)l_u8buff[0]<<8 | l_u8buff[1]);
  l_u64Result=(float)(l_u16temp)/(65536)*165-40;
  printf("Temp = %.2f\r\n",l_u64Result);
  
  l_u16temp = ((uint16_t)l_u8buff[2]<<8 | l_u8buff[3]);
  l_u64Result=(float)(l_u16temp)/(65536)*100;
  printf("Humidity = %.2f\r\n",l_u64Result);



  return 0;  
}









