/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== empty.c ========
 */
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
//#include <ti/drivers/SDSPI.h>
#include <ti/drivers/SPI.h>

/* Board Header file */
#include "Board.h"
#include "driverlib.h"

#define TASKSTACKSIZE   2048
Task_Struct spi_master_taskStruct;
Char spi_master_taskStack[TASKSTACKSIZE];

Void spi_master_taskFxn(UArg arg0, UArg arg1)
{
    SPI_Handle      spi_master;
    SPI_Params      spi_master_Params;
    /* Create I2C for usage */
    SPI_Params_init(&spi_master_Params);
    spi_master_Params.transferMode  = SPI_MODE_CALLBACK;
    spi_master_Params.transferCallbackFxn = NULL;
    spi_master_Params.mode          = SPI_MASTER;
    spi_master_Params.bitRate       = 1000000,
    spi_master_Params.dataSize      = 8;
    //spi_master_Params.frameFormat   = SPI_POL0_PHA0;
    spi_master = SPI_open(Board_SPI0, &spi_master_Params);
    if (spi_master == NULL) System_abort("Error Initializing SPI\n");
    else System_printf("SPI Initialized!\n");
    System_flush();

    uint8_t txBuffer[16] = {0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,
                            0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA};
    SPI_Transaction spiTransaction;
    spiTransaction.txBuf = txBuffer;
    spiTransaction.rxBuf = NULL;
    spiTransaction.count = 16;

    while(1) {
        if(SPI_transfer(spi_master, &spiTransaction) == NULL) System_printf("SPI_transfer error\n");
        else System_printf("SPI_transfer success!\n");
        System_flush();
    }
}

void main (void)
{
    /* Call board init functions */
    Board_initGeneral();
    Board_initGPIO();
    Board_initSPI();

    //Construct heartBeat Task  thread
    Task_Params taskParams;
    Task_Params_init(&taskParams);

    //i2c master
    taskParams.arg0         = 1000;
    taskParams.stackSize    = TASKSTACKSIZE;
    taskParams.stack        = &spi_master_taskStack;
    Task_construct(&spi_master_taskStruct, (Task_FuncPtr)spi_master_taskFxn, &taskParams, NULL);

    /* Start BIOS */
    BIOS_start();
}
