//******************************************************************************
//  MSP430F552x Demo - Single-Byte Flash In-System Programming, Copy SegC to SegD
//
//  Description: This program first erases flash seg C, then it increments all
//  values in seg C, then it erases seg D, then copies seg C to seg D. Starting
//  addresses of segments defined in this code: Seg C-0x1880, Seg D-0x1800.
//  ACLK = REFO = 32kHz, MCLK = SMCLK = default DCO 1048576Hz
//  //* Set Breakpoint on NOP in the Mainloop to avoid Stressing Flash *//
//
//                MSP430F552x
//            -----------------
//        /|\|              XIN|-
//         | |                 |
//         --|RST          XOUT|-
//           |                 |
//
//   Bhargavi Nisarga
//   Texas Instruments Inc.
//   April 2009
//   Built with CCSv4 and IAR Embedded Workbench Version: 4.21
//******************************************************************************

#include <msp430f5529.h>

char value;                                 // 8-bit value to write to seg C


int main(void)
{
  WDTCTL = WDTPW+WDTHOLD;                   // Stop WDT
  value = 1;                                // initialize value
  
  P1DIR |= BIT0;
  
  char *Flash_ptrC;
  Flash_ptrC = (char *) 0x1880;             // Initialize Flash segment C ptr
  
  
  while(1){
    if(*Flash_ptrC == 1)
      P1OUT |=BIT0;
    else
      P1OUT &= ~BIT0;
    __no_operation();                       // Loop forever, SET BREAKPOINT HERE
  }
}

