/**
 * ---------------------------------------------------------------------------------------
 * ---------------------------------------------------------------------------------------
 * 
 * 	   ǲ
 * 	   ADC 0-3V
 * 	   DAC 0-3V
 * ---------------------------------------------------------------------------------------
 * ʱ䣺2020-10-26
 * ---------------------------------------------------------------------------------------
 */

#include "F28x_Project.h"
#include "SciStdio.h"
#include<math.h>
#include<stdio.h>
#include"Adc.h"


// ʼ DAC Ĵָ
volatile struct DAC_REGS* DAC_PTR[4] = {0x0,&DacaRegs,&DacbRegs,&DaccRegs};

//  ADC οѡ
#define REFERENCE_VDAC		0
#define REFERENCE_VREF		1

//  DAC ͨ
#define DACA				1
#define DACB				2
#define DACC				3


#define REFERENCE			REFERENCE_VREF
#define DAC_NUM				DACA
float dacval = 0;

float32 a1[1024];
unsigned int n=0;
// 洢ADCĴ
//Uint16 AdcaResult[6];
Uint16 AdcbResult[1];
//Uint16 AdccResult[6];
//Uint16 AdcdResult[6];

// 洢ADCʵʵѹֵ
//float Adca_V[6];
float Adcb_V[1];
//float Adcc_V[6];
//float Adcd_V[6];
#define DATA_SIZE 256
Uint16 DATA_BUF[DATA_SIZE]; //һڲ
Uint16 resultsIndex;
volatile Uint16 bufferFull;

// 
void configureDAC(Uint16 dac_num);
void test();
void ConfigureEPWM(void);

__interrupt void cpu_timer0_isr(void);
__interrupt void adcb_isr(void);

void main(void)
{
    float T=7.2;  //DACݲΪ2.4ms

    //double step = 0;
	// ϵͳʼPLLرտŹʹʱ

    test();

    InitSysCtrl();

    // ж
    DINT;

    // ʼPieƼĴ
    InitPieCtrl();

    // ʹжϣжϱ־
    IER = 0x0000;
    IFR = 0x0000;

    // ʼж
    InitPieVectTable();

    // DAC
    configureDAC(DAC_NUM);

    //עжϷ
    EALLOW;
    PieVectTable.TIMER0_INT = &cpu_timer0_isr;
    PieVectTable.ADCB_EVT_INT = &adcb_isr;
    EDIS;

    //ʼCPUʱ
    InitCpuTimers();

    // CPUʱ  T*(float)(10^(3)/3072
    // 200MHz CPU Freq, 1 second Period (in uSeconds)
    ConfigCpuTimer(&CpuTimer0, 200,T*(float)1000/1024);
    CpuTimer0Regs.TCR.all = 0x4000;   //ʱ

    //  ADCs  ʹ ADC power
    ConfigureADC();

    ConfigureEPWM();  //EPWM

    //  ADCs ת
    SetupADCSoftware();

    //ʹܶӦж
    IER |= M_INT1;
    IER |= M_INT13;
    IER |= M_INT14;
    //ʹȫжϺʵʱж
    EINT;
    ERTM;

    //ʹжӦж
    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;  //ʹܶʱж

    //Initialize results buffer
    for(resultsIndex = 0;resultsIndex < DATA_SIZE;resultsIndex++)
    {
        DATA_BUF[resultsIndex] = 0;
    }
    resultsIndex = 0;
    bufferFull = 0;

    //enable PIE interrupt ADC_B
    PieCtrlRegs.PIEIER1.bit.INTx2 = 1;

    //sync ePWM
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;

    // ʼ
    //SCIStdioInit();
    //
    //take conversions indefinitely in loop
    //
    do
       {
           //
           //start ePWM
           //
           EPwm1Regs.ETSEL.bit.SOCAEN= 1;  //enable SOCA
           EPwm1Regs.TBCTL.bit.CTRMODE = 0; //unfreeze, and enter up count mode

           //
           //wait while ePWM causes ADC conversions, which then cause interrupts,
           //which fill the results buffer, eventually setting the bufferFull
           //flag
           //
           while(!bufferFull);
           bufferFull = 0; //clear the buffer full flag

           //
           //stop ePWM
           //
           EPwm1Regs.ETSEL.bit.SOCAEN = 0;  //disable SOCA
           EPwm1Regs.TBCTL.bit.CTRMODE = 3; //freeze counter

           //
           //at this point, AdcaResults[] contains a sequence of conversions
           //from the selected channel
           //

           //
           //software breakpoint, hit run again to get updated conversions
           //
           //asm("   ESTOP0");
       }while(1);
}

void test()
{
    //double a1[1024];
    int t1;
    for(t1=0;t1<1024;t1++)
    {
        a1[t1]=1.5+(float)t1/2560;
    }
}


void configureDAC(Uint16 dac_num)
{
	EALLOW;
	DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;
	DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;
	DAC_PTR[dac_num]->DACVALS.all = 0;
	DELAY_US(10); // Delay for buffered DAC to power up
	EDIS;
}

void ConfigureEPWM(void)
{
    EALLOW;
    // Assumes ePWM clock is already enabled
    EPwm1Regs.ETSEL.bit.SOCAEN  = 0;    // Disable SOC on A group
    EPwm1Regs.ETSEL.bit.SOCASEL  = 4;   // Select SOC on up-count
    EPwm1Regs.ETPS.bit.SOCAPRD = 1;       // Generate pulse on 1st event
    EPwm1Regs.CMPA.bit.CMPA = 0x0800;     // Set compare A value to 2048 counts
    EPwm1Regs.TBPRD = 0x1000;             // Set period to 4096 counts
    EPwm1Regs.TBCTL.bit.CTRMODE = 3;      // freeze counter
    EDIS;
}

__interrupt void cpu_timer0_isr(void)
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; //0x000112жACKnowledgeĴȫж
    //CpuTimer0.InterruptCount++;
    dacval = (Uint16)((a1[n]/3.0)*4095);
    n = (n==1023)?0:(n+1);
    DAC_PTR[DAC_NUM]->DACVALS.all = dacval;
 }

// adca1_isr - Read ADC Buffer in ISR
//
interrupt void adcb_isr(void)
{
    DATA_BUF[resultsIndex++] = AdcbResultRegs.ADCRESULT0;
    if(DATA_SIZE <= resultsIndex)
    {
        resultsIndex = 0;
        bufferFull = 1;
    }

    AdcbRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //clear INT1 flag

    //
    // Check if overflow has occurred
    //
    if(1 == AdcbRegs.ADCINTOVF.bit.ADCINT1)
    {
        AdcbRegs.ADCINTOVFCLR.bit.ADCINT1 = 1; //clear INT1 overflow flag
        AdcbRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //clear INT1 flag
    }
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}


