#include "Drv_GPIO.h"

/**********************************************************************************
	Drv_GPIOInit()			
	GPIOģʼ
ã	
***********************************************************************************/
void	Class_GPIODrv::Drv_GPIOInit(void)
{
    //üĴд0мĴд0
    volatile Uint32 *gpioBaseAddr;
    Uint16 regOffset;

    //Disable pin locks
    EALLOW;
    GpioCtrlRegs.GPALOCK.all = 0x00000000;
    GpioCtrlRegs.GPBLOCK.all = 0x00000000;
    GpioCtrlRegs.GPCLOCK.all = 0x00000000;
    GpioCtrlRegs.GPDLOCK.all = 0x00000000;
    GpioCtrlRegs.GPELOCK.all = 0x00000000;
    GpioCtrlRegs.GPFLOCK.all = 0x00000000;

    // Fill all registers with zeros. Writing to each register separately
    // for six GPIO modules would make this function *very* long.
    // Fortunately, we'd be writing them all with zeros anyway, so this
    // saves a lot of space.
    gpioBaseAddr = (Uint32 *)&GpioCtrlRegs;
    for (regOffset = 0; regOffset < sizeof(GpioCtrlRegs)/2; regOffset++)
    {
        //Hack to avoid enabling pull-ups on all pins. GPyPUD is offset
        //0x0C in each register group of 0x40 words. Since this is a
        //32-bit pointer, the addresses must be divided by 2.
        if (regOffset % (0x40/2) != (0x0C/2))
        {
            gpioBaseAddr[regOffset] = 0x00000000;
        }
    }

    gpioBaseAddr = (Uint32 *)&GpioDataRegs;
    for (regOffset = 0; regOffset < sizeof(GpioDataRegs)/2; regOffset++)
    {
        gpioBaseAddr[regOffset] = 0x00000000;
    }

    EDIS;

    //PWM GPIO CONFIG BEGIN

	Drv_GPIO_SetupPinMux(0, GPIO_MUX_CPU1, 6);					//I2CA_SDA
	Drv_GPIO_SetupPinOptions(0, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(1, GPIO_MUX_CPU1, 1);					//EPWM1B
	Drv_GPIO_SetupPinOptions(1, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(2, GPIO_MUX_CPU1, 1);					//EPWM2A
	Drv_GPIO_SetupPinOptions(2, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(3, GPIO_MUX_CPU1, 1);					//EPWM2B
	Drv_GPIO_SetupPinOptions(3, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(4, GPIO_MUX_CPU1, 1);					//EPWM3A
	Drv_GPIO_SetupPinOptions(4, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(5, GPIO_MUX_CPU1, 1);					//EPWM3B
	Drv_GPIO_SetupPinOptions(5, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(6, GPIO_MUX_CPU1, 1);					//EPWM4A
	Drv_GPIO_SetupPinOptions(6, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(7, GPIO_MUX_CPU1, 1);					//EPWM4B
	Drv_GPIO_SetupPinOptions(7, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(8, GPIO_MUX_CPU1, 1);					//EPWM5A
	Drv_GPIO_SetupPinOptions(8, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(9, GPIO_MUX_CPU1, 1);					//EPWM5B
	Drv_GPIO_SetupPinOptions(9, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(10, GPIO_MUX_CPU1, 1);					//EPWM6A
	Drv_GPIO_SetupPinOptions(10, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(11, GPIO_MUX_CPU1, 1);					//EPWM6B
	Drv_GPIO_SetupPinOptions(11, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(12, GPIO_MUX_CPU1, 1);					//EPWM7A
	Drv_GPIO_SetupPinOptions(12, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(13, GPIO_MUX_CPU1, 1);					//EPWM7B
	Drv_GPIO_SetupPinOptions(13, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(14, GPIO_MUX_CPU1, 1);					//EPWM8A
	Drv_GPIO_SetupPinOptions(14, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(15, GPIO_MUX_CPU1, 1);					//EPWM8B
	Drv_GPIO_SetupPinOptions(15, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(16, GPIO_MUX_CPU1, 5);					//EPWM9A
	Drv_GPIO_SetupPinOptions(16, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(17, GPIO_MUX_CPU1, 5);					//EPWM9B
	Drv_GPIO_SetupPinOptions(17, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(18, GPIO_MUX_CPU1, 0);
	Drv_GPIO_SetupPinOptions(18, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(19, GPIO_MUX_CPU1, 5);					//EPWM10B
	Drv_GPIO_SetupPinOptions(19, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(20, GPIO_MUX_CPU1, 5);					//EPWM11A
	Drv_GPIO_SetupPinOptions(20, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(21, GPIO_MUX_CPU1, 5);					//EPWM11B
	Drv_GPIO_SetupPinOptions(21, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(22, GPIO_MUX_CPU1, 5);					//EPWM12A
	Drv_GPIO_SetupPinOptions(22, GPIO_OUTPUT, GPIO_PUSHPULL);

    //PWM GPIO CONFIG END

	Drv_GPIO_SetupPinMux(23, GPIO_MUX_CPU1, 0);					//GPIO23 SOFTRLY
	Drv_GPIO_SetupPinOptions(23, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(24, GPIO_MUX_CPU1, 0);					//GPIO24 NO_USE
	Drv_GPIO_SetupPinOptions(24, GPIO_OUTPUT, GPIO_PUSHPULL);

    //Dry Connect Config

	Drv_GPIO_SetupPinMux(25, GPIO_MUX_CPU1, 0);					//NO USE
	Drv_GPIO_SetupPinOptions(25, GPIO_INPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(26, GPIO_MUX_CPU1, 0);					//Dry Fault3
	Drv_GPIO_SetupPinOptions(26, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(27, GPIO_MUX_CPU1, 0);					//Dry Fault2
	Drv_GPIO_SetupPinOptions(27, GPIO_OUTPUT, GPIO_PUSHPULL);

    Drv_GPIO_SetupPinMux(28, GPIO_MUX_CPU1, 0);
    Drv_GPIO_SetupPinOptions(28, GPIO_INPUT, (GPIO_PULLUP+GPIO_QUAL3));

    // GPIO71õINPUT7ΪECAP1룬ʵֹƵͬ׽
    EALLOW;
    InputXbarRegs.INPUT7SELECT = 28;
    EDIS;

    Drv_GPIO_SetupPinMux(29, GPIO_MUX_CPU1, 5);             //ΪOUTPUTXBAR6
    Drv_GPIO_SetupPinOptions(29, GPIO_OUTPUT, GPIO_PUSHPULL);

//    EALLOW;
//    OutputXbarRegs.OUTPUT6MUX0TO15CFG.bit.Mux0 = 3;         //OUTPUTXBAR6ΪECAP1.OUT
//    OutputXbarRegs.OUTPUT6MUXENABLE.bit.Mux0   = 1;         //ʹOUTPUTXBAR6
//    EDIS;

	Drv_GPIO_SetupPinMux(30, GPIO_MUX_CPU1, 1);
	Drv_GPIO_SetupPinOptions(30, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_ASYNC));

	Drv_GPIO_SetupPinMux(31, GPIO_MUX_CPU1, 1);
	Drv_GPIO_SetupPinOptions(31, GPIO_OUTPUT, GPIO_PUSHPULL);

    // GPIO MONITOR_CAN CONFIG END

//	// GPIO TZ_CZ CONFIG BEGIN
//
//	Drv_GPIO_SetupPinMux(32, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(32, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 5us =120/120*5
//	EALLOW;
//	InputXbarRegs.INPUT1SELECT = 32;           // GPIO32 = TZ1
//	EDIS;
//	GpioCtrlRegs.GPBCTRL.bit.QUALPRD0 = 120;
//
//	// GPIO TZ_CZ CONFIG END

	Drv_GPIO_SetupPinMux(33, GPIO_MUX_CPU1, 0);					//NO_USE
	Drv_GPIO_SetupPinOptions(33, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(34, GPIO_MUX_CPU1, 0);					//CZ_LOW_SYN_OUT
	Drv_GPIO_SetupPinOptions(34, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO HI_SYN&LO_SYN CONFIG BEGIN

	Drv_GPIO_SetupPinMux(35, GPIO_MUX_CPU1, 0);
	Drv_GPIO_SetupPinOptions(35, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 10us =240/120*5
    // GPIO35õINPUT5ΪEXTSYNCIN1ʵָƵͬ
    EALLOW;
	 InputXbarRegs.INPUT5SELECT = 35;
	EDIS;
//
//	Drv_GPIO_SetupPinMux(36, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(36, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 10us =240/120*5
//    // GPIO36õINPUT7ΪECAP1룬ʵֹƵͬ
//    EALLOW;
//	InputXbarRegs.INPUT7SELECT = 36;
//	EDIS;

//	Drv_GPIO_SetupPinMux(37, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(37, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 10us =240/120*5
//    // GPIO36õINPUT7ΪECAP1룬ʵֹƵͬ
//    EALLOW;
//	InputXbarRegs.INPUT7SELECT = 37;
//	EDIS;

	// GPIO HI_SYN&LO_SYN CONFIG END
	
	// GPIO PARA_CAN CONFIG BEGIN

	Drv_GPIO_SetupPinMux(38, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(38, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(39, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(39, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_ASYNC));

	// GPIO PARA_CAN CONFIG END

	// GPIO HIAD_I2C CONFIG BEGIN

	Drv_GPIO_SetupPinMux(40, GPIO_MUX_CPU1, 0);
	Drv_GPIO_SetupPinOptions(40, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(41, GPIO_MUX_CPU1, 0);
	Drv_GPIO_SetupPinOptions(41, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO HIAD_I2C CONFIG END

	Drv_GPIO_SetupPinMux(42, GPIO_MUX_CPU1, 0);						//NO_USE
	Drv_GPIO_SetupPinOptions(42, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(43, GPIO_MUX_CPU1, 0);						//FANFAULT3
	Drv_GPIO_SetupPinOptions(43, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(44, GPIO_MUX_CPU1, 0);						//FANFAULT4
	Drv_GPIO_SetupPinOptions(44, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(45, GPIO_MUX_CPU1, 0);						//BUS_OP+
	Drv_GPIO_SetupPinOptions(45, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(46, GPIO_MUX_CPU1, 0);						//BUS_OP-
	Drv_GPIO_SetupPinOptions(46, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(47, GPIO_MUX_CPU1, 0);						//REPO
	Drv_GPIO_SetupPinOptions(47, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(48, GPIO_MUX_CPU1, 0);						//Dry Input1
	Drv_GPIO_SetupPinOptions(48, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPBCTRL.bit.QUALPRD2 = 24; 						// 1us =24/120*5

//	Drv_GPIO_SetupPinMux(49, GPIO_MUX_CPU1, 0);						//BMS_NRST
//	Drv_GPIO_SetupPinOptions(49, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO SPI_595 CONFIG BEGIN

	Drv_GPIO_SetupPinMux(50, GPIO_MUX_CPU1, 0);
	Drv_GPIO_SetupPinOptions(50, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(51, GPIO_MUX_CPU1, 0);						//NO_USE
	Drv_GPIO_SetupPinOptions(51, GPIO_OUTPUT, GPIO_PUSHPULL);

//	Drv_GPIO_SetupPinMux(52, GPIO_MUX_CPU1, 6);
//	Drv_GPIO_SetupPinOptions(52, GPIO_OUTPUT, GPIO_PUSHPULL);
    Drv_GPIO_SetupPinMux(52, GPIO_MUX_CPU1, 0);
    Drv_GPIO_SetupPinOptions(52, GPIO_OUTPUT, GPIO_PUSHPULL);

//	Drv_GPIO_SetupPinMux(53, GPIO_MUX_CPU1, 6);
//	Drv_GPIO_SetupPinOptions(53, GPIO_OUTPUT, GPIO_PUSHPULL);
    Drv_GPIO_SetupPinMux(53, GPIO_MUX_CPU1, 0);
    Drv_GPIO_SetupPinOptions(53, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO SPI_595 CONFIG END

//	Drv_GPIO_SetupPinMux(54, GPIO_MUX_CPU1, 0);			//BMS_SPI_CAN
//	Drv_GPIO_SetupPinOptions(54, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(55, GPIO_MUX_CPU1, 0);			//BMS_SPI_CAN
//	Drv_GPIO_SetupPinOptions(55, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
//	GpioCtrlRegs.GPBCTRL.bit.QUALPRD2 = 24;
//
//	Drv_GPIO_SetupPinMux(56, GPIO_MUX_CPU1, 0);			//BMS_SPI_CAN
//	Drv_GPIO_SetupPinOptions(56, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(57, GPIO_MUX_CPU1, 0);			//BMS_SPI_CAN
//	Drv_GPIO_SetupPinOptions(57, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(58, GPIO_MUX_CPU1, 0);			//BMS_SPI_CAN
//	Drv_GPIO_SetupPinOptions(58, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));

	// GPIO AD_CS CONFIG BEGIN

//	Drv_GPIO_SetupPinMux(AD4CS1, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD4CS1, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD4CS2, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD4CS2, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(ADBusCS, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(ADBusCS, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD2CS1, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD2CS1, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD2CS2, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD2CS2, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD8CS1, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD8CS1, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD8CS2, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD8CS2, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(AD8CS3, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(AD8CS3, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(ADParaCS, GPIO_MUX_CPU1, 0);
//	Drv_GPIO_SetupPinOptions(ADParaCS, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO AD_CS CONFIG END
	Drv_GPIO_SetupPinMux(68, GPIO_MUX_CPU1, 0);			//OK
	Drv_GPIO_SetupPinOptions(68, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD0 = 24;

	Drv_GPIO_SetupPinMux(69, GPIO_MUX_CPU1, 0);			//NO USE
	Drv_GPIO_SetupPinOptions(69, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD0 = 24;

	// GPIO RS485 CONFIG BEGIN
	Drv_GPIO_SetupPinMux(70, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(70, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(71, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(71, GPIO_INPUT, (GPIO_PULLUP+GPIO_QUAL3));	// 0.1us =24/120*2
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD0 = 24;

	// GPIO RS485 CONFIG END

	Drv_GPIO_SetupPinMux(72, GPIO_MUX_CPU1, 0);						//BOOT1
	Drv_GPIO_SetupPinOptions(72, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(73, GPIO_MUX_CPU1, 0);						//485OE
	Drv_GPIO_SetupPinOptions(73, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(74, GPIO_MUX_CPU1, 0);						//
	Drv_GPIO_SetupPinOptions(74, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(75, GPIO_MUX_CPU1, 0);						//ɫLED
	Drv_GPIO_SetupPinOptions(75, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(76, GPIO_MUX_CPU1, 0);						//SCR
	Drv_GPIO_SetupPinOptions(76, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(77, GPIO_MUX_CPU1, 0);						//װģʽѡ
	Drv_GPIO_SetupPinOptions(77, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD1 = 24;

	Drv_GPIO_SetupPinMux(78, GPIO_MUX_CPU1, 0);						//FANFAULT1
	Drv_GPIO_SetupPinOptions(78, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(79, GPIO_MUX_CPU1, 0);						//FANFAULT2
	Drv_GPIO_SetupPinOptions(79, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD1 = 24; 						// 1us =24/120*5

	Drv_GPIO_SetupPinMux(80, GPIO_MUX_CPU1, 0);						//̵
	Drv_GPIO_SetupPinOptions(80, GPIO_OUTPUT, GPIO_PUSHPULL);
//	objGPIODrv.Drv_GPIO_WritePin(OUTPUT_RLY,1);

	Drv_GPIO_SetupPinMux(81, GPIO_MUX_CPU1, 0);						//REVOUT2
	Drv_GPIO_SetupPinOptions(81, GPIO_OUTPUT, GPIO_PUSHPULL);
//
//	Drv_GPIO_SetupPinMux(82, GPIO_MUX_CPU1, 0);						//REVOUT3
//	Drv_GPIO_SetupPinOptions(82, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(83, GPIO_MUX_CPU1, 0);						//INPUT_RLY
	Drv_GPIO_SetupPinOptions(83, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(84, GPIO_MUX_CPU1, 0);								//BOOT0
	Drv_GPIO_SetupPinOptions(84, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD2 = 24; 						

	Drv_GPIO_SetupPinMux(85, GPIO_MUX_CPU1, 0);								//ưѡ2
	Drv_GPIO_SetupPinOptions(85, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD2 = 24;

//	Drv_GPIO_SetupPinMux(86, GPIO_MUX_CPU1, 0);								//PARASWITCH
//	Drv_GPIO_SetupPinOptions(86, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
//	GpioCtrlRegs.GPCCTRL.bit.QUALPRD2 = 24;

	Drv_GPIO_SetupPinMux(87, GPIO_MUX_CPU1, 0);								//WP
	Drv_GPIO_SetupPinOptions(87, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(88, GPIO_MUX_CPU1, 0);								//ɫLED
	Drv_GPIO_SetupPinOptions(88, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO SCI_DEBUG CONFIG BEGIN

	Drv_GPIO_SetupPinMux(89, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(89, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(90, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(90, GPIO_INPUT, (GPIO_PULLUP+GPIO_QUAL3));	// 0.1us =6/120*2
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD3 = 6;

	// GPIO SCI_DEBUG CONFIG END

	// GPIO E2 CONFIG BEGIN

	Drv_GPIO_SetupPinMux(91, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(91, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(92, GPIO_MUX_CPU1, 6);
	Drv_GPIO_SetupPinOptions(92, GPIO_OUTPUT, GPIO_PUSHPULL);

	// GPIO E2 CONFIG END

	Drv_GPIO_SetupPinMux(93, GPIO_MUX_CPU1, 0);								//ưѡ1
	Drv_GPIO_SetupPinOptions(93, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD3 = 24;

	Drv_GPIO_SetupPinMux(94, GPIO_MUX_CPU1, 0);								//ع
	Drv_GPIO_SetupPinOptions(94, GPIO_INPUT, (GPIO_PUSHPULL+GPIO_QUAL6));	// 1us =24/120*5
	GpioCtrlRegs.GPCCTRL.bit.QUALPRD3 = 24;

	Drv_GPIO_SetupPinMux(99, GPIO_MUX_CPU1, 0);								//ϸɽӵ1
	Drv_GPIO_SetupPinOptions(99, GPIO_OUTPUT, GPIO_PUSHPULL);

	Drv_GPIO_SetupPinMux(133, GPIO_MUX_CPU1, 0);							//NO_USE
	Drv_GPIO_SetupPinOptions(133, GPIO_OUTPUT, GPIO_PUSHPULL);

//	objGPIODrv.Drv_GPIO_WritePin(DRYFAULT1,0);
//	objGPIODrv.Drv_GPIO_WritePin(DRYFAULT2,0);
//	objGPIODrv.Drv_GPIO_WritePin(DRYFAULT3,0);
//	objGPIODrv.Drv_GPIO_WritePin(DCRLY1,0);
//	objGPIODrv.Drv_GPIO_WritePin(DCRLY2,0);
//	objGPIODrv.Drv_GPIO_WritePin(DCRLY3,0);
//
//    objGPIODrv.Drv_GPIO_WritePin(SOFTRLY,1);
//	objGPIODrv.Drv_GPIO_WritePin(OUTPUT_RLY,1);
//	objGPIODrv.Drv_GPIO_WritePin(PARASWITCH,0);
//	objGPIODrv.Drv_GPIO_WritePin(OUTPUT_SCR,0);
//	objGPIODrv.Drv_GPIO_WritePin(I2C_WP,0);
//	objGPIODrv.Drv_GPIO_WritePin(RS485_OE,0);       //״̬

}


// GPIO_SetupPinMux - Set the peripheral muxing for the specified pin. The
//                    appropriate parameters can be found in the GPIO Muxed
//                    Pins table(4.4) in the  datasheet. Use the GPIO index
//                    row (0 to 15) to select a muxing option for the GPIO.
void Class_GPIODrv::Drv_GPIO_SetupPinMux(Uint16 pin, Uint16 cpu, Uint16 peripheral)
{
    volatile Uint32 *gpioBaseAddr;
    volatile Uint32 *mux, *gmux, *csel;
    Uint16 pin32, pin16, pin8;

    pin32 = pin % 32;
    pin16 = pin % 16;
    pin8 = pin % 8;
    gpioBaseAddr = (Uint32 *)&GpioCtrlRegs + (pin/32)*GPY_CTRL_OFFSET;

    //Sanity check for valid cpu and peripheral values
    if (cpu > GPIO_MUX_CPU2CLA || peripheral > 0xF)
        return;

    //Create pointers to the appropriate registers. This is a workaround
    //for the way GPIO registers are defined. The standard definition
    //in the header file makes it very easy to do named accesses of one
    //register or bit, but hard to do arbitrary numerical accesses. It's
    //easier to have an array of GPIO modules with identical registers,
    //including arrays for multi-register groups like GPyCSEL1-4. But
    //the header file doesn't define anything we can turn into an array,
    //so manual pointer arithmetic is used instead.
    mux = gpioBaseAddr + GPYMUX + pin32/16;
    gmux = gpioBaseAddr + GPYGMUX + pin32/16;
    csel = gpioBaseAddr + GPYCSEL + pin32/8;

    //Now for the actual function
    EALLOW;
    //To change the muxing, set the peripheral mux to 0/GPIO first to avoid
    //glitches, then change the group mux, then set the peripheral mux to
    //its target value. Finally, set the CPU select. This procedure is
    //described in the TRM. Unfortunately, since we don't know the pin in
    //advance we can't hardcode a bitfield reference, so there's some
    //tricky bit twiddling here.
    *mux &= ~(0x3UL << (2*pin16));
    *gmux &= ~(0x3UL << (2*pin16));
    *gmux |= (Uint32)((peripheral >> 2) & 0x3UL) << (2*pin16);
    *mux |= (Uint32)(peripheral & 0x3UL) << (2*pin16);

    *csel &= ~(0x3L << (4*pin8));
    *csel |= (Uint32)(cpu & 0x3L) << (4*pin8);

    //WARNING: This code does not touch the analog mode select registers,
    //which are needed to give the USB module control of its IOs.
    EDIS;
}                                                   		


//Setup up the GPIO input/output options for the specified pin.
//The flags are a 16-bit mask produced by ORing together options.
//For input pins, the valid flags are:
//GPIO_PULLUP	Enable pull-up
//GPIO_INVERT	Enable input polarity inversion
//GPIO_SYNC		Synchronize the input latch to PLLSYSCLK (default -- you don't need to specify this)
//GPIO_QUAL3	Use 3-sample qualification
//GPIO_QUAL6	Use 6-sample qualification
//GPIO_ASYNC	Do not use synchronization or qualification
//(Note: only one of SYNC, QUAL3, QUAL6, or ASYNC is allowed)
//
//For output pins, the valid flags are:
//GPIO_OPENDRAIN	Output in open drain mode
//GPIO_PULLUP		If open drain enabled, also enable the pull-up
//and the input qualification flags (SYNC/QUAL3/QUAL6/SYNC) listed above.
//
//With no flags, the default input state is synchronous with no
//pull-up or polarity inversion. The default output state is
//the standard digital output.
void	Class_GPIODrv::Drv_GPIO_SetupPinOptions(Uint16 pin, Uint16 output, Uint16 flags)
{
    volatile Uint32 *gpioBaseAddr;
    volatile Uint32 *dir, *pud, *inv, *odr, *qsel;
    Uint32 pin32, pin16, pinMask, qual;

    pin32 = pin % 32;
    pin16 = pin % 16;
    pinMask = 1UL << pin32;
    gpioBaseAddr = (Uint32 *)&GpioCtrlRegs + (pin/32)*GPY_CTRL_OFFSET;

    //Create pointers to the appropriate registers. This is a workaround
    //for the way GPIO registers are defined. The standard definition
    //in the header file makes it very easy to do named accesses of one
    //register or bit, but hard to do arbitrary numerical accesses. It's
    //easier to have an array of GPIO modules with identical registers,
    //including arrays for multi-register groups like GPyQSEL1-2. But
    //the header file doesn't define anything we can turn into an array,
    //so manual pointer arithmetic is used instead.
    dir = gpioBaseAddr + GPYDIR;
    pud = gpioBaseAddr + GPYPUD;
    inv = gpioBaseAddr + GPYINV;
    odr = gpioBaseAddr + GPYODR;
    qsel = gpioBaseAddr + GPYQSEL + pin32/16;

    EALLOW;

    //Set the data direction
    *dir &= ~pinMask;
    if (output == 1)
    {
        //Output, with optional open drain mode and pull-up
        *dir |= pinMask;

        //Enable open drain if necessary
        if (flags & GPIO_OPENDRAIN)
            *odr |= pinMask;
        else
            *odr &= ~pinMask;

        //Enable pull-up if necessary. Open drain mode must be active.
        if (flags & (GPIO_OPENDRAIN | GPIO_PULLUP))
            *pud &= ~pinMask;
        else
            *pud |= pinMask;
    } else
    {
        //Input, with optional pull-up, qualification, and polarity inversion
        *dir &= ~pinMask;

        //Enable pull-up if necessary
        if (flags & GPIO_PULLUP)
            *pud &= ~pinMask;
        else
            *pud |= pinMask;

        //Invert polarity if necessary
        if (flags & GPIO_INVERT)
            *inv |= pinMask;
        else
            *inv &= ~pinMask;
    }

    //Extract the qualification parameter and load it into the register. This is
    //also needed for open drain outputs, so we might as well do it all the time.
    qual = (flags & GPIO_ASYNC) / GPIO_QUAL3;
    *qsel &= ~(0x3L << (2 * pin16));
    if (qual != 0x0)
        *qsel |= qual << (2 * pin16);
    EDIS;
}

//Set the GPyDAT register bit for the specified pin.
void	Class_GPIODrv:: Drv_GPIO_WritePin(Uint16 pin, Uint16 outVal)
{
	volatile Uint32 *gpioDataReg;
	Uint32 pinMask;

	gpioDataReg = (volatile Uint32 *)&GpioDataRegs + (pin/32)*GPY_DATA_OFFSET;
	pinMask = 1UL << (pin % 32);

	if (outVal == 0)
		gpioDataReg[GPYCLEAR] = pinMask;
	else
		gpioDataReg[GPYSET] = pinMask;
}

//Read the GPyDAT register bit for the specified pin. Note that this returns
//the actual state of the pin, not the state of the output latch.
Uint16 Class_GPIODrv::GPIO_ReadPin(Uint16 pin)
{
	volatile Uint32 *gpioDataReg;
	Uint16 pinVal;

	gpioDataReg = (volatile Uint32 *)&GpioDataRegs + (pin/32)*GPY_DATA_OFFSET;
	pinVal = (gpioDataReg[GPYDAT] >> (pin % 32)) & 0x1;

	return pinVal;
}


//============================================================
// End of file.
//============================================================
