/*==========================================================*/
/* Title		:	TimerDrv.h								*/
/* Description	: 	Class_TimerDrv definition				*/
/* Date			:	Oct.2007								*/
/* Author		:  duwenping								*/
/*==========================================================*/
#ifndef TIMERDRV_H
#define TIMERDRV_H


struct StructTimerFlag
{
	UINT16	u16_b100ms					:1;					//BIT0  1:100msʱ䵽
	UINT16	u16_b40ms					:1;					//BIT1	1:40msʱ䵽
	UINT16	u16_b20ms					:1;					//BIT2	1:20msʱ䵽
	UINT16	u16_b10ms					:1;					//BIT3	1:10msʱ䵽
	
	UINT16	u16_b14ms					:1;					//BIT4	1:10msʱ䵽
	UINT16	u16_b4ms					:1;					//BIT5	1:4msʱ䵽
	UINT16	u16_b1ms					:1;					//BIT6	1:1msʱ䵽
	UINT16	u16_b1s					    :1;				    //BIT7	1:1sʱ䵽
	
	UINT16	u16_b10min					:1;				    //BIT8	1:10minʱ䵽
	UINT16	u16_b1hr					:1;					//BIT9	1:1h
	UINT16	bPowerOn3sEnd				:1;					//BIT10	ϵ3s
	UINT16	bPowerOn8sEnd				:1;					//BIT11	ϵ8s

	UINT16  bPowerOn10sEnd              :1;                 //BIT11 ϵ10s
	UINT16	u16_b5ms					:1;					//BIT3	1:10msʱ䵽
	UINT16	bModeChange3sDelay  		:1;					//ģʽת3sʱ
	UINT16  bModeChange6sDelay          :1;                 //ģʽת6sʱ

};

#define	Fint		80000									//int frequency is 80K,the times of enter int in 1s
#define	K1sCnst	    80000									//1*80000 = 80000
#define	K100msCnst	8000									//0.1*80000 = 8000
#define	K40msCnst	3200									//0.04*80000 = 3200
#define	K20msCnst	1600										//0.02*80000 = 1600
#define	K14msCnst	1120										//0.014*80000 = 1120
#define	K10msCnst	800										//0.01*80000 = 800
#define	K5msCnst	400										//0.005*80000 = 400
#define	K4msCnst	320										//0.004*80000 = 320
#define	K2msCnst	160										//0.002*80000 = 160
#define	K1msCnst 	80										//0.001*80000 = 80
#define	K100usCnst 	8										//0.0001*80000 = 8
#define TICK_5MS_PRD 5000   //Tick=5ms

struct CPUTIMER_VARS {
   volatile struct  CPUTIMER_REGS  *RegsAddr;
   Uint32    InterruptCount;
   float   CPUFreqInMHz;
   float   PeriodInUSec;
};


//============================================================
//	Class_TimerDrvⲿĽӿ
//	1)
//	2)
//============================================================
class Class_TimerDrv
{
//	private:
	public:
		struct StructTimerFlag	m_st_TimerFlag;				//ʱӱ־

		struct CPUTIMER_VARS CpuTimer0;
		struct CPUTIMER_VARS CpuTimer1;
        struct CPUTIMER_VARS CpuTimer2;
	
		UINT16	m_u16_Clk1sCnt;							    //1sʱ
		UINT16	m_u16_Clk100msCnt;							//100msʱ
		UINT16	m_u16_Clk40msCnt;							//40msʱ
		UINT16	m_u16_Clk20msCnt;							//20msʱ
		UINT16	m_u16_Clk14msCnt;							//14msʱ
		UINT16	m_u16_Clk10msCnt;							//10msʱ
		UINT16	m_u16_Clk5msCnt;							//5msʱ
		UINT16	m_u16_Clk4msCnt;							//4msʱ
		UINT16	m_u16_Clk1msCnt;							//1msʱ
		UINT16 	m_u16_10msecCnt;				            //;10ms
		
		UINT16	m_u16_TimerCnt;								//жмÿж+1

		UINT32	m_u32_ClkIntStart_0;						// жϿʼʱCPUʱֵ
		UINT16	m_u16_ClkUsBack;							// ʱӵλݣڼӶʱж
		UINT16	m_u16_ClkUs_0;								// ʱӵλ,100us
		UINT16	m_u16_ClkS_0;								// ʱӵλ,1s :6000*166.7uS
		UINT16	m_u16_ClkH_0;								// ʱӵλ,1h :3600*1S
		UINT16	m_u16_Clk1hrCnt; 							//һСʱ
		UINT16	m_u16_Clk1minCnt; 							//һӼ

		UINT16	m_i16_PowerOnCnt;
		UINT16  m_i16_Tick5msBak;
		INT16  	m_i16_Tick5msState;

		UINT16  m_i16_ModeChangeTimeDelayCnt;
	public:

        UINT16  m_i16_GridConnectedModeBak;
//		void	Drv_Init(void);								//ʼ
		inline		void	Drv_Int_ClockMaintain(void);				//жʱά
		void	Drv_ClockMaintain(void);					//ʱά
		void 	Drv_usDelay(INT32 Count);
		void	Drv_CPUTimerInit(void);
		void Drv_ConfigCpuTimer(struct CPUTIMER_VARS *Timer, float Freq, float Period);

		void    Drv_TimerInit();

/*		inline	INT16	Drv_100msCome(void);				//100msʱӵ1
		inline	INT16	Drv_40msCome(void);					//40msʱӵ1
		inline	INT16	Drv_20msCome(void);					//20msʱӵ1
		inline	INT16	Drv_14msCome(void);					//14msʱӵ1
		inline	INT16	Drv_10msCome(void);					//10msʱӵ1
		inline	INT16	Drv_4msCome(void);					//4msʱӵ1
		inline	INT16	Drv_1msCome(void);					//1msʱӵ1
		inline	struct StructTimerFlag Drv_TimerFlagGet(void);	//ظʱ־
*/		void	App_PowerOn10sDelay(void);					//ϵͳά
        void    App_ModeChangeTimeDelay(void);
		
		inline	INT16	Drv_GetTimerCnt(void);				//ʱӼSCI
		friend	class	Class_Debug;
};

#endif
//============================================================
// End of file.
//============================================================
