
#include "Drv_WatchDog.h"

void	Class_WatchDogDrv::Drv_Init(void)
{
	
}

//
// ServiceDog - This function resets the watchdog timer.
//
// Enable this function for using ServiceDog in the application.
//
void Class_WatchDogDrv::ServiceDog(void)
{
    EALLOW;
    WdRegs.WDKEY.bit.WDKEY = 0x0055;
    WdRegs.WDKEY.bit.WDKEY = 0x00AA;
    EDIS;
}

// This function disables the watchdog timer.
void Class_WatchDogDrv::Drv_DisableDog(void)
{
    volatile Uint16 temp;
    // Grab the clock config first so we don't clobber it
    EALLOW;
    temp = WdRegs.WDCR.all & 0x0007;
    WdRegs.WDCR.all = 0x0068 | temp;
    EDIS;
}

// This function enables the watchdog timer.
void Class_WatchDogDrv::Drv_EnableDog(void)
{
 	EALLOW;
	WdRegs.WDCR.all = 0x0028;
	EDIS;
}



//============================================================
// End of file.
//============================================================
