#include "cpu1_board.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    SYNC_init();
//    EPWM_init();
    GPIO_init();
    IPC_SYSCFG_init();
//    INTERRUPT_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    //
    // PinMux for modules assigned to CPU1
    //

    //
    // EPWM5 -> myEPWM5 Pinmux
    //
    GPIO_setPinConfig(mEPWM5_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(mEPWM5_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mEPWM5_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(mEPWM5_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(mEPWM5_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mEPWM5_EPWMB_GPIO, GPIO_QUAL_SYNC);

    // GPIO90 -> myGPIO90 Pinmux
    GPIO_setPinConfig(GPIO_90_GPIO90);
    // GPIO6 -> myGPIO6 Pinmux
    GPIO_setPinConfig(GPIO_6_GPIO6);
    // GPIO2 -> myGPIO2 Pinmux
    GPIO_setPinConfig(GPIO_2_GPIO2);

}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){

    //
    // set EPWM module clock is PLLSYSCLK(200M), 28377(100M)
    //
    SysCtl_setEPWMClockDivider(SYSCTL_EPWMCLK_DIV_1);

    //
    // Disable sync
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // sets the pre-scaler(divider)value for the time base clock
    //
    EPWM_setClockPrescaler(EPWM5_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);

    //
    // Write to TBPHS bit
    //
    EPWM_setPhaseShift(EPWM5_BASE, 0);

    //! This function enables loading of phase shift when the appropriate sync
    //! event occurs.
    EPWM_enablePhaseShiftLoad(EPWM5_BASE);

    //
    // Initially disable Free/Soft Bits
    //
//    EPWM_setEmulationMode(EPWM5_BASE, EPWM_EMULATION_STOP_AFTER_FULL_CYCLE);
    EPWM_setEmulationMode(EPWM5_BASE, EPWM_EMULATION_STOP_AFTER_NEXT_TB);

    //
    // Setup TBCLK
    //
    EPWM_setTimeBasePeriod(EPWM5_BASE, mEPWM5_TBPRD);
    EPWM_setTimeBaseCounterMode(EPWM5_BASE, EPWM_COUNTER_MODE_UP_DOWN);

    //
    // TBCTL[PHSDIR = 1]
    //
    EPWM_setCountModeAfterSync(EPWM5_BASE, EPWM_COUNT_MODE_UP_AFTER_SYNC);

    EPWM_setTimeBaseCounter(EPWM5_BASE, 0U);

    //
    // CompareA event at half of period
    //
    EPWM_setCounterCompareValue(EPWM5_BASE, EPWM_COUNTER_COMPARE_A,
                                mEPWM5_TBPRD/2);

    //
    // Action Qualifiers : Set on CMPA, Clear on PRD
    //
    EPWM_setActionQualifierAction(EPWM5_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM5_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

    //
    // Ӹ޷ж
    //
    EPWM_setPeriodLoadMode(EPWM5_BASE, EPWM_PERIOD_DIRECT_LOAD);

    //
    // Configure interrupt on event CTR=ZERO
    //
    EPWM_setInterruptSource(EPWM5_BASE, EPWM_INT_TBCTR_ZERO_OR_PERIOD);
    EPWM_enableInterrupt(EPWM5_BASE);
    EPWM_setInterruptEventCount(EPWM5_BASE, 1);

    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
void GPIO_init(){
    mGPIO90_init();
    mGPIO6_init();
    mGPIO2_init();
}

void mGPIO90_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED1, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED1, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED1, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(mGPIO_PIN_LED1, GPIO_CORE_CM);
}
void mGPIO6_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED2, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED2, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED2, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(mGPIO_PIN_LED2, GPIO_CORE_CPU2);
}
void mGPIO2_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED3, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED3, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED3, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(mGPIO_PIN_LED3, GPIO_CORE_CPU1);
}

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init(){

    // Interrupt Setings for INT_mEPWM5
    Interrupt_register(INT_mEPWM5, &INT_mEPWM5_ISR);
    Interrupt_enable(INT_mEPWM5);

}



//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
void IPC_SYSCFG_init(){
    //
    // Paste the following line in your main() function after device_init, if you would like CPU2 to boot
    // Device_bootCPU2(BOOT_MODE_CPU2);
    //
}

//void IPC

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************
void SYNC_init(){
    //
    // EPWM5SYNCOUT --> EXTSYNCOUT
    //
//    SysCtl_setSyncOutputConfig(SYSCTL_SYNC_OUT_SRC_EPWM5SYNCOUT);
    //
    // SOCA
    //
    SysCtl_enableExtADCSOCSource(0);
    //
    // SOCB
    //
    SysCtl_enableExtADCSOCSource(0);
}
