
#ifndef CPU1_BOARD_H_
#define CPU1_BOARD_H_

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM5 -> myEPWM5 Pinmux
//
//
// EPWM5A - GPIO Settings
//
#define GPIO_PIN_EPWM5A 153
#define mEPWM5_EPWMA_GPIO 153
#define mEPWM5_EPWMA_PIN_CONFIG GPIO_153_EPWM5A
//
// EPWM5B - GPIO Settings
//
#define GPIO_PIN_EPWM5B 154
#define mEPWM5_EPWMB_GPIO 154
#define mEPWM5_EPWMB_PIN_CONFIG GPIO_154_EPWM5B
//
// GPIO90 - GPIO Settings
//
#define mGPIO90_GPIO_PIN_CONFIG GPIO_90_GPIO90
//
// GPIO6 - GPIO Settings
//
#define mGPIO6_GPIO_PIN_CONFIG GPIO_6_GPIO6
//
// GPIO2 - GPIO Settings
//
#define mGPIO2_GPIO_PIN_CONFIG GPIO_2_GPIO2

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define mEPWM5_TBPRD 12500
#define mEPWM5_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define mEPWM5_TBPHS 0
#define mEPWM5_CMPA 0
#define mEPWM5_CMPB 0
#define mEPWM5_CMPC 0
#define mEPWM5_CMPD 0
#define mEPWM5_DBRED 0
#define mEPWM5_DBFED 0
#define mEPWM5_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define mEPWM5_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define mEPWM5_INTERRUPT_SOURCE EPWM_INT_TBCTR_ZERO_OR_PERIOD

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************

//
// LED TEST
//
#define mGPIO_PIN_LED1  90
void mGPIO90_init();
#define mGPIO_PIN_LED2  6
void mGPIO6_init();
#define mGPIO_PIN_LED3  2
void mGPIO2_init();


//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for INT_myEPWM5
#define INT_mEPWM5 INT_EPWM5
#define INT_mEPWM5_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP3
extern __interrupt void INT_mEPWM5_ISR(void);


//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
#define BOOT_MODE_CPU2 BOOTMODE_BOOT_TO_FLASH_SECTOR0
#define IPC_SYNC IPC_FLAG31

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void    Board_init();
void    EPWM_init();
void    GPIO_init();
void    INTERRUPT_init();
void    IPC_SYSCFG_init();
void    SYNC_init();
void    PinMux_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************



#endif /* CPU1_BOARD_H_ */
