/*
 * comm_Drv832x.c
 *
 *  Created on: 202342
 *      Author: XZ
 */


#include "comm_Drv832x.h"



void spi_gpioMux(void)

    {

    //Pin Config SPIB low speed
    EALLOW;
/*
    GpioCtrlRegs.GPBPUD.bit.GPIO58 = 0;  // Enable pull-up on GPIO58 (SPIB_CLK)
    GpioCtrlRegs.GPBPUD.bit.GPIO59 = 0;  // Enable pull-up on GPIO59 (SPIB_CS)
    GpioCtrlRegs.GPBPUD.bit.GPIO60 = 0;  // Enable pull-up on GPIO60 (SPIB_SIMO)
    GpioCtrlRegs.GPBPUD.bit.GPIO61 = 0;  // Enable pull-up on GPIO61 (SPIB_SOMI)

    GpioCtrlRegs.GPBQSEL2.bit.GPIO58 = 3; // Asynch input GPIO58 (SPIB_CLK)
    GpioCtrlRegs.GPBQSEL2.bit.GPIO59 = 3; // Asynch input GPIO59 (SPIB_CS)
    GpioCtrlRegs.GPBQSEL2.bit.GPIO60 = 3; // Asynch input GPIO60 (SPIB_SIMO)
    GpioCtrlRegs.GPBQSEL2.bit.GPIO61 = 3; // Asynch input GPIO61 (SPIB_SOMI)

    GpioCtrlRegs.GPBMUX2.bit.GPIO58 = 6; // Configure GPIO58 (SPIB_CLK)
    GpioCtrlRegs.GPBMUX2.bit.GPIO59 = 6; // Configure GPIO59 (SPIB_CS)
    GpioCtrlRegs.GPBMUX2.bit.GPIO60 = 6; // Configure GPIO60 (SPIB_SIMO)
    GpioCtrlRegs.GPBMUX2.bit.GPIO61 = 6; // Configure GPIO61 (SPIB_SOMI)
    */

    // SPIB_CLK
    GPIO_SetupPinOptions(58, GPIO_OUTPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPIB_CS
    GPIO_SetupPinOptions(59, GPIO_OUTPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPIB_SIMO
    GPIO_SetupPinOptions(60, GPIO_OUTPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPIB_SOMI
    GPIO_SetupPinOptions(61, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);

    GPIO_SetupPinMux(58, GPIO_MUX_CPU1, 6);
    GPIO_SetupPinMux(59, GPIO_MUX_CPU1, 6);
    GPIO_SetupPinMux(60, GPIO_MUX_CPU1, 6);
    GPIO_SetupPinMux(61, GPIO_MUX_CPU1, 6);



    /*
    //ΪA
    //SPI SIMOA
    GPIO_SetupPinOptions(58, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_OMIA
    GPIO_SetupPinOptions(59, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_CLKA
    GPIO_SetupPinOptions(60, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_STEA
    GPIO_SetupPinOptions(61, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);

    GPIO_SetupPinMux(58, GPIO_MUX_CPU1, 15);
    GPIO_SetupPinMux(59, GPIO_MUX_CPU1, 15);
    GPIO_SetupPinMux(60, GPIO_MUX_CPU1, 15);
    GPIO_SetupPinMux(61, GPIO_MUX_CPU1, 15);
    */

    EDIS;

    EALLOW;
    ClkCfgRegs.LOSPCP.all = 0;
    EDIS;

    }




void spi_FifoInit(volatile struct SPI_REGS* SpiRegs)
{
        ASSERT(spiRegs != NULL);
        //SPIRST SPIFFENA SPITXFIFO TXFFINTCLR = 1
        SpiRegs->SPIFFTX.all=0xE040;//1110 0000 0100 0000
        //RXFIFORESET RXFFINTCLR ???Ǻ
        SpiRegs->SPIFFRX.all=0x2044;//0010 0000 0100 0100
        //FIFO Transmit Delay Bits = 0
        SpiRegs->SPIFFCT.all=0x0;
}


void spi_config(volatile struct SPI_REGS* SpiRegs)

{

    ASSERT(spiRegs != NULL);
    //SPI Settings
    SpiRegs->SPICCR.bit.SPISWRESET = 0; //SPI Reset On
    SpiRegs->SPICCR.bit.CLKPOLARITY = 0; //SCLK Active High
    SpiRegs->SPICCR.bit.SPICHAR = 0xF; //16-bit SPI char
    SpiRegs->SPICCR.bit.SPILBK = 0;

    SpiRegs->SPICTL.bit.OVERRUNINTENA = 0; //No overrun interrupt
    SpiRegs->SPICTL.bit.CLK_PHASE = 0; //Phase 0
    SpiRegs->SPICTL.bit.MASTER_SLAVE = 1; //Main mode, variable name not yet updated with current nomenclature
    SpiRegs->SPICTL.bit.TALK = 1; //nSCS enabled
    SpiRegs->SPICTL.bit.SPIINTENA = 0; //TX/RX Interrupt Disabled

    SpiRegs->SPIBRR.bit.SPI_BIT_RATE = ((200E6 / 4) / 500E3) - 1;//((25000000 / 1000000) - 1); //Set baud rate to 1MHz
    SpiRegs->SPIPRI.bit.FREE = 1; //Set so breakpoints don't disturb transmission
    SpiRegs->SPICCR.bit.SPISWRESET = 1; //Exit SPI reset


}


void comm_spiInit(volatile struct SPI_REGS* SpiRegs)
{
   // spi_gpioMux();
    spi_FifoInit(SpiRegs);
    spi_config(SpiRegs);
}

/*
void Config_evm_spi(void)
    {
    //Pin Config
    EALLOW;
    // SPI_MOSI
    GPIO_SetupPinOptions(16, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_MISO
    GPIO_SetupPinOptions(17, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_CS
    GPIO_SetupPinOptions(56, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);
    // SPI_CLK
    GPIO_SetupPinOptions(57, GPIO_INPUT, GPIO_ASYNC | GPIO_PULLUP);

    GPIO_SetupPinMux(16, GPIO_MUX_CPU1, 1);
    GPIO_SetupPinMux(17, GPIO_MUX_CPU1, 1);
    GPIO_SetupPinMux(56, GPIO_MUX_CPU1, 1);
    GPIO_SetupPinMux(57, GPIO_MUX_CPU1, 1);
    EDIS;

    EALLOW;
    ClkCfgRegs.LOSPCP.all = 0;
    EDIS;

    // Initialize SPI FIFO registers
    SpiaRegs.SPIFFTX.all=0xE040;
    SpiaRegs.SPIFFRX.all=0x2044;
    SpiaRegs.SPIFFCT.all=0x0;

    //SPI Settings
    SpiaRegs.SPICCR.bit.SPISWRESET = 0; //SPI Reset On
    SpiaRegs.SPICCR.bit.CLKPOLARITY = 0; //SCLK Active High
    SpiaRegs.SPICCR.bit.SPICHAR = 0xF; //16-bit SPI char
    SpiaRegs.SPICCR.bit.SPILBK = 0;

    SpiaRegs.SPICTL.bit.OVERRUNINTENA = 0; //No overrun interrupt
    SpiaRegs.SPICTL.bit.CLK_PHASE = 0; //Phase 0
    SpiaRegs.SPICTL.bit.MASTER_SLAVE = 1; //Main mode, variable name not yet updated with current nomenclature
    SpiaRegs.SPICTL.bit.TALK = 0; //nSCS enabled
    SpiaRegs.SPICTL.bit.SPIINTENA = 0; //TX/RX Interrupt Disabled

    SpiaRegs.SPIBRR.bit.SPI_BIT_RATE = ((25000000 / 1000000) - 1); //Set baud rate to 1MHz
    SpiaRegs.SPIPRI.bit.FREE = 1; //Set so breakpoints don't disturb transmission
    SpiaRegs.SPICCR.bit.SPISWRESET = 1; //Exit SPI reset

}

*/
/*
Uint16 spi_xmit(Uint16 spiFrame)

{

   SpiaRegs.SPITXBUF=spiFrame;



   //Wait for RX flag to indicate SPI frame completion

   while(SpiaRegs.SPIFFRX.bit.RXFFST != 1)

   {
   }
   return SpiaRegs.SPIRXBUF;
}



Uint16 spi_read(Uint16 addr)

{

   Uint16 commandword = (0x8000 | (addr << 11));

   return spi_xmit(commandword);

}



Uint16 spi_write(Uint16 addr, Uint16 data)

{

   Uint16 commandword = ((addr << 11) | data);

   return spi_xmit(commandword);

}
*/

