#include "F28x_Project.h"
#include "device.h"
#include "math.h"

///////////DCan////////////////////////////
typedef struct{
    Uint32 cob_id_ext:18;
    Uint32 cob_id:11;
    Uint32 rtr:1;
    Uint32 rsvd1:2;
}CanFrameIdStr;

typedef union{
    Uint32 frame_id;
    CanFrameIdStr strct;
}CanFrameId;

typedef struct{
    CanFrameId id;
    Uint8 len;
    Uint32  hdata;
    Uint32  ldata;
}CanFrame;



//////////////////////////////////////////////////
void InitCan(void);

int CanAppTx(int no,CanFrame *tx_frame);
int CanAppRx(int no,CanFrame *rx_frame);

//
uint16_t Save_data;
uint16_t can_tx_result;
uint16_t can_rx_result;

CanFrame tx_data;
CanFrame rx_data;


void main(void)
{
    // ʼʱӺ Initialize device clock and peripherals
    Device_init();
    // InitSysCtrl();  //̲ʹüĴInitSysCtrl();ʼ

    /*//⺯
    // ʼGPIOΪ Initialize GPIO and configure the GPIO pin as a push-pull output
    Device_initGPIO();
    */
    InitGpio();  //Ĵָ

    //
    InitCan();

    // ʼPIEPIEĴرCPUж
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    Interrupt_initModule();

    // ʼPIE
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    Interrupt_initVectorTable();

    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    EINT;
    ERTM;

    for(;;)
    {
        //
        tx_data.ldata =0x1234;
        tx_data.hdata =0x4567;
        tx_data.len   =8;
        tx_data.id.frame_id = 0x256;

        can_tx_result = CanAppTx(0,&tx_data);


        //
        can_rx_result = CanAppRx(0,&rx_data);

    }
}

/////////////////////////////DCan////////////////////////////
void InitCan( void )
{
    int i;

    EALLOW;
    //*************************************************
    //CAN_B_RX
    //mux = 2(0010)
    GpioCtrlRegs.GPAGMUX1.bit.GPIO13       = 0x0;//10
    GpioCtrlRegs.GPAMUX1.bit.GPIO13        = 0x2;//10
    GpioCtrlRegs.GPADIR.bit.GPIO13         = 0x0; //Ϊ
    GpioCtrlRegs.GPAPUD.bit.GPIO13         = 0x0; //ʹ

    //CAN_B_TX
    //mux = 2(0010)
    GpioCtrlRegs.GPAGMUX1.bit.GPIO12       = 0x0;//10
    GpioCtrlRegs.GPAMUX1.bit.GPIO12        = 0x2;//10
    GpioCtrlRegs.GPADIR.bit.GPIO12         = 0x1; //Ϊ
    GpioCtrlRegs.GPAPUD.bit.GPIO12        = 0x0; //ʹ

    //ʼʼ*************************************************
    CanbRegs.CAN_CTL.bit.Init   = 1;
    CanbRegs.CAN_CTL.bit.CCE  = 1;
    /*üĴд򣬽arbmctlдϢ*/
    //CAN_IF1CMD
    while(CanbRegs.CAN_IF1CMD.bit.Busy)
    {
        ;
    }
    CanbRegs.CAN_IF1CMD.bit.DIR       = 1;
    CanbRegs.CAN_IF1CMD.bit.Mask      = 1;
    CanbRegs.CAN_IF1CMD.bit.Arb       = 1;
    CanbRegs.CAN_IF1CMD.bit.Control   = 1;
    CanbRegs.CAN_IF1MSK.all           = 0;
    CanbRegs.CAN_IF1ARB.bit.MsgVal    = 1;
    CanbRegs.CAN_IF1MCTL.bit.UMask    = 1;
    //CAN_IF2CMD
    while(CanbRegs.CAN_IF2CMD.bit.Busy)
    {
        ;
    }
    CanbRegs.CAN_IF2CMD.bit.DIR       = 1;
    CanbRegs.CAN_IF2CMD.bit.Mask      = 1;
    CanbRegs.CAN_IF2CMD.bit.Arb       = 1;
    CanbRegs.CAN_IF2CMD.bit.Control   = 1;
    CanbRegs.CAN_IF2MSK.all           = 0;
    CanbRegs.CAN_IF2ARB.bit.MsgVal    = 1;
    CanbRegs.CAN_IF2ARB.bit.Dir       = 1;
    CanbRegs.CAN_IF2MCTL.bit.UMask    = 1;
    CanbRegs.CAN_IF2MCTL.bit.RmtEn    = 1;

    /*1-16ǽգ17-32Ƿ*/
    for(i=1;i<=16;i++)
    {
        CanbRegs.CAN_IF1CMD.bit.MSG_NUM =i;
        while(CanbRegs.CAN_IF1CMD.bit.Busy)
        {
            ;
        }

        CanbRegs.CAN_IF2CMD.bit.MSG_NUM =i + 16;
        while(CanbRegs.CAN_IF2CMD.bit.Busy)
        {
            ;
        }
    }

    /*һΪEOB,ʾfifoĩβ*/
    CanbRegs.CAN_IF1MCTL.bit.EoB    = 1;
    CanbRegs.CAN_IF2MCTL.bit.EoB    = 1;

    CanbRegs.CAN_IF1CMD.bit.MSG_NUM =16;
    while(CanbRegs.CAN_IF1CMD.bit.Busy)
    {
        ;
    }

    CanbRegs.CAN_IF2CMD.bit.MSG_NUM =32;
    while(CanbRegs.CAN_IF2CMD.bit.Busy)
    {
        ;
    }

    /*üĴmctlintpndnewdatλ*/

    CanbRegs.CAN_IF1CMD.bit.TXRQST       = 1;
    CanbRegs.CAN_IF1CMD.bit.ClrIntPnd    = 1;

    CanbRegs.CAN_IF2CMD.bit.TxRqst       = 1;
    CanbRegs.CAN_IF2CMD.bit.ClrIntPnd    = 1;

    for(i=1;i<=16;i++)
    {
        CanbRegs.CAN_IF1CMD.bit.MSG_NUM =i;
        while(CanbRegs.CAN_IF1CMD.bit.Busy)
        {
            ;
        }

        CanbRegs.CAN_IF2CMD.bit.MSG_NUM =i + 16;
        while(CanbRegs.CAN_IF2CMD.bit.Busy)
        {
            ;
        }

    }


    volatile  Uint32  discardRead  = CanbRegs.CAN_ES.all;  //Ϣ

    /*500k*/

    ClkCfgRegs.CLKSRCCTL2.bit.CANBBCLKSEL = 0;  //ڲʱ100MHz

    CanbRegs.CAN_BTR.bit.BRP      = 9;
    CanbRegs.CAN_BTR.bit.TSEG1    = 10;
    CanbRegs.CAN_BTR.bit.TSEG2    = 7;
    CanbRegs.CAN_BTR.bit.SJW      =3;



    //
    CanbRegs.CAN_CTL.bit.DAR  = 1;
    CanbRegs.CAN_CTL.bit.ABO  = 1;

    //ɸλ
    CanbRegs.CAN_CTL.bit.Init  = 0;
    CanbRegs.CAN_CTL.bit.CCE  = 0;

    EDIS;

}
//****************************************************
int CanAppTx(int no,CanFrame *tx_frame)
{
    Uint32 regbase;
    Uint32 cmd_regdata=0;
    Uint32 arb_regdata=0;
    Uint32 mctl_regdata=0;
    Uint32 dataA=0,dataB=0;

    int i,j;
    if(no==0)
    {
        //regbase = CANA_BASE;
    }
    else
    {
        //regbase = CANB_BASE;
    }

    //λ
    if(CanbRegs.CAN_ES.bit.EWarn)
    {
        CanbRegs.CAN_CTL.bit.Init = 1;
        CanbRegs.CAN_CTL.bit.SWR  = 1;
        CanbRegs.CAN_CTL.bit.DAR  = 1;
        CanbRegs.CAN_CTL.bit.ABO  = 1;
        CanbRegs.CAN_CTL.bit.Init = 0;
        return(0);
    }


    //
    while(CanbRegs.CAN_IF1CMD.bit.Busy)
    {
        ;
    }
    CanbRegs.CAN_IF1CMD.bit.Arb      = 1;
    CanbRegs.CAN_IF1CMD.bit.Mask     = 1;
    CanbRegs.CAN_IF1CMD.bit.Control  = 1;
    /*17-32ѰҿԷ͵*/
    for(i=17;i<=32;i++)
    {
        CanbRegs.CAN_IF1CMD.bit.MSG_NUM = i;
        while(CanbRegs.CAN_IF1CMD.bit.Busy)
        {
            ;
        }
        if(CanbRegs.CAN_IF1MCTL.bit.TxRqst==0)
        {
            break;
        }
    }

    if(i>=33)
    {
        return(-1);
    }

    /*ȡǰϢ*/
    CanbRegs.CAN_IF1CMD.bit.Control = 1;
    CanbRegs.CAN_IF1CMD.bit.MSG_NUM = i;
    while(CanbRegs.CAN_IF1CMD.bit.Busy)
    {
        ;
    }

    //
    CanbRegs.CAN_IF1CMD.bit.DIR = 1;
    CanbRegs.CAN_IF1CMD.bit.Arb = 1;
    CanbRegs.CAN_IF1CMD.bit.Control = 1;
    CanbRegs.CAN_IF1CMD.bit.DATA_A =1;
    CanbRegs.CAN_IF1CMD.bit.DATA_B =1;
    if(tx_frame->id.strct.rtr==0)
    {
        CanbRegs.CAN_IF1ARB.bit.Dir =1;
        CanbRegs.CAN_IF1ARB.bit.MsgVal =1;
        CanbRegs.CAN_IF1ARB.bit.ID = tx_frame->id.frame_id;
        CanbRegs.CAN_IF1MCTL.bit.TxRqst =0;
        CanbRegs.CAN_IF1MCTL.bit.DLC = tx_frame->len;
        CanbRegs.CAN_IF1MCTL.bit.TxRqst =1;
        //
        for(j=0;j<4;j++)
        {
            dataA = dataA<<8;
            dataA |= (tx_frame->hdata>>(j<<3))&0x0FF;
        }

        for(j=0;j<4;j++)
        {
            dataB = dataB<<8;
            dataB |= (tx_frame->ldata>>(j<<3))&0x0FF;
        }

    }
    else
    {
        CanbRegs.CAN_IF1MCTL.bit.DLC = tx_frame->len;
        CanbRegs.CAN_IF1MCTL.bit.TxRqst = 1;
    }
    //
    CanbRegs.CAN_IF1CMD.bit.MSG_NUM = i;
    while(CanbRegs.CAN_IF1CMD.bit.Busy)
    {
        ;
    }

}

//********************************************************
/*1---rcv ok 0---no msg -1---msg lost*/
int CanAppRx(int no,CanFrame *rx_frame)
{
    Uint32 cmd_regdata=0;
    Uint32 arb_regdata=0;
    Uint32 mctl_regdata=0;
    Uint32 regbase;
    int i,j;

    //λ
    if(CanbRegs.CAN_ES.bit.EWarn)
    {
        CanbRegs.CAN_CTL.bit.Init = 1;
        CanbRegs.CAN_CTL.bit.SWR  = 1;
        CanbRegs.CAN_CTL.bit.DAR  = 1;
        CanbRegs.CAN_CTL.bit.ABO  = 1;
        CanbRegs.CAN_CTL.bit.Init = 0;
        return(0);
    }

    //
    while(CanbRegs.CAN_IF2CMD.bit.Busy)
    {
        ;
    }
    CanbRegs.CAN_IF2CMD.bit.Arb     = 1;
    CanbRegs.CAN_IF2CMD.bit.Control = 1;
    CanbRegs.CAN_IF2CMD.bit.DATA_A  = 1;
    CanbRegs.CAN_IF2CMD.bit.DATA_B  = 1;
    //

    for(i=1;i<=32;i++)
    {
        CanbRegs.CAN_IF2CMD.bit.MSG_NUM = i;
        while(CanbRegs.CAN_IF2CMD.bit.Busy)
        {
            ;
        }
        if(CanbRegs.CAN_IF2MCTL.bit.NewDat !=0)
        {
            break;
        }
    }

    //
    if(i>=17)
    {
        return(0);
    }

    if(CanbRegs.CAN_IF2MCTL.bit.MsgLst!=0)
    {
        return(-1);
    }

    //

    CanbRegs.CAN_IF2CMD.bit.Arb     = 1;
    CanbRegs.CAN_IF2CMD.bit.Mask    = 1;
    CanbRegs.CAN_IF2CMD.bit.Control = 1;
    CanbRegs.CAN_IF2CMD.bit.DATA_A  = 1;
    CanbRegs.CAN_IF2CMD.bit.DATA_B  = 1;

    CanbRegs.CAN_IF2CMD.bit.MSG_NUM = i;
    while(CanbRegs.CAN_IF2CMD.bit.Busy)
    {
        ;
    }

    //
    rx_frame->id.frame_id = 0;
    if(((CanbRegs.CAN_IF2ARB.bit.Dir)&&(!(CanbRegs.CAN_IF2MCTL.bit.TxRqst)))||
      ((!(CanbRegs.CAN_IF2ARB.bit.Dir))&&(CanbRegs.CAN_IF2MCTL.bit.TxRqst)))
    {
        rx_frame->id.strct.rtr = 1;
    }

    //
    rx_frame->id.frame_id |= CanbRegs.CAN_IF2ARB.bit.ID;  //ȡID
    rx_frame->len          = CanbRegs.CAN_IF2MCTL.bit.DLC; //ȡĳ
    //ȡ
    if(rx_frame->id.strct.rtr==0)
    {
        for(j=0;j<4;j++)
        {
            rx_frame->hdata  = CanbRegs.CAN_IF2DATB.all;
        }

        for(j=0;j<4;j++)
        {
            rx_frame->ldata = CanbRegs.CAN_IF2DATA.all;;
        }
    }
    else
    {
        rx_frame->hdata = 0;
        rx_frame->ldata = 0;
    }

    //
    CanbRegs.CAN_IF2CMD.bit.TxRqst = 1;
    CanbRegs.CAN_IF2CMD.bit.MSG_NUM = i;
    while(CanbRegs.CAN_IF2CMD.bit.Busy)
    {
        ;
    }

    return(1);

}























