/*
 * ACAC_Define.h
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#ifndef SOURCE_INCLUDE_ACAC_DEFINE_H_
#define SOURCE_INCLUDE_ACAC_DEFINE_H_

// ñ
#define PI 3.14159265358979323846f

// ϵͳʱ
#define SYSTEM_CLK 200000000L    // 200MHzϵͳʱ
#define LSPCLK 100000000L        // 100MHzʱ
#define HSPCLK 100000000L        // 100MHzʱ

// ʱ
#define AC_FRE      50              // Ƶ50Hz
#define FSW (50000/5)*5             // (ز)Ƶ50kHz
#define CONTROL_FSW FSW             // Ƶ50kHz
#define SAMPLE_FSW 250000           // Ƶ250KHz
#define Ts_adc  (1.0f/SAMPLE_FSW)   // ADC
#define SAMPLES_PER_CYCLE (SAMPLE_FSW / AC_FRE)  // ÿڲ(250kHz/50Hz=5000)

// PWM
#define EPWM1_PERIOD  ((SYSTEM_CLK/2) / (2 * FSW))         // 50kHz PWM PRD =1000
#define EPWM2_PERIOD  ((SYSTEM_CLK/2) / (2 * SAMPLE_FSW))  // 250kHz PWM PRD =200

// AC-AC ѹ
#define VIN_COM        14.14         // ѹֵ30V242.426V
#define VOUT_MIN       3.0f          // ѹСֵ1V(ֵ)
#define VOUT_MAX       15.0f        // ѹ250V(ֵ)
#define I_MAX          20.0f        // 20A

// AC-AC 
#define VIN_AC_OVP          15          // 뽻ѹ50Vֵ
#define VIN_AC_UVP          5           // 뽻Ƿѹ5Vֵ
#define IIN_AC_OCP          20          // 뽻20Aֵ
#define IOUT_AC_OCP         20          // 20Aֵ
#define IL_AC_OCP           15          // е15Aֵ

// AC-AC ָ
#define VIN_AC_OVP_RE       11       // 뽻ѹ30Vֵ
#define VIN_AC_UVP_RE       9       // 뽻Ƿѹ10Vֵ
#define IIN_AC_OCP_RE       20       // 뽻20Aֵ
#define IOUT_AC_OCP_RE      20       // 20Aֵ
#define IL_AC_OCP_RE        15       // е20Aֵ

// ϱֵ
#define IL_OVER_CURRENT_1   15.0    // ֵ1: 15A
#define IL_OVER_CURRENT_2   18.0    // ֵ2: 18A
#define IL_OVER_CURRENT_3   20.0    // ֵ3: 20A

//Ӧʹ
#define VIN_SENSOR_ENABLED   1           // ѹʹܱ־
#define VOUT_SENSOR_ENABLED  1           // ѹʹܱ־
#define IIN_SENSOR_ENABLED   0           // ʹܱ־
#define IOUT_SENSOR_ENABLED  0           // ʹܱ־
#define IL_SENSOR_ENABLED    1           // еʹܱ־
#define TEMP_SENSOR_ENABLED  0           // ϵͳ¶ȴʹܱ־

// AC-AC ѹ״̬
#define AC_STATE_POSITIVE   1.0     // 
#define AC_STATE_NEGATIVE  -1.0     // 
#define AC_STATE_ZERO       0.0     // 

// е״̬
#define  IL_STATE_POSITIVE  1.0     // еΪ
#define  IL_STATE_NEGATIVE -1.0     // еΪ
#define  IL_STATE_ZERO      0.0     // 

// ADC
#define ADC_SIGNAL_RANGE 3.0f     // ̣3.0V
#define ADC_SUIT_RANGE 2.5f       // ԣ̣2.5V
#define ADC_RESOLUTION 4096f      // 12-bit ADC

// ADC (0~3.3V)
#define GADC1 (3.3f / 4096.0f)                // 12bit,3.3/4096

// ˫ADC (1.5V)
#define ADC_BIPOLAR_RANGE 1.5f    // ADCģ뷶Χ 1.5V
#define GADC2 ((2.0 * ADC_BIPOLAR_RANGE)/ADC_RESOLUTION ) // ADC: (0~4095) Ӧ (-1.5V~+1.5V)3/4096

// ƫADC(+1.65V)
#define GADC3 (3.0f / 4096.0f)                // 12bit,3.0/4096

//  (  ѹ)
#define VIN_SENSOR_GAIN    (75.0f / 1275.0f)     // 30*1.414V  0~2.4956V
#define VOUT_SENSOR_GAIN   (20.0f / 1220.0f)     // 100*1.414V  0~2.3184V
#define IL_SENSOR_GAIN     (2.64f / 40.0f)       // 20A  0.33~2.97V

// 
#define VIN_SENSOR_GAIN_REV    (1.0f / VIN_SENSOR_GAIN)
#define VOUT_SENSOR_GAIN_REV   (1.0f / VOUT_SENSOR_GAIN)
#define IL_SENSOR_GAIN_REV     (1.0f / IL_SENSOR_GAIN)

// Ȩϵ
#define FILTER_NEW_WEIGHT     0.25f    // ²Ȩ
#define FILTER_OLD_WEIGHT     0.75f    // ˲Ȩ

#endif /* SOURCE_INCLUDE_ACAC_DEFINE_H_ */
