/*
 * GlobalVariables.h
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#ifndef SOURCE_INCLUDE_GLOBALVARIABLES_H_
#define SOURCE_INCLUDE_GLOBALVARIABLES_H_

#include "ACAC_Define.h"

#include <stdint.h>
#include <string.h>
#include <math.h>

#ifdef CLA_C

// CLAԹ
extern volatile float cla_theta;
extern volatile float cla_sin_theta;
extern volatile float cla_cos_theta;

#endif

// ϵͳ״̬
extern unsigned char Sys_Run_State;
extern unsigned char Pre_Bias_Initialized;
extern unsigned char Short_Circuit_Flag;
extern unsigned int  Recover_INT_Counter;
extern unsigned int  common_index;

extern int Duty_Cycle;

// ϵͳ״̬ö
enum Sys_State
{
    STATE_INIT,
    STATE_RUN,
    STATE_FAULT,
    STATE_STOP
};

// ϱ־λ
struct Fault
{
    unsigned char Vin_Under_Voltage_Fault  : 1;    // Ƿѹ
    unsigned char Vin_Over_Voltage_Fault   : 1;    // ѹ
    unsigned char Vout_Over_Voltage_Fault  : 1;    // ѹ
    unsigned char Iin_Over_Current_Fault   : 1;    // 
    unsigned char Iout_Over_Current_Fault  : 1;    // 
    unsigned char Iout_Short_Current_Fault : 1;    // ·
    unsigned char IL_Over_Current_Fault    : 1;    // й
    unsigned char Sys_Over_Temp_Fault      : 1;    // ϵͳ¹
    uint16_t reserved                      : 8;
};

union Sys
{
    unsigned char all;
    struct Fault bit;
};

// ṹ
typedef struct
{
    float vout_offset;
    float vin_offset;
    float il_offset;
} ADC_Data_Offset_t;

// ԭʼṹ
typedef struct
{
    float vout_pos_voltage;
    float vout_neg_voltage;
    float vout_ac_voltage;
    float vin_pos_voltage;
    float vin_neg_voltage;
    float vin_ac_voltage;
    float biased_voltage;
    float current_voltage;
} ADC_RAW_Data_t;

// ݽṹ
typedef struct
{
    float Vout_AC;           // ѹ˲ʱֵ
    float Vin_AC;            // ѹ˲ʱֵ
    float IL_AC;             // е˲ʱֵ
    float Vout_AC_Filter;    // ˲ѹ
    float Vin_AC_Filter;     // ˲ѹ
    float IL_AC_Filter;      // ˲е
    float Vin_RMS;           // ѹЧֵ
    float Vout_RMS;          // ѹЧֵ
    float IL_RMS;            // еЧֵ
} ADC_Data_t;

//λݽṹ
typedef struct
{
    // ʵʱλϢ
    float Phase_Angle;          // λǶ
    float Phase_Angle_Soft;     // λ
    float AC_State;             // ״̬
    float AC_State_Soft;        // 㽻״̬

    // ƵʺϢ
    float frequency;            // Ƶ
    uint32_t period;            // ڼֵ
    uint32_t half_period;       // ڼֵ

    // ״̬
    float IL_State;             // ״̬
    float Reserved;             // 
} Phase_Data_t;

// PIṹ嶨
typedef struct
{
    float kp;
    float ki;
    float error;
    float pre_error;
    float proportional;
    float integral;
    float integral_max;
    float integral_min;
    float output;
    float max_output;
    float min_output;
} PI_Controller_t;

//˫οṹ
typedef struct
{
    float Vout_Ref_AC;        // ѹο(˲ʱֵ)
    float Vout_Ref_RMS;       // ѹЧֵοֵ(ǰֵ)
    float Vout_Ref_RMS_Temp;  // ʱοֵ
    float Vout_Ref_RMS_Target;// ĿЧֵ(1-100Vɵ)
    float I_ref;              // ⻷ĵֵο
    float I_ref_instant;      // ˲ʱοֵ
} PI_Controller_Ref_t;

// λṹ
typedef struct
{
   // ԭʼʱ
   uint32_t cap1_time;         // CAP1ʱ
   uint32_t cap2_time;         // CAP2ʱܿȣ
   uint32_t cap3_time;         // CAP3ʱڣ
   uint32_t cap4_time;         // CAP4ʱܿȣ

   // ͳ
   uint32_t last_rise_time;
   uint32_t last_fall_time;

   // ״̬־
   uint16_t is_phase_valid;    // λǷЧ (0=Ч, 1=Ч)
} Phase_Detector_t;

extern enum Sys_State STATE;
extern union Sys Sys_Run_Flag;
extern ADC_Data_Offset_t ADC_Data_Offset;
extern ADC_RAW_Data_t ADC_RAW_Data;
extern ADC_Data_t ADC_Data;
extern Phase_Data_t Phase_Data;
extern PI_Controller_t Voltage_PI;
extern PI_Controller_t Current_PI;
extern PI_Controller_Ref_t Ref;
extern Phase_Detector_t Phase_Detector;

void ADC_Data_Offset_Init(void);
void ADC_RAW_Data_Init(void);
void ADC_Data_Init(void);
void Phase_Data_Init(void);
void PI_Controllers_Init(void);
void PI_Controller_Ref_Init(void);
void Phase_Detector_Init(void);
void System_GlobalVariables_Reset(void);

#endif /* SOURCE_INCLUDE_GLOBALVARIABLES_H_ */
