/*
 * ACAC_PI_Control.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include <ACAC_PI_Control.h>

/*
: ѹ⻷PI
˵: ѹЧֵеֵο
*/
void Voltage_Outer_Loop(void)
{
    Voltage_PI.error = Ref.Vout_Ref_RMS - ADC_Data.Vout_RMS;

    Voltage_PI.proportional = Voltage_PI.error * Voltage_PI.kp;
    Voltage_PI.integral += Voltage_PI.error * (Voltage_PI.ki*Ts_adc);
    Voltage_PI.output = Voltage_PI.proportional + Voltage_PI.integral;

#ifdef ENABLE_IREF_LIMIT
    if (Voltage_PI.output > Voltage_PI.max_output)
    {
        Voltage_PI.output = Voltage_PI.max_output;
    }
    else if (Voltage_PI.output < Voltage_PI.min_output)
    {
        Voltage_PI.output = Voltage_PI.min_output;
    }
#endif
    Ref.I_ref = Voltage_PI.output;
}

/*
: ڻPI
˵: ݵ˲ʱοֵʵʵеռձ
*/
void Current_Inner_Loop(void)
{
    static float current_integral_Flag = 0.0;

    // ѹеԽзŴ
    if (ADC_Data.IL_AC_Filter > 0)//||ADC_Data.Vin_AC_Filter>0  Phase_Data.AC_State>0||
    {
        current_integral_Flag = 1;
    }
    else if(ADC_Data.IL_AC_Filter < 0)//||ADC_Data.Vin_AC_Filter<0 Phase_Data.AC_State<0||
    {
        current_integral_Flag = -1;
    }

    // ˲ʱοֵ
    Ref.I_ref_instant = Ref.I_ref * sin(Phase_Data.Phase_Angle * PI / 180.0);
    //Ref.I_ref_instant = Ref.I_ref * sin(Phase_Data.Phase_Angle_Soft * PI / 180.0);

    Current_PI.error = current_integral_Flag * (Ref.I_ref_instant - ADC_Data.IL_AC_Filter);

    Current_PI.proportional = Current_PI.error * Current_PI.kp;
    Current_PI.integral += Current_PI.error * (Current_PI.ki*Ts_adc);
    Current_PI.output = Current_PI.proportional + Current_PI.integral;

#ifdef ENABLE_DUTY_LIMIT
    if (Current_PI.output > Current_PI.max_output)
    {
        Current_PI.output = Current_PI.max_output;
    }
    else if (Current_PI.output < Current_PI.min_output)
    {
        Current_PI.output = Current_PI.min_output;
    }
#endif
    Duty_Cycle = (uint16_t)(Current_PI.output * (float)EPWM1_PERIOD);
}

/*
: AC-AC˫
˵: ѹЧֵ⻷ + еڻ˫
*/
void ACAC_PI_Controller(void)
{
#if NO_StateMachine
    Ref.Vout_Ref_RMS = Ref.Vout_Ref_RMS_Target;
#endif
    Voltage_Outer_Loop();
    Current_Inner_Loop();
}

/*
: ƿ
˵: Ƶеֵ
*/
void Current_Limiting(void)
{
    if (fabs(ADC_Data.IL_RMS) > IL_AC_OCP)
    {
        Duty_Cycle *= (uint16_t)(1.0 - 0.3);
    }
}
