/*
 * ACAC_StateMachine.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include <ACAC_StateMachine.h>

/*
: AC-ACԤƫ
˵: ʱĵӦź
*/
void ACAC_Pre_Bias_Start(void)
{
    if (Pre_Bias_Initialized == 1)
    {
        return;
    }

    double current_vout = ADC_Data.Vout_AC_Filter;
    double current_vin = ADC_Data.Vin_AC_Filter;
    double vout_abs = fabs(current_vout);
    double vin_abs = fabs(current_vin);
    double estimated_load = 30.0;

    double required_duty;
    double required_i_ref;

    //1ѹعѹ
    if (vout_abs > VOUT_MAX)
    {
        required_duty = 0.1;
        required_i_ref = 0.5;
    }
    //2ѹ̫С
    else if (vin_abs < VIN_AC_UVP)
    {
        required_duty = 0.1;
        required_i_ref = 0.5;
    }
    //3Ԥƫü
    else
    {
        required_duty = vout_abs / (vin_abs + vout_abs);

        if (vout_abs > 1.0)
        {
            required_i_ref = vout_abs / estimated_load;
        }
        else
        {
            required_i_ref = 0.5;
        }
    }

    //ռձȰȫ
    if (required_duty > 0.6)
    {
        required_duty = 0.6;
    }
    if (required_duty < 0.1)
    {
        required_duty = 0.1;
    }

    //οȫ
    if (required_i_ref > 2.0)
    {
        required_i_ref = 2.0;
    }
    if (required_i_ref < -2.0)
    {
        required_i_ref = -2.0;
    }

    //˫Ʊ
    Current_PI.output = required_duty;       // ռձ
    Ref.I_ref         = required_i_ref;      // ѹֵο
    Voltage_PI.output = required_i_ref;      // ʼѹ

    //PWMر
    Duty_Cycle = (uint16_t)(required_duty * (float)EPWM1_PERIOD);
}

/*
: AC
˵: 
*/
void ACAC_Soft_Start(void)
{
    static unsigned int soft_start_counter = 0;

    if (Ref.Vout_Ref_RMS < 3.0)
    {
        Ref.Vout_Ref_RMS = 3.0;
    }
    else if(Ref.Vout_Ref_RMS > 100.0)
    {
        Ref.Vout_Ref_RMS = 3.0;
    }

    // ÿ2500һѹ
    soft_start_counter++;
    if (soft_start_counter >= 2500)
    {
        soft_start_counter = 0;

        if (Ref.Vout_Ref_RMS_Temp < Ref.Vout_Ref_RMS_Target)
        {
            Ref.Vout_Ref_RMS_Temp += 1.0;
            if (Ref.Vout_Ref_RMS_Temp > Ref.Vout_Ref_RMS_Target)
            {
                Ref.Vout_Ref_RMS_Temp = Ref.Vout_Ref_RMS_Target;
            }
        }

        else if (Ref.Vout_Ref_RMS_Temp > Ref.Vout_Ref_RMS_Target)
        {
            Ref.Vout_Ref_RMS_Temp -= 1.0;
            if (Ref.Vout_Ref_RMS_Temp < Ref.Vout_Ref_RMS_Target)
            {
                Ref.Vout_Ref_RMS_Temp = Ref.Vout_Ref_RMS_Target;
            }
        }

        Ref.Vout_Ref_RMS = Ref.Vout_Ref_RMS_Temp;
    }
}

/*
: AC-AC״̬
˵: ϵͳй
*/
void AC_State_Machine(unsigned int *common_index_0)
{
    unsigned int counter = *common_index_0;

    switch (Sys_Run_State)
    {
        case 1: // ״̬1: ʼ״̬
            MY_PWM_Disable();
            if ((Sys_Run_Flag.all & 0xFF) == 0 && Short_Circuit_Flag != 1)
            {
                counter++;
                if (counter >= 2500)
                {
                    counter = 0;
                    Sys_Run_State = 2;
                }
            }
            else
            {
                counter = 0;
                Sys_Run_State = 5;
            }
            break;

        case 2: // ״̬2: ׼״̬
            if (Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
            {
                counter++;
                if (counter >= 2500)
                {
                    counter = 0;
                    ACAC_Pre_Bias_Start();
                    Sys_Run_State = 3;
                    Pre_Bias_Initialized = 1;
                    MY_PWM_Enable();
                }
            }
            else
            {
                counter = 0;
                Sys_Run_State = 5;
                MY_PWM_Disable();
            }
            break;

        case 3: // ״̬3: ״̬
            if (Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
            {
                if (fabs(Ref.Vout_Ref_RMS - Ref.Vout_Ref_RMS_Target) < 50.0 )
                {
                    counter = 0;
                    Sys_Run_State = 4;
                    Ref.Vout_Ref_RMS = Ref.Vout_Ref_RMS_Target;
                }
                else
                {
                    ACAC_Soft_Start();

                }
                ACAC_PI_Controller();
                Current_Limiting();
            }
            else
            {
                counter = 0;
                Sys_Run_State = 5;
                MY_PWM_Disable();
            }
            break;

        case 4: // ״̬4: ȶ״̬
            if (Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
            {
                if (fabs(Ref.Vout_Ref_RMS - Ref.Vout_Ref_RMS_Target) > 50.0)
                {
                    Sys_Run_State = 3;
                }
                ACAC_PI_Controller();
                Current_Limiting();
            }
            else
            {
                counter = 0;
                Sys_Run_State = 5;
                MY_PWM_Disable();
            }
            break;

        case 5: // ״̬5: ȴϻظ״̬
            if (Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
            {
                counter++;
                if(counter >= 10000)
                {
                    counter = 0;
                    Sys_Run_Flag.all = 0;
                    Sys_Run_State = 3;
                }
            }
            else if(Sys_Run_Flag.all != 0 && Short_Circuit_Flag != 1)
            {
                counter = 0;
                Sys_Run_State = 5;
            }
            else
            {
                counter = 0;
                Sys_Run_State = 6;
            }
            break;

        default:
            counter = 0;
            break;
    }
    //ʱֵ»ָָڴ
    *common_index_0 = counter;
}
