/*
 * Fault_Defence.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include <Fault_Defence.h>

/*
: ϼⱣ
˵: ʱж
:
ֵ : 
*/
void AC_Fault_Detection(void)
{
    static unsigned int IL_Over_Current_Index = 0;          // йжϼ
    static unsigned char Vin_Under_Voltage_Index_1 = 0;     // Ƿѹжϼ1
    static unsigned char Vin_Under_Voltage_Index_2 = 0;     // Ƿѹжϼ2
    static unsigned char Vin_Over_Voltage_Index_1 = 0;      // ѹжϼ1
    static unsigned char Vin_Over_Voltage_Index_2 = 0;      // ѹжϼ2
    static unsigned char Vout_Over_Voltage_Index_1 = 0;     // ѹжϼ1
    static unsigned char Vout_Over_Voltage_Index_2 = 0;     // ѹжϼ2
//    static unsigned char Iin_Over_Current_Index_1 = 0;    // жϼ1
//    static unsigned char Iin_Over_Current_Index_2 = 0;    // жϼ2
//    static unsigned char Iout_Over_Current_Index_1 = 0;   // жϼ1
//    static unsigned char Iout_Over_Current_Index_2 = 0;   // жϼ2
    static unsigned char IL_Over_Current_Index_1 = 0;       // йжϼ1
    static unsigned char IL_Over_Current_Index_2 = 0;       // йжϼ2
//    static unsigned char Sys_Over_Temp_Index_1 = 0;       // ϵͳжϼ1
//    static unsigned char Sys_Over_Temp_Index_2 = 0;       // ϵͳжϼ2

    //========================================================================
    //Ƿѹж
#if VIN_SENSOR_ENABLED
    if (Sys_Run_Flag.bit.Vin_Over_Voltage_Fault == 0)//δѹжǷѹ
    {
        if (fabs(ADC_Data.Vin_RMS) <= VIN_AC_UVP)
        {
            Vin_Under_Voltage_Index_1++;
            if (Vin_Under_Voltage_Index_1 >= 250)// ж10ms
            {
                Vin_Under_Voltage_Index_1 = 250;
                Sys_Run_Flag.bit.Vin_Under_Voltage_Fault = 1;
            }
        }
        else
        {
            Vin_Under_Voltage_Index_1 = 0;
        }
        if (fabs(ADC_Data.Vin_RMS) >= VIN_AC_UVP_RE)
        {
            Vin_Under_Voltage_Index_2++;
            if (Vin_Under_Voltage_Index_2 >= 250)
            {
                Vin_Under_Voltage_Index_2 = 250;
                Sys_Run_Flag.bit.Vin_Under_Voltage_Fault = 0;
            }
        }
        else
        {
            Vin_Under_Voltage_Index_2 = 0;
        }
    }
#endif
    //========================================================================
    //ѹж
#if VIN_SENSOR_ENABLED
    if (Sys_Run_Flag.bit.Vin_Under_Voltage_Fault == 0)
    {
        if (fabs(ADC_Data.Vin_RMS) >= VIN_AC_OVP)
        {
            Vin_Over_Voltage_Index_1++;
            if (Vin_Over_Voltage_Index_1 >= 250)
            {
                Vin_Over_Voltage_Index_1 = 250;
                Sys_Run_Flag.bit.Vin_Over_Voltage_Fault = 1;
            }
        }
        else
        {
            Vin_Over_Voltage_Index_1 = 0;
        }
        if (fabs(ADC_Data.Vin_RMS) <= VIN_AC_OVP_RE)
        {
            Vin_Over_Voltage_Index_2++;
            if (Vin_Over_Voltage_Index_2 >= 250)
            {
                Vin_Over_Voltage_Index_2 = 250;
                Sys_Run_Flag.bit.Vin_Over_Voltage_Fault = 0;
            }
        }
        else
        {
            Vin_Over_Voltage_Index_2 = 0;
        }
    }
#endif
    //========================================================================
    //ѹж
#if VOUT_SENSOR_ENABLED
    if (Sys_Run_Flag.bit.Vout_Over_Voltage_Fault == 0)
    {
        if (fabs(ADC_Data.Vout_RMS) >= VOUT_MAX)
        {
            Vout_Over_Voltage_Index_1++;
            if (Vout_Over_Voltage_Index_1 >= 250)
            {
                Vout_Over_Voltage_Index_1 = 250;
                Sys_Run_Flag.bit.Vout_Over_Voltage_Fault = 1;
            }
        }
        else
        {
            Vout_Over_Voltage_Index_1 = 0;
        }
    }
    else
    {
        if (fabs(ADC_Data.Vout_RMS) <= VOUT_MAX)
        {
            Vout_Over_Voltage_Index_2++;
             if (Vout_Over_Voltage_Index_2 >= 250)
             {
                 Vout_Over_Voltage_Index_2 = 250;
                 Sys_Run_Flag.bit.Vout_Over_Voltage_Fault = 0;
             }
        }
        else
        {
            Vout_Over_Voltage_Index_2 = 0;
        }
    }
#endif
    //========================================================================
    //ж
#if IIN_SENSOR_ENABLED
    if (Sys_Run_Flag.bit.Iin_Over_Current_Fault == 0)
    {
        if (fabs(ADC_Data.Iin_AC_Filter) >= IIN_AC_OCP)
        {
            Iin_Over_Current_Index_1++;
            if (Iin_Over_Current_Index_1 >= 250)
            {
                Iin_Over_Current_Index_1 = 250;
                Sys_Run_Flag.bit.Iin_Over_Voltage_Fault = 1;
            }
        }
        else
        {
            Iin_Over_Current_Index_1 = 0;
        }
    }
    else
    {
        if (fabs(ADC_Data.Iin_AC_Filter) <= IIN_AC_OCP_RE)
        {
            Iin_Over_Current_Index_2++;
             if (Iin_Over_Current_Index_2 >= 250)
             {
                 Iin_Over_Current_Index_2 = 250;
                 Sys_Run_Flag.bit.Iin_Over_Voltage_Fault = 0;
             }
        }
        else
        {
            Iin_Over_Current_Index_2 = 0;
        }
    }
#endif
    //=============================================================
    //ж
#if IOUT_SENSOR_ENABLED
    if (fabs(Iout_AC_Filter) >= IOUT_OVER_CURRENT_3)
    {
        Iout_Over_Current_Index = Iout_Over_Current_Index + 25;
    }
    else if (fabs(Iout_AC_Filter) >= IOUT_OVER_CURRENT_2)
    {
        Iout_Over_Current_Index = Iout_Over_Current_Index + 50;
    }
    else if (fabs(Iout_AC_Filter) >= IOUT_OVER_CURRENT_1)
    {
        Iout_Over_Current_Index = Iout_Over_Current_Index + 100;
    }
    else
    {
        Iout_Over_Current_Index = 0;
        Sys_Run_Flag.bit.Iout_Over_Current_Fault = 0;
    }
    if (Iout_Over_Current_Index >= 1000)
    {
        Iout_Over_Current_Index = 1000;
        Sys_Run_Flag.bit.Iout_Over_Current_Fault = 1;
    }
#endif
    //========================================================================
    //йж
#if IL_SENSOR_ENABLED
    if (Sys_Run_Flag.bit.IL_Over_Current_Fault == 0)
    {
        if (fabs(ADC_Data.IL_RMS) >= IL_AC_OCP)
        {
            IL_Over_Current_Index_1++;
            if (IL_Over_Current_Index_1 >= 250)
            {
                IL_Over_Current_Index_1 = 250;
                Sys_Run_Flag.bit.IL_Over_Current_Fault = 1;
            }
        }
        else
        {
            IL_Over_Current_Index_1 = 0;
        }
    }
    else
    {
        if (fabs(ADC_Data.IL_RMS) <= IL_AC_OCP_RE)
        {
            IL_Over_Current_Index_2++;
             if (IL_Over_Current_Index_2 >= 250)
             {
                 IL_Over_Current_Index_2 = 250;
                 Sys_Run_Flag.bit.IL_Over_Current_Fault = 0;
             }
        }
        else
        {
            IL_Over_Current_Index_2 = 0;
        }
    }

    if (fabs(ADC_Data.IL_RMS) >= IL_OVER_CURRENT_3)
       {
        IL_Over_Current_Index = IL_Over_Current_Index + 25; //1ms
       }
       else if (fabs(ADC_Data.IL_RMS) >= IL_OVER_CURRENT_2)
       {
           IL_Over_Current_Index = IL_Over_Current_Index + 50;// 2ma
       }
       else if (fabs(ADC_Data.IL_RMS) >= IL_OVER_CURRENT_1)
       {
           IL_Over_Current_Index = IL_Over_Current_Index + 100;//4ms
       }
       else
       {
           IL_Over_Current_Index = 0;
           Sys_Run_Flag.bit.IL_Over_Current_Fault = 0;
       }
       if (IL_Over_Current_Index >= 1000)
       {
           IL_Over_Current_Index = 1000;
           Sys_Run_Flag.bit.IL_Over_Current_Fault = 1;
       }
#endif
    //========================================================================
    //ϵͳж
#if TEMP_SENSOR_ENABLED
    if (Temp_Sample >= SYS_OVER_TEMP_LATCH)
    {
        Sys_Over_Temp_Index_1++;
        if (Sys_Over_Temp_Index_1 >= 250)
        {
            Sys_Over_Temp_Index_1 = 250;
            Sys_Run_Flag.bit.Sys_Over_Temp_Fault = 1;
        }
    }
    else
    {
        Sys_Over_Temp_Index_1 = 0;
    }

    if (Temp_Sample <= SYS_OVER_TEMP_RECOVERY)
    {
        Sys_Over_Temp_Index_2++;
        if (Sys_Over_Temp_Index_2 >= 250)
        {
            Sys_Over_Temp_Index_2 = 250;
            Sys_Run_Flag.bit.Sys_Over_Temp_Fault = 0;
        }
    }
    else
    {
        Sys_Over_Temp_Index_2 = 0;
    }
#endif

    // κι
    if (Sys_Run_Flag.all != 0)
    {
        MY_PWM_Disable();
    }
}

/*
:·йϵͳ
˵ ·ϻйϵ
:ź
ֵ : 
*/
void Short_Current_Protection(double IL_data_in)
{
    static unsigned int IL_Short_Current_Index = 0;//жϼ

    if ((fabs(IL_data_in) > 15) || Short_Circuit_Flag == 1)
    {
        IL_Short_Current_Index++;
        if(IL_Short_Current_Index>=2500)
        {
            IL_Short_Current_Index =2500;
            STATE = STATE_STOP;
            Short_Circuit_Flag = 1;
            Sys_Run_Flag.bit.IL_Over_Current_Fault = 1;
        }
    }
}

/*
:
˵ ö
:
ֵ : 
*/
void Check_Faults(void)
{
    if (Sys_Run_Flag.all != 0 && Short_Circuit_Flag != 1)
    {
        STATE = STATE_FAULT;
    }
    else if(Short_Circuit_Flag == 1)
    {
        STATE = STATE_STOP;
    }
}
