/*
 * GlobalVariables.c
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#include <GlobalVariables.h>

#ifdef CLA_C

// CLA
#pragma DATA_SECTION(cla_theta, "CpuToCla1MsgRAM")
volatile float cla_theta = 0.0f;

#pragma DATA_SECTION(cla_sin_theta, "Cla1ToCpuMsgRAM")
volatile float cla_sin_theta = 0.0f;

#pragma DATA_SECTION(cla_cos_theta, "Cla1ToCpuMsgRAM")
volatile float cla_cos_theta = 0.0f;

#endif

// ϵͳ״̬
unsigned char Sys_Run_State = 0;          //ϵͳ״̬
unsigned char Pre_Bias_Initialized = 0;   //Ԥƫóʼ־
unsigned char Short_Circuit_Flag = 0;     //·־λ
unsigned int  Recover_INT_Counter = 0;    //ϻظָ
unsigned int  common_index = 0;           //ָͨ

int Duty_Cycle;                 // ռձ

enum Sys_State STATE = STATE_INIT;
union Sys Sys_Run_Flag  = {0};

ADC_Data_Offset_t ADC_Data_Offset = {0, 0 ,0};
ADC_RAW_Data_t ADC_RAW_Data = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
ADC_Data_t ADC_Data = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0.0, 0.0};
Phase_Data_t Phase_Data = {0};
PI_Controller_t Voltage_PI = {0.3, 0.5, 0.0, 0.0, 0.0, 0.0, 20.0, -20.0, 0.0, 60.0, -60.0};
PI_Controller_t Current_PI = {0.5, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9, 0.1};
PI_Controller_Ref_t Ref = {0, 5, 5, 10, 0, 0};
Phase_Detector_t Phase_Detector = {0};

/*
ʼ
˵
*/
void ADC_Data_Offset_Init(void)
{
    ADC_Data_Offset.vin_offset      = 0;
    ADC_Data_Offset.vout_offset     = 0;
    ADC_Data_Offset.il_offset       = 214;
}

/*
ʼ
˵
*/
void ADC_RAW_Data_Init(void)
{
    ADC_RAW_Data.vout_pos_voltage   = 0;
    ADC_RAW_Data.vout_neg_voltage   = 0;
    ADC_RAW_Data.vout_ac_voltage    = 0;
    ADC_RAW_Data.vin_pos_voltage    = 0;
    ADC_RAW_Data.vin_neg_voltage    = 0;
    ADC_RAW_Data.vin_ac_voltage     = 0;
    ADC_RAW_Data.biased_voltage     = 0;
    ADC_RAW_Data.current_voltage    = 0;
}

/*
ʼ
˵
*/
void ADC_Data_Init(void)
{
    ADC_Data.Vout_AC            = 0.0;
    ADC_Data.Vin_AC             = 0.0;
    ADC_Data.IL_AC              = 0.0;
    ADC_Data.Vout_AC_Filter     = 0.0;
    ADC_Data.Vin_AC_Filter      = 0.0;
    ADC_Data.IL_AC_Filter       = 0.0;
    ADC_Data.Vin_RMS            = 0.0;
    ADC_Data.Vout_RMS           = 0.0;
    ADC_Data.IL_RMS             = 0.0;
}

/*
λʼ
˵
*/
void Phase_Data_Init(void)
{
    Phase_Data.Phase_Angle  = 0.0;
    Phase_Data.Phase_Angle_Soft = 0.0;
    Phase_Data.AC_State     = 0.0;
    Phase_Data.AC_State_Soft = 0.0;
    Phase_Data.frequency    = 0.0;
    Phase_Data.period       = 0;
    Phase_Data.half_period  = 0;
    Phase_Data.IL_State     = 0.0;
}

/*
PIʼ
˵
*/
void PI_Controllers_Init(void)
{
    Voltage_PI.kp           = 0.2;
    Voltage_PI.ki           = 0.5;
    Voltage_PI.error        = 0.0;
    Voltage_PI.integral     = 0.0;
    Voltage_PI.integral_max = 20.0;
    Voltage_PI.integral_min = -20.0;
    Voltage_PI.output       = 0.0;
    Voltage_PI.max_output   = 3;
    Voltage_PI.min_output   = -3;

    Current_PI.kp           = 0.5;
    Current_PI.ki           = 2;
    Current_PI.error        = 0.0;
    Current_PI.integral     = 0.0;
    Current_PI.integral_max = 0.0;
    Current_PI.integral_min = 0.0;
    Current_PI.output       = 0.0;
    Current_PI.max_output   = 0.8;
    Current_PI.min_output   = 0.1;
}

/*
οʼ
˵
*/
void PI_Controller_Ref_Init(void)
{
    Ref.Vout_Ref_AC         = 0.0;
    Ref.Vout_Ref_RMS        = 5;
    Ref.Vout_Ref_RMS_Temp   = 5;
    Ref.Vout_Ref_RMS_Target = 5;
    Ref.I_ref               = 0.0;
    Ref.I_ref_instant       = 0.0;
}

/*
: Ӳλʼ
˵: 
*/
void Phase_Detector_Init(void)
{
    Phase_Detector.cap1_time       = 0;
    Phase_Detector.cap2_time       = 0;
    Phase_Detector.cap3_time       = 0;
    Phase_Detector.cap4_time       = 0;

    Phase_Detector.last_rise_time    = 0;
    Phase_Detector.last_fall_time    = 0;

    Phase_Detector.is_phase_valid    = 0;
}

/*
ϵͳ
˵
*/
void System_GlobalVariables_Reset(void)
{
    STATE = STATE_INIT;
    Sys_Run_State = 1;
    Sys_Run_Flag.all = 0;
    Pre_Bias_Initialized = 0;

    ADC_Data_Offset_Init();
    ADC_RAW_Data_Init();
    ADC_Data_Init();
    Phase_Data_Init();
    PI_Controllers_Init();
    PI_Controller_Ref_Init();
    Phase_Detector_Init();

    Duty_Cycle = EPWM1_PERIOD/2;
}
