/*
 * MY_ADC.c
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#include <MY_ADC.h>

/*
: ADC˿
˵: 
*/
static void MY_ADC_GPIO_Config(void)
{
    // === GPIO39-43: ADC˿ ===
    GPIO_setPinConfig(GPIO_39_GPIO39);
    GPIO_setDirectionMode(39, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(39, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(39, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(39, GPIO_CORE_CPU1);

    GPIO_setPinConfig(GPIO_40_GPIO40);
    GPIO_setDirectionMode(40, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(40, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(40, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(40, GPIO_CORE_CPU1);

    GPIO_setPinConfig(GPIO_41_GPIO41);
    GPIO_setDirectionMode(41, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(41, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(41, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(41, GPIO_CORE_CPU1);

    GPIO_setPinConfig(GPIO_42_GPIO42);
    GPIO_setDirectionMode(42, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(42, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(42, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(42, GPIO_CORE_CPU1);

    GPIO_setPinConfig(GPIO_43_GPIO43);
    GPIO_setDirectionMode(43, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(43, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(43, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(43, GPIO_CORE_CPU1);
}

/*
: ADC
˵: 
*/
static void MY_ADC_Mode_Config(void)
{
    // === ADC ===
    ADC_setPrescaler(ADCA_BASE, ADC_CLK_DIV_4_0);
    ADC_setInterruptPulseMode(ADCA_BASE, ADC_PULSE_END_OF_CONV);
    ADC_setMode(ADCA_BASE, ADC_RESOLUTION_12BIT, ADC_MODE_SINGLE_ENDED);
    ADC_enableConverter(ADCA_BASE);

    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN0, 20);
    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN1, 20);
    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER2, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN2, 20);
    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER3, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN3, 20);
    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER4, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN4, 20);

    //ADC_setBurstModeConfig(ADCA_BASE, ADC_TRIGGER_EPWM2_SOCA, 5);  // ͻ5SOC
    //ADC_enableBurstMode(ADCA_BASE);                                // ʹͻģʽ

    ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER4); // INT1SOC4ɺ󴥷
    ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);                     // ʹINT1
    ADC_disableContinuousMode(ADCA_BASE, ADC_INT_NUMBER1);               // ģʽ
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);                // INT1־λ

    DELAY_US(1000);

//    EALLOW;
//
//    //ADC
//    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
//    AdcSetMode(ADC_ADCA ,ADC_RESOLUTION_12BIT,ADC_SIGNALMODE_SINGLE);
//    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;    // жڱֽ
//    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;       // ADCϵ
//
//    // SOC0: ѹ+ (ADCINA0)
//    AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;       // ͨ0
//    AdcaRegs.ADCSOC0CTL.bit.ACQPS = 19;      // 20ADCʱ(ɿĵʽã빦ʵ·й)
//    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 7;     // Դ: ePWM2 SOCA
//
//    // SOC1: ѹ- (ADCINA1)
//    AdcaRegs.ADCSOC1CTL.bit.CHSEL = 1;       // ͨ1
//    AdcaRegs.ADCSOC1CTL.bit.ACQPS = 19;
//    AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 7;
//
//    // SOC2: ѹ+ (ADCINA2)
//    AdcaRegs.ADCSOC2CTL.bit.CHSEL = 2;       // ͨ2
//    AdcaRegs.ADCSOC2CTL.bit.ACQPS = 19;
//    AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 7;
//
//    // SOC3: ѹ- (ADCINA3)
//    AdcaRegs.ADCSOC3CTL.bit.CHSEL = 3;       // ͨ3
//    AdcaRegs.ADCSOC3CTL.bit.ACQPS = 19;
//    AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 7;
//
//    // SOC4: е (ADCINA4)
//    AdcaRegs.ADCSOC4CTL.bit.CHSEL = 4;       // ͨ4
//    AdcaRegs.ADCSOC4CTL.bit.ACQPS = 19;      // 
//    AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 7;     // Դ: ePWM2 SOCA
//
//    // === ͻģʽ ===
//    // 5߲ͨЧ
////    AdcaRegs.ADCBURSTCTL.bit.BURSTEN = 1;        // ʹͻģʽ
////    AdcaRegs.ADCBURSTCTL.bit.BURSTSIZE = 4;      // ͻС5SOC (0-5)
////    AdcaRegs.ADCBURSTCTL.bit.BURSTTRIGSEL = 7;   // Դ: ePWM2 SOCA
//
//    // === ж ===
//    // SOC5ɺ󴥷жϣʾ5ͨȫ
//    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 4;       // INT1SOC4ɺ󴥷
//    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;         // ʹINT1
//    AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;      //ģʽ
//    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;       // INT1־λ
//
//    EDIS;
//
//    DELAY_US(1000);
}

/*
: ADC
˵: 
*/
void MY_ADC_Init(void)
{
    MY_ADC_GPIO_Config();
    MY_ADC_Mode_Config();
}

/*
: ϳɽź
ڲ: pos_adc-ADCֵ, neg_adc-ADCֵ
ֵ: ѹ
˵: 
*/
float Synthesize_AC_Signal(uint16_t pos_adc, uint16_t neg_adc, float sensor_gain_rev, Offset_Sel_t offset_sel)
{
    float ac_voltage;
    switch(offset_sel)
    {
        case Vin_Offset:
            ac_voltage = ((float)pos_adc - (float)neg_adc - ADC_Data_Offset.vin_offset)*GADC1*sensor_gain_rev;
            break;
        case Vo_Offset:
            ac_voltage = ((float)pos_adc - (float)neg_adc - ADC_Data_Offset.vout_offset)*GADC1*sensor_gain_rev;
            break;
        default:
            ac_voltage = ((float)pos_adc - (float)neg_adc)*GADC1*sensor_gain_rev;
            break;
    }
    return ac_voltage;
}

/*
: ƫõź
ڲ: adc_value - ADC(0-4095)
ֵ: (A)
˵: 
*/
float Process_Biased_Current(uint16_t adc_value, float sensor_gain_rev)
{
    float current_voltage = ((float)adc_value - 2048.0 - ADC_Data_Offset.il_offset)*GADC1*sensor_gain_rev;
    return current_voltage;
}

/*
: ADCת˲
˵: 
*/
void GetADCValue(void)
{
    uint16_t vout_pos_adc = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
    uint16_t vout_neg_adc = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER1);
    uint16_t vin_pos_adc  = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER2);
    uint16_t vin_neg_adc  = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER3);
    uint16_t il_adc       = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER4);

    ADC_Data.Vout_AC = Synthesize_AC_Signal(vout_pos_adc, vout_neg_adc, VOUT_SENSOR_GAIN_REV, Vo_Offset);
    ADC_Data.Vin_AC  = Synthesize_AC_Signal(vin_pos_adc, vin_neg_adc, VIN_SENSOR_GAIN_REV, Vin_Offset);
    ADC_Data.IL_AC = Process_Biased_Current(il_adc, IL_SENSOR_GAIN_REV);

    ADC_Data.Vin_AC_Filter = FILTER_NEW_WEIGHT * (ADC_Data.Vin_AC) + FILTER_OLD_WEIGHT * (ADC_Data.Vin_AC_Filter);
    ADC_Data.Vout_AC_Filter = FILTER_NEW_WEIGHT * (ADC_Data.Vout_AC) + FILTER_OLD_WEIGHT * (ADC_Data.Vout_AC_Filter);
    ADC_Data.IL_AC_Filter = FILTER_NEW_WEIGHT * (ADC_Data.IL_AC) + FILTER_OLD_WEIGHT * (ADC_Data.IL_AC_Filter);
}

/*
: ACЧֵ
˵
*/
void Calculate_RMS_Values(void)
{
    static double vin_square_sum = 0.0;
    static double vout_square_sum = 0.0;
    static double il_square_sum = 0.0;
    static int rms_sample_count = 0;

    // ۼƽֵ
    vin_square_sum += (ADC_Data.Vin_AC_Filter) * (ADC_Data.Vin_AC_Filter);
    vout_square_sum += (ADC_Data.Vout_AC_Filter) * (ADC_Data.Vout_AC_Filter);
    il_square_sum += (ADC_Data.IL_AC_Filter) * (ADC_Data.IL_AC_Filter);

    rms_sample_count++;
    // ÿڼһЧֵ
    if (rms_sample_count >= SAMPLES_PER_CYCLE)
    {
        ADC_Data.Vin_RMS = sqrt(vin_square_sum / rms_sample_count);
        ADC_Data.Vout_RMS = sqrt(vout_square_sum / rms_sample_count);
        ADC_Data.IL_RMS = sqrt(il_square_sum / rms_sample_count);

        vin_square_sum = 0.0;
        vout_square_sum = 0.0;
        il_square_sum = 0.0;

        rms_sample_count = 0;
    }
}

/*
: ʽλ͹
ڲ: ѹ˲ֵ
ֵ: ѹλ
˵: 
*/
void AC_Phase_Detection(double vin_ac)
{
    static float prev_vin = 0.0;
    static uint32_t sample_count = 0;

    // 
    const double PHASE_INCREMENT = 360.0 / (SAMPLE_FSW / AC_FRE);

    // 
    if (prev_vin <= 0.0 && vin_ac > 0.0)
    {
        Phase_Data.Phase_Angle_Soft = 0.0;
        Phase_Data.AC_State_Soft = AC_STATE_POSITIVE;
        sample_count = 0;
    }
    // 
    else if (prev_vin >= 0.0 && vin_ac < 0.0)
    {
        Phase_Data.Phase_Angle_Soft = 180.0;
        Phase_Data.AC_State_Soft = AC_STATE_NEGATIVE;
        sample_count = (uint32_t)(SAMPLES_PER_CYCLE / 2);
    }
    //λۻ
    else
    {
        Phase_Data.Phase_Angle_Soft += PHASE_INCREMENT;
        sample_count++;
        if (Phase_Data.Phase_Angle_Soft >= 360.0)
        {
            Phase_Data.Phase_Angle_Soft -= 360.0;
        }

        // ֹʱδ⵽ʱۻ
        if (sample_count > SAMPLES_PER_CYCLE)
        {
            // ǿλͬ
            if (vin_ac > 0)
            {
                Phase_Data.Phase_Angle_Soft = asin(vin_ac / (ADC_Data.Vin_RMS * sqrt(2))) * 180.0 / PI;
                if (Phase_Data.Phase_Angle_Soft < 0)
                {
                    Phase_Data.Phase_Angle_Soft += 360.0;
                }
            }
            else
            {
                Phase_Data.Phase_Angle_Soft = 180.0 - asin(fabs(vin_ac) / (ADC_Data.Vin_RMS * sqrt(2))) * 180.0 / PI;
            }
            sample_count = 0;
        }
    }
    // ǰһֵ
    prev_vin = vin_ac;
}
