/*
 * MY_CLA.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include "MY_CLA.h"

void MY_CLA_Init(void)
{
    extern uint32_t Cla1funcsRunStart,Cla1funcsLoadStart,Cla1funcsLoadSize;

    EALLOW;

#ifdef _FLASH
//
// Copy over code from FLASH to RAM//
    memcpy((uint32_t *)&Cla1funcsRunStart, (uint32_t *)&Cla1funcsLoadStart,(uint32_t)&Cla1funcsLoadSize);
#endif

    //Initialize and wait for CLA1ToCPUMsgRAM
    MemCfgRegs.MSGxINIT.bit.INIT_CLA1TOCPU = 1;
    while(MemCfgRegs.MSGxINITDONE.bit.INITDONE_CLA1TOCPU != 1){};

    //Initialize and wait for CPUToCLA1MsgRAM/ /
    MemCfgRegs.MSGxINIT.bit.INIT_CPUTOCLA1 = 1;
    while(MemCfgRegs.MSGxINITDONE.bit.INITDONE_CPUTOCLA1 != 1){};

    MemCfgRegs.LSxMSEL.bit.MSEL_LS4 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS4 = 1;
    MemCfgRegs.LSxMSEL.bit.MSEL_LS5= 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS5 = 1;

    MemCfgRegs.LSxMSEL.bit.MSEL_LS0 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS0 = 0; //0: CLA Data memory 1: CLA Program memory ,
    MemCfgRegs.LSxMSEL.bit.MSEL_LS1 = 1;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS1 = 0;
    MemCfgRegs.LSxMSEL.bit.MSEL_LS2 = 0;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS2 = 0; //0:CLA Data memory 1: CLA Program memory .
    MemCfgRegs.LSxMSEL.bit.MSEL_LS3 = 0;
    MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS3 = 0;

    Cla1Regs.MVECT1 = (uint16_t)(&Cla1Task1);
    Cla1Regs.MVECT2 = (uint16_t)(&Cla1Task2);

    Cla1Regs.MCTL.bit.IACKE = CLA_IACK_ENABLE;//use interrupt trigger and soft trigger

    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK1 = CLA_TRIG_ADCAINT1;
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK2 = CLA_TRIG_ADCAINT1;

    DmaClaSrcSelRegs.CLA1TASKSRCSELLOCK.bit.CLA1TASKSRCSEL1 = 0;     // Write a 1 to lock (cannot be cleared once set)
    DmaClaSrcSelRegs.CLA1TASKSRCSELLOCK.bit.CLA1TASKSRCSEL2 = 0;     // Write a 1 to lock (cannot be cleared once set)

    Cla1Regs.MIER.all = 0x00FF; // enable cla task can be trigger

    EDIS;
}
