/*
 * MY_GPIO.c
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#include "MY_GPIO.h"

/*
:LED GPIOʼ
˵: 
*/
void MY_GPIO_Init(void)
{
    // === GPIO:   ===
    GPIO_setPinConfig(GPIO_27_GPIO27);
    GPIO_setDirectionMode(27, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(27, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(27, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(27, GPIO_CORE_CPU1);
    GPIO_writePin(27, 1);

    GPIO_setPinConfig(GPIO_25_GPIO25);
    GPIO_setDirectionMode(25, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(25, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(25, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(25, GPIO_CORE_CPU1);
    GPIO_writePin(25, 1);

    GPIO_setPinConfig(GPIO_14_GPIO14);
    GPIO_setDirectionMode(14, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(14, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(14, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(14, GPIO_CORE_CPU1);
    GPIO_writePin(14, 1);

    GPIO_setPinConfig(GPIO_15_GPIO15);
    GPIO_setDirectionMode(15, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(15, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(15, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(15, GPIO_CORE_CPU1);
    GPIO_writePin(15, 1);
}

/*
: LED״̬
˵: 
*/
void LED_Set_State(uint16_t led_gpio, LED_State_t state)
{
    switch(state)
    {
        case LED_OFF:
            GPIO_writePin(led_gpio, 1);
            break;
        case LED_ON:
            GPIO_writePin(led_gpio, 0);
            break;
        case LED_TOGGLE:
            GPIO_togglePin(led_gpio);
            break;
    }
}

/*
: LEDʾ
˵: ϵͳ״̬
*/
void LED_Update_System_Status(void)
{
    switch(STATE)
    {
        case STATE_INIT:
            LED_Set_State(LED_BLUE_GPIO, LED_ON);
            LED_Set_State(LED_GREEN_GPIO, LED_OFF);
            LED_Set_State(LED_YELLOW_GPIO, LED_OFF);
            LED_Set_State(LED_RED_GPIO, LED_OFF);
            break;

        case STATE_RUN:
            LED_Set_State(LED_BLUE_GPIO, LED_OFF);
            LED_Set_State(LED_GREEN_GPIO, LED_ON);
            LED_Set_State(LED_YELLOW_GPIO, LED_OFF);
            LED_Set_State(LED_RED_GPIO, LED_OFF);
            break;

        case STATE_FAULT:
            LED_Set_State(LED_BLUE_GPIO, LED_OFF);
            LED_Set_State(LED_GREEN_GPIO, LED_OFF);
            LED_Set_State(LED_YELLOW_GPIO, LED_ON);
            LED_Set_State(LED_RED_GPIO, LED_OFF);
            break;

        case STATE_STOP:
            LED_Set_State(LED_BLUE_GPIO, LED_OFF);
            LED_Set_State(LED_GREEN_GPIO, LED_OFF);
            LED_Set_State(LED_YELLOW_GPIO, LED_OFF);
            LED_Set_State(LED_RED_GPIO, LED_OFF);
            break;
    }

    if (Sys_Run_Flag.bit.IL_Over_Current_Fault)
    {
        LED_Set_State(LED_RED_GPIO, LED_ON);
    }
}
