/*
 * MY_eCAP.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include "MY_eCAP.h"

/*
: ECAP˿
˵: 
*/
static void MY_eCAP_GPIO_Config(void)
{
    // === GPIO24:Ƚ ===
    // GPIO24: eCAP1
    GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
    GPIO_setPadConfig(24, GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(24, GPIO_QUAL_SYNC);
    GPIO_setControllerCore(24, GPIO_CORE_CPU1);
}

/*
: ECAP
˵: 
*/
static void MY_eCAP_Mode_Config(void)
{
//    // === eCAP1  ===
//    ECAP_disableInterrupt(ECAP1_BASE, ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |ECAP_ISR_SOURCE_COUNTER_OVERFLOW);
//    ECAP_clearInterrupt(ECAP1_BASE, ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |ECAP_ISR_SOURCE_COUNTER_OVERFLOW);
//
//    ECAP_stopCounter(ECAP1_BASE);
//    ECAP_disableTimeStampCapture(ECAP1_BASE);
//    ECAP_setPhaseShiftCount(ECAP1_BASE, 0);
//
//    ECAP_setCaptureMode(ECAP1_BASE, ECAP_CONTINUOUS_CAPTURE_MODE, ECAP_EVENT_4);
//
//    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_1, ECAP_EVNT_RISING_EDGE);
//    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_2, ECAP_EVNT_FALLING_EDGE);
//    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_3, ECAP_EVNT_RISING_EDGE);
//    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_4, ECAP_EVNT_FALLING_EDGE);
//
//    // λ
//    ECAP_disableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_1);
//    ECAP_disableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_2);
//    ECAP_disableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_3);
//    ECAP_enableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_4);
//
//    // ģʽ
//    ECAP_enableCaptureMode(ECAP1_BASE);              // ģʽ (PWM)
//    ECAP_disableLoadCounter(ECAP1_BASE);             // ͬ
//    ECAP_setSyncOutMode(ECAP1_BASE, ECAP_SYNC_OUT_DISABLED); // ͬ
//    // 
//    ECAP_setEventPrescaler(ECAP1_BASE, 0);           // ԤƵ: Ƶ
//    ECAP_setEmulationMode(ECAP1_BASE, ECAP_EMULATION_FREE_RUN); // ʱ
//    ECAP_enableTimeStampCapture(ECAP1_BASE);         // ʹʱ
//
//    ECAP_startCounter(ECAP1_BASE);
//    ECAP_reArm(ECAP1_BASE);                          // װeCAP
//
//    ECAP_enableInterrupt(ECAP1_BASE, ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |ECAP_ISR_SOURCE_COUNTER_OVERFLOW);

    EALLOW;

    //úж
    ECap1Regs.ECEINT.all = 0x0000;           // ж
    ECap1Regs.ECCLR.all = 0xFFFF;            // жϱ־

    //ʱ
    ECap1Regs.ECCTL1.bit.CAPLDEN = 0;        // ò
    //ҪĴ
    ECap1Regs.TSCTR = 0;                     // ʱ
    ECap1Regs.CTRPHS = 0;                    // λĴ
    ECap1Regs.ECCTL2.bit.TSCTRSTOP = 0;      // رʱ

    //1
    ECap1Regs.ECCTL1.bit.CAP1POL = 0;        // CAP1:ز
    ECap1Regs.ECCTL1.bit.CAP2POL = 1;        // CAP2:½ز
    ECap1Regs.ECCTL1.bit.CAP3POL = 0;        // CAP3:ز
    ECap1Regs.ECCTL1.bit.CAP4POL = 1;        // CAP4:½ز

    ECap1Regs.ECCTL1.bit.CTRRST1 = 1;        // CAP1λ
    ECap1Regs.ECCTL1.bit.CTRRST2 = 0;        // CAP2󲻸λ
    ECap1Regs.ECCTL1.bit.CTRRST3 = 1;        // CAP3λ
    ECap1Regs.ECCTL1.bit.CTRRST4 = 0;        // CAP4󲻸λ

    ECap1Regs.ECCTL1.bit.PRESCALE = 0;       // ԤƵ: Ƶ
    ECap1Regs.ECCTL1.bit.FREE_SOFT = 2;      // ʱ

    //2
    ECap1Regs.ECCTL2.bit.CAP_APWM    = 0;    // ģʽ (PWM)
    ECap1Regs.ECCTL2.bit.CONT_ONESHT = 0;    // ģʽ
    ECap1Regs.ECCTL2.bit.STOP_WRAP   = 3;    // 4¼ֹͣ/װ(ģʽЧ)
    ECap1Regs.ECCTL2.bit.SYNCI_EN    = 0;    // ͬ(eCAPʱΪ1)
    ECap1Regs.ECCTL2.bit.SYNCO_SEL   = 0;    // ͬѡ

    //ж
    ECap1Regs.ECEINT.bit.CEVT1  = 1;         // ʹCAP1ж
    ECap1Regs.ECEINT.bit.CEVT2  = 1;         // ʹCAP2ж
    ECap1Regs.ECEINT.bit.CEVT3  = 1;         // ʹCAP3ж
    ECap1Regs.ECEINT.bit.CEVT4  = 1;         // ʹCAP4ж
    ECap1Regs.ECEINT.bit.CTROVF = 1;         // ʹܼж

    //ʹʱ
    ECap1Regs.ECCTL1.bit.CAPLDEN   = 1;      // ʹܲ
    ECap1Regs.ECCTL2.bit.TSCTRSTOP = 1;      // ʱ

    //װ
    ECap1Regs.ECCTL2.bit.REARM = 1;          // װeCAP

    //жϱ־
    ECap1Regs.ECCLR.all = 0xFFFF;

    EDIS;
}

/*
: eCAPʼ
˵: 
*/
void MY_eCAP_Init(void)
{
    MY_eCAP_GPIO_Config();
    MY_eCAP_Mode_Config();
}

/*
: ȫڣ
˵: 
*/
uint32_t Safe_Period_Calculate(uint32_t current, uint32_t previous)
{
    if (current >= previous)
    {
        return current - previous;
    }
    else
    {
        // 
        return (0xFFFFFFFF - previous) + current + 1;
    }
}

/*
: ֤ڷΧ40-60Hz
˵: 
*/
bool Is_Valid_Period(uint32_t period_ticks)
{
    return (period_ticks > 3333333 && period_ticks < 5000000);
}

/*
: ֤ڷΧ
˵: 
*/
bool Is_Valid_Half_Period(uint32_t half_period_ticks)
{
    return (half_period_ticks > 3333333/2 && half_period_ticks < 5000000/2);
}

/*
:  eCAP1жϷ - 
˵: 
*/
interrupt void eCAP1_ISR(void)
{
    // CAP1
    if (ECap1Regs.ECFLG.bit.CEVT1)
    {
        Phase_Data.AC_State = AC_STATE_POSITIVE;
        Phase_Data.Phase_Angle = 0.0f;

        // ȶ״̬CAP1Ӧֵ
        if (Is_Valid_Period(ECap1Regs.CAP1))
        {
            Phase_Data.period = ECap1Regs.CAP1;
            Phase_Data.half_period = ECap1Regs.CAP1 / 2;
            Phase_Data.frequency = SYSTEM_CLK / (float)ECap1Regs.CAP1;
            Phase_Detector.is_phase_valid = 1;
        }

        ECap1Regs.ECCLR.bit.CEVT1 = 1;
    }

    // CAP2
    if (ECap1Regs.ECFLG.bit.CEVT2)
    {
        Phase_Data.AC_State = AC_STATE_NEGATIVE;
        Phase_Data.Phase_Angle = 180.0f;

        // CAP2ܿȣ֤
        if (Phase_Detector.is_phase_valid && Is_Valid_Half_Period(ECap1Regs.CAP2))
        {
            // ѡCAP2֤
            Phase_Data.half_period = ECap1Regs.CAP2;
        }

        ECap1Regs.ECCLR.bit.CEVT2 = 1;
    }

    // CAP3
    if (ECap1Regs.ECFLG.bit.CEVT3)
    {
        Phase_Data.AC_State = AC_STATE_POSITIVE;
        Phase_Data.Phase_Angle = 0.0f;

        // CAP3ֵ
        if (Is_Valid_Period(ECap1Regs.CAP3))
        {
            Phase_Data.period = ECap1Regs.CAP3;
            Phase_Data.half_period = ECap1Regs.CAP3 / 2;
            Phase_Data.frequency = SYSTEM_CLK / (float)ECap1Regs.CAP3;
            Phase_Detector.is_phase_valid = 1;
        }

        ECap1Regs.ECCLR.bit.CEVT3 = 1;
    }

    // CAP4
    if (ECap1Regs.ECFLG.bit.CEVT4)
    {
        Phase_Data.AC_State = AC_STATE_NEGATIVE;
        Phase_Data.Phase_Angle = 180.0f;

        // CAP4ܿȣ֤
        if (Phase_Detector.is_phase_valid && Is_Valid_Half_Period(ECap1Regs.CAP4))
        {
            // ѡCAP4֤
            Phase_Data.half_period = ECap1Regs.CAP4;
        }

        ECap1Regs.ECCLR.bit.CEVT4 = 1;
    }

    // ȫжϱ־
    ECap1Regs.ECCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;
//    ECAP_clearInterrupt(ECAP1_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |ECAP_ISR_SOURCE_COUNTER_OVERFLOW);
//    ECAP_clearGlobalInterrupt(ECAP1_BASE);
//    ECAP_reArm(ECAP1_BASE);
//    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP4);
}

/*
: ȡʵʱλ
˵: 
*/
float ECAP_Get_Phase_Angle(void)
{
    // 1. Чϴжõֵ
    if (!Phase_Detector.is_phase_valid || Phase_Data.period == 0)
    {
        return Phase_Data.Phase_Angle;
    }

    // 2. ȡǰTSCTRֵ
    uint32_t current_tsctr = ECap1Regs.TSCTR;
    float phase;

    // 3. ݽ״̬λ
    if (Phase_Data.AC_State > 0)  // 
    {
        // ܣcurrent_tsctrǴؿʼʱ
        uint32_t time_in_half_cycle = current_tsctr;

        // ڰڣȫ
        if (time_in_half_cycle > Phase_Data.half_period)
        {
            time_in_half_cycle = Phase_Data.half_period;
        }

        // λ0 ~ 180
        phase = ((float)time_in_half_cycle / (float)Phase_Data.half_period) * 180.0f;

        phase = (phase > 180.0f) ? 180.0f : ((phase < 0.0f) ? 0.0f : phase);
    }
    else  // 
    {
        // ܾʱ = current_tsctr - half_period
        uint32_t time_in_half_cycle;

        if (current_tsctr >= Phase_Data.half_period)
        {
            time_in_half_cycle = current_tsctr - Phase_Data.half_period;
        }
        else
        {
            // ݴϲ
            time_in_half_cycle = 0;
        }

        // ڰ
        if (time_in_half_cycle > Phase_Data.half_period)
        {
            time_in_half_cycle = Phase_Data.half_period;
        }

        // λ180 ~ 360
        phase = 180.0f + ((float)time_in_half_cycle / (float)Phase_Data.half_period) * 180.0f;

        if (phase >= 360.0f) phase = phase - 360.0f;
    }

    return phase;
}

