/*
 * MY_ePWM.c
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#include <MY_ePWM.h>

/*
: PWM˿
˵: 
*/
static void MY_PWM_GPIO_Config(void)
{
    // === GPIO0-1: ePWM˿ (Ӧ160-161) ===
    GPIO_setPinConfig(GPIO_0_EPWM1A);
    GPIO_setPadConfig(0, GPIO_PIN_TYPE_PULLUP);
    GPIO_setDirectionMode(0, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(0, GPIO_CORE_CPU1);

    GPIO_setPinConfig(GPIO_1_EPWM1B);
    GPIO_setPadConfig(1, GPIO_PIN_TYPE_PULLUP);
    GPIO_setDirectionMode(1, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(1, GPIO_CORE_CPU1);
}

/*
: PWM
˵: 
*/
static void MY_PWM_Mode_Config(void)
{
    // === ePWM1 : ===
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);
    EPWM_disablePhaseShiftLoad(EPWM1_BASE);
    EPWM_setTimeBasePeriod(EPWM1_BASE, EPWM1_PERIOD);
    EPWM_setPhaseShift(EPWM1_BASE, 0U);
    EPWM_setTimeBaseCounter(EPWM1_BASE, 0U);

    EPWM_setClockPrescaler(EPWM1_BASE,EPWM_CLOCK_DIVIDER_1,EPWM_HSCLOCK_DIVIDER_1);

    EPWM_setCounterCompareValue(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,EPWM1_PERIOD/2);
    EPWM_setCounterCompareValue(EPWM1_BASE,EPWM_COUNTER_COMPARE_B,EPWM1_PERIOD/2);
    EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,EPWM_COMP_LOAD_ON_CNTR_PERIOD);
    EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE,EPWM_COUNTER_COMPARE_B,EPWM_COMP_LOAD_ON_CNTR_PERIOD);

    EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

    EPWM_setRisingEdgeDeadBandDelayInput(EPWM1_BASE, EPWM_DB_INPUT_EPWMA);
    EPWM_setFallingEdgeDeadBandDelayInput(EPWM1_BASE, EPWM_DB_INPUT_EPWMB);
    EPWM_setDeadBandDelayPolarity(EPWM1_BASE, EPWM_DB_RED, EPWM_DB_POLARITY_ACTIVE_HIGH);
    EPWM_setDeadBandDelayPolarity(EPWM1_BASE, EPWM_DB_FED, EPWM_DB_POLARITY_ACTIVE_LOW);
    EPWM_setDeadBandDelayMode(EPWM1_BASE, EPWM_DB_RED, true);
    EPWM_setDeadBandDelayMode(EPWM1_BASE, EPWM_DB_FED, true);
    EPWM_setRisingEdgeDelayCount(EPWM1_BASE, 50);
    EPWM_setFallingEdgeDelayCount(EPWM1_BASE, 50);
    EPWM_setDeadBandOutputSwapMode(EPWM1_BASE, EPWM_DB_OUTPUT_A, false);
    EPWM_setDeadBandOutputSwapMode(EPWM1_BASE, EPWM_DB_OUTPUT_B, false);

    EPWM_enableADCTrigger(EPWM1_BASE, EPWM_SOC_A);
    EPWM_setADCTriggerSource(EPWM1_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_PERIOD);
    EPWM_setADCTriggerEventPrescale(EPWM1_BASE, EPWM_SOC_A, 1);

    EPWM_disableTripZoneSignals(EPWM1_BASE, EPWM_TZ_SIGNAL_OSHT1  | EPWM_TZ_SIGNAL_CBC1);
    EPWM_setTripZoneAction(EPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZA, EPWM_TZ_ACTION_HIGH);
    EPWM_setTripZoneAction(EPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZB, EPWM_TZ_ACTION_HIGH);

    EPWM_setInterruptSource(EPWM1_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(EPWM1_BASE);
    EPWM_setInterruptEventCount(EPWM1_BASE, 1U);

    EALLOW;
    EPwm1Regs.TZCTL.bit.TZA= 2;
    EPwm1Regs.TZCTL.bit.TZB= 2;
    EDIS;

//    EALLOW;
//
//    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;//ֹEPMMʱӣʹEPMWģͬʹʱʱTBCLK
//    //ʱ
//    EPwm1Regs.TBCTL.bit.CTRMODE = 2;
//    EPwm1Regs.TBPRD = EPWM1_PERIOD;
//    EPwm1Regs.TBPHS.bit.TBPHS = 0;
//    EPwm1Regs.TBCTR = 0;
//    EPwm1Regs.TBSTS.all = 0;
//
//    // ʱ
//    EPwm1Regs.TBCTL.bit.HSPCLKDIV =0;
//    EPwm1Regs.TBCTL.bit.CLKDIV = 0;
//    EPwm1Regs.TBCTL.bit.SYNCOSEL = 0;
//
//    // ȽϼĴ
//    EPwm1Regs.CMPA.bit.CMPA = EPWM1_PERIOD/2;
//    EPwm1Regs.CMPB.bit.CMPB = EPWM1_PERIOD/2;
//    EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;
//    EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
//    EPwm1Regs.CMPCTL.bit.LOADAMODE = 1;
//    EPwm1Regs.CMPCTL.bit.LOADBMODE = 1;
//
//    // ޶
//    EPwm1Regs.AQCTLA.bit.CAU = 1;//CTR=CMPAʱEPWMA͵ƽ
//    EPwm1Regs.AQCTLA.bit.CAD = 2;//CTR=CMPAҼʱEPWMAߵƽ
//    EPwm1Regs.AQCTLB.bit.CBU = 1;
//    EPwm1Regs.AQCTLB.bit.CBD = 2;
//    EPwm1Regs.AQSFRC.all = 0;
//    EPwm1Regs.AQCSFRC.all = 0;
//
//    // 
//    EPwm1Regs.DBCTL.bit.IN_MODE = 2;        //EPWMAΪʱEPWMBΪ½ʱ
//    EPwm1Regs.DBCTL.bit.POLSEL = 2;         //EPWMBת
//    EPwm1Regs.DBCTL.bit.OUT_MODE = 3;       //ʹغ½ʱ
//    EPwm1Regs.DBRED.bit.DBRED = 10;         //ʱ0.1us
//    EPwm1Regs.DBFED.bit.DBFED = 10;         //½ʱ0.1us
//
//    // ¼
//    EPwm1Regs.ETSEL.bit.SOCAEN = 1;         // ʹSOCA
//    EPwm1Regs.ETSEL.bit.SOCASEL = 2;        // CTR=PRDʱ
//    EPwm1Regs.ETPS.bit.SOCAPRD = 1;         // ÿ¼
//
//    // ж - 50kHzж
//    EPwm1Regs.ETSEL.bit.INTEN = 1;          // ʹж
//    EPwm1Regs.ETSEL.bit.INTSEL = 2;         // ƥʱж (TBCTR=TBRD)
//    EPwm1Regs.ETPS.bit.INTPRD = 1;          // ÿ¼ж
//
//    //բ
//    EPwm1Regs.TZCTL.bit.TZA= 2;
//    EPwm1Regs.TZCTL.bit.TZB= 2;
//
//    EDIS;

    // === ePWM2 :250KHZź ===
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
    EPWM_disablePhaseShiftLoad(EPWM2_BASE);
    EPWM_setTimeBasePeriod(EPWM2_BASE, EPWM2_PERIOD);
    EPWM_setPhaseShift(EPWM2_BASE, 0U);
    EPWM_setTimeBaseCounter(EPWM2_BASE, 0U);

    EPWM_setClockPrescaler(EPWM2_BASE,EPWM_CLOCK_DIVIDER_1,EPWM_HSCLOCK_DIVIDER_1);

    EPWM_setCounterCompareValue(EPWM2_BASE,EPWM_COUNTER_COMPARE_A,EPWM2_PERIOD/2);
    EPWM_setCounterCompareValue(EPWM2_BASE,EPWM_COUNTER_COMPARE_B,EPWM2_PERIOD/2);
    EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE,EPWM_COUNTER_COMPARE_A,EPWM_COMP_LOAD_ON_CNTR_PERIOD);
    EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE,EPWM_COUNTER_COMPARE_B,EPWM_COMP_LOAD_ON_CNTR_PERIOD);

    EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

    EPWM_setRisingEdgeDeadBandDelayInput(EPWM2_BASE, EPWM_DB_INPUT_EPWMA);
    EPWM_setFallingEdgeDeadBandDelayInput(EPWM2_BASE, EPWM_DB_INPUT_EPWMB);
    EPWM_setDeadBandDelayPolarity(EPWM2_BASE, EPWM_DB_RED, EPWM_DB_POLARITY_ACTIVE_HIGH);
    EPWM_setDeadBandDelayPolarity(EPWM2_BASE, EPWM_DB_FED, EPWM_DB_POLARITY_ACTIVE_LOW);
    EPWM_setDeadBandDelayMode(EPWM2_BASE, EPWM_DB_RED, true);
    EPWM_setDeadBandDelayMode(EPWM2_BASE, EPWM_DB_FED, true);
    EPWM_setFallingEdgeDelayCount(EPWM2_BASE, 100);
    EPWM_setFallingEdgeDelayCount(EPWM2_BASE, 100);
    EPWM_setDeadBandOutputSwapMode(EPWM2_BASE, EPWM_DB_OUTPUT_A, false);
    EPWM_setDeadBandOutputSwapMode(EPWM2_BASE, EPWM_DB_OUTPUT_B, false);

    EPWM_enableADCTrigger(EPWM2_BASE, EPWM_SOC_A);
    EPWM_setADCTriggerSource(EPWM2_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_PERIOD);
    EPWM_setADCTriggerEventPrescale(EPWM2_BASE, EPWM_SOC_A, 1);

    EPWM_disableTripZoneSignals(EPWM2_BASE, EPWM_TZ_SIGNAL_OSHT1 | EPWM_TZ_SIGNAL_CBC1);
    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZA, EPWM_TZ_ACTION_HIGH_Z);
    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZB, EPWM_TZ_ACTION_HIGH_Z);

    EPWM_setInterruptSource(EPWM2_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_disableInterrupt(EPWM2_BASE);
    EPWM_setInterruptEventCount(EPWM2_BASE, 1U);

//    EALLOW;
//
//    // ʱ - 250kHz
//    EPwm2Regs.TBCTL.bit.CTRMODE = 2;
//    EPwm2Regs.TBPRD = EPWM2_PERIOD;
//    EPwm2Regs.TBPHS.bit.TBPHS = 0;
//    EPwm2Regs.TBCTR = 0;
//    EPwm2Regs.TBSTS.all = 0;
//
//    // ʱ
//    EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0;
//    EPwm2Regs.TBCTL.bit.CLKDIV = 0;
//    EPwm2Regs.TBCTL.bit.SYNCOSEL = 0;
//
//    // ȽϼĴ
//    EPwm2Regs.CMPA.bit.CMPA = EPWM2_PERIOD/2;           // 50%ռձ
//    EPwm2Regs.CMPB.bit.CMPB = EPWM2_PERIOD/2;           // 50%ռձ
//    EPwm2Regs.CMPCTL.bit.SHDWAMODE = 0;
//    EPwm2Regs.CMPCTL.bit.SHDWBMODE = 0;
//    EPwm1Regs.CMPCTL.bit.LOADAMODE = 1;
//    EPwm1Regs.CMPCTL.bit.LOADBMODE = 1;
//
//    // ޶
//    EPwm2Regs.AQCTLA.bit.CAU = 0;
//    EPwm2Regs.AQCTLA.bit.CAD = 0;
//    EPwm2Regs.AQCTLB.bit.CBU = 0;
//    EPwm2Regs.AQCTLB.bit.CBD = 0;
//    EPwm2Regs.AQSFRC.all = 0;
//    EPwm2Regs.AQCSFRC.all = 0;
//
//    // ¼
//    EPwm2Regs.ETSEL.bit.SOCAEN = 1;          // ʹSOCA
//    EPwm2Regs.ETSEL.bit.SOCASEL = 2;         // CTR=PRDʱ
//    EPwm2Regs.ETPS.bit.SOCAPRD = 1;          // ÿ¼
//
//    // Ҫж
//    EPwm2Regs.ETSEL.bit.INTEN = 0;
//    EPwm2Regs.ETSEL.bit.INTSEL = 0;
//    EPwm2Regs.ETPS.bit.INTPRD = 0;
//
//    // ϸ̬
//    EPwm2Regs.TZCTL.bit.TZA = 0;
//    EPwm2Regs.TZCTL.bit.TZB = 0;
//
//    EDIS;

}

/*
: PWM
˵: 
*/
void MY_PWM_Init(void)
{
    MY_PWM_GPIO_Config();
    MY_PWM_Mode_Config();
}

/*
: PWMռձ
˵: 
*/
void MY_PWM_Update_Duty(uint16_t duty_cycle)
{
    if (duty_cycle > (uint16_t)(EPWM1_PERIOD * 0.8))
    {
        duty_cycle = (uint16_t)(EPWM1_PERIOD * 0.8);
    }
    else if (duty_cycle < (uint16_t)(EPWM1_PERIOD * 0.1))
    {
        duty_cycle = (uint16_t)(EPWM1_PERIOD * 0.1);
    }
    //duty_cycle = ( (duty_cycle > EPWM_PERIOD * 0.9) ? EPWM_PERIOD * 0.9 : ( (duty_cycle < EPWM_PERIOD * 0.1) ? EPWM_PERIOD * 0.1 : duty_cycle ) );
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, duty_cycle);
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, duty_cycle);
}

/*
: PWMʹ
˵: 
*/
void MY_PWM_Enable(void)
{
    EPWM_setActionQualifierContSWForceAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_SW_DISABLED);
    EPWM_setActionQualifierContSWForceAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_SW_DISABLED);

//    EPWM_clearTripZoneFlag(EPWM1_BASE, (EPWM_TZ_INTERRUPT | EPWM_TZ_FLAG_OST));
//    EPWM_selectCycleByCycleTripZoneClearEvent(EPWM1_BASE, EPWM_TZ_CBC_PULSE_CLR_CNTR_ZERO_PERIOD);

    EALLOW;

    EPwm1Regs.AQCSFRC.bit.CSFA = 0;
    EPwm1Regs.AQCSFRC.bit.CSFB = 0;

    EPwm1Regs.TZCLR.bit.OST = 1;
    EPwm1Regs.TZCLR.bit.CBCPULSE = 2;

    EDIS;

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}

/*
: PWMʧ
˵: 
*/
void MY_PWM_Disable(void)
{
    EPWM_setActionQualifierContSWForceAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_SW_OUTPUT_LOW);
    EPWM_setActionQualifierContSWForceAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_SW_OUTPUT_LOW);

    EPWM_clearTripZoneFlag(EPWM1_BASE, (EPWM_TZ_INTERRUPT | EPWM_TZ_FLAG_OST));
    EPWM_forceTripZoneEvent(EPWM1_BASE, EPWM_TZ_FORCE_EVENT_OST);

    EPWM_forceTripZoneEvent(EPWM1_BASE, EPWM_TZ_FORCE_EVENT_CBC);
    EALLOW;

//    EPwm1Regs.AQCSFRC.bit.CSFA = 1;
//    EPwm1Regs.AQCSFRC.bit.CSFB = 1;
//
//    EPwm1Regs.TZCLR.bit.OST = 1;        // OST־
//    EPwm1Regs.TZFRC.bit.OST = 1;        // ǿƴOne-Shot Trip

    EPwm1Regs.TZCLR.bit.CBCPULSE = 3;
    //EPwm1Regs.TZFRC.bit.CBC = 1;

    EDIS;
}
