/*
 * Prepare.c
 *
 *  Created on: 20251214
 *      Author: 14359
 */
#include "prepare.h"

/*
: ж
˵: 
*/
void Configure_Interrupts(void)
{
    // === ж ===
    // PIEж
    Interrupt_register(INT_ADCA1,  &Task_250KHZ);      // ADCA1 INT1 (Group1, INT1, INT1.1)
    Interrupt_register(INT_EPWM1,  &Task_50KHZ);       // ePWM1 INT  (Group3, INT1, INT3.1)
    Interrupt_register(INT_TIMER0, &Task_25KHZ);       // CPU Timer0 (Group1, INT7, INT1.7)
    Interrupt_register(INT_ECAP1,  &eCAP1_ISR);        // eCAP1      (Group4, INT1, INT4.1)

    // PIEж - ʹù̼⺯
    Interrupt_enable(INT_ADCA1);     // ADCA1 INT1 - 250kHz
    Interrupt_enable(INT_EPWM1);     // ePWM1 INT - 50kHz
    Interrupt_enable(INT_TIMER0);    // CPU Timer0 - 25kHz
    Interrupt_enable(INT_ECAP1);     // eCAP1 INT - λɼ

    EALLOW;

//    // PIEж
//    PieVectTable.ADCA1_INT = &Task_250KHZ;      // ADCA1 INT1 (Group1, INT1, INT1.1)
//    PieVectTable.EPWM1_INT = &Task_50KHZ;       // ePWM1 INT  (Group3, INT1, INT3.1)
//    PieVectTable.TIMER0_INT = &Task_25KHZ;      // CPU Timer0 (Group1, INT7, INT1.7)
//    PieVectTable.ECAP1_INT = &eCAP1_ISR;        // eCAP1      (Group4, INT1, INT4.1)
//
//    // PIEж
//    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;  // Timer0 INT - 25kHz
//    PieCtrlRegs.PIEIER1.bit.INTx1 = 1;  // ADCA1 INT1 - 250kHz
//    PieCtrlRegs.PIEIER3.bit.INTx1 = 1;  // ePWM1 INT - 50kHz
//    PieCtrlRegs.PIEIER4.bit.INTx1 = 1;  // eCAP1 INT - λɼ

    // PIE
    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;

    EDIS;
}

/*
ϵͳʼ
˵
*/
void Device_Initialize(void)
{
    // 1: ʼ豸ʱӺ
    Device_init();
    Device_initGPIO();
//    InitSysCtrl();
//    InitGpio();

    // 2: ʼʱ
    InitCpuTimers();

    // 3: жϳʼ
//    Interrupt_initModule();
//    Interrupt_initVectorTable();
    DINT;
    InitPieCtrl();
    IER = 0x0000;
    IFR = 0x0000;
    InitPieVectTable();

    // 4: ʼģ
    System_Clock_Init();          //ϵͳʱӳʼ
    MY_GPIO_Init();           //LEDָʾ
    MY_ADC_Init();                //ADC
    MY_PWM_Init();                //PWM
    MY_CMPSS_Init();              //Ƚ
    MY_Timer_Init();             //ʱ
    MY_eCAP_Init();               //ʼeCAPλ
    MY_CLA_Init();                // CLA

    // 5: ж
    Configure_Interrupts();

    // 6: CPUж
    Interrupt_enableInCPU(INTERRUPT_CPU_INT1);  // ʹPIE1 (ADCA1TIMER0)
    Interrupt_enableInCPU(INTERRUPT_CPU_INT3);  // ʹPIE3 (EPWM1)
    Interrupt_enableInCPU(INTERRUPT_CPU_INT4);  // ʹPIE4 (ECAP1)
//    Interrupt_enableInCPU(INTERRUPT_CPU_INT11); // ʹPIE11(CLA)
//    IER |= M_INT1;  // ʹPIE1 (ADCA1TIMER0)
//    IER |= M_INT3;  // ʹPIE3 (EPWM1)
//    IER |= M_INT4;  // ʹPIE4 (ECAP1)
//    IER |= M_INT11; // ʹPIE11(CLA)
//    Interrupt_enableGlobal();
    EINT;
    ERTM;

    // 7رIGBT
    MY_PWM_Disable();
}
