/**
 * main.c
 */
#include "F28x_Project.h"
#include "prepare.h"

int main(void)
{
    while(1)
        {
            switch(STATE)
            {
                   case STATE_INIT:
                   {
                       LED_Update_System_Status();
                       DELAY_US(100000);
                       System_GlobalVariables_Reset();
                       Device_Initialize();
                       DELAY_US(100000);
                       STATE = STATE_RUN;
                   }
                   break;
                   case STATE_RUN:
                   {
                       MY_PWM_Enable();
                       LED_Update_System_Status();
                        // ǷҪ״̬
                       if (Sys_Run_Flag.all !=  0 || Short_Circuit_Flag == 1)
                       {
                           if (Sys_Run_Flag.bit.IL_Over_Current_Fault || Short_Circuit_Flag == 1 )
                           {
                               // ع
                               STATE = STATE_STOP;
                           }
                           else if(Short_Circuit_Flag == 0 && Sys_Run_Flag.all !=  0)
                           {
                               STATE = STATE_FAULT;
                           }
                       }
                   }
                   break;
                   case STATE_FAULT:
                   {
                       LED_Update_System_Status();
                       MY_PWM_Disable();

                       if (Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
                       {
                           Recover_INT_Counter++;
                           if(Recover_INT_Counter >= 5000)
                           {
                               // ϻָϵͳ
                               STATE = STATE_RUN;
                           }
                       }
                       else if(Sys_Run_Flag.all != 0 && Short_Circuit_Flag != 1)
                       {
                           Recover_INT_Counter = 0;
                       }
                       else if(Short_Circuit_Flag == 1 )
                       {
                           STATE = STATE_STOP;
                       }
                   }
                   break;
                   case STATE_STOP:
                   {
                       LED_Update_System_Status();
                       Sys_Run_State = 6;
                       MY_PWM_Disable();
                       PI_Controllers_Init();
                       DELAY_US(10000);
                   }
                   break;
            }
        }
}
