/*
 * task.c
 *
 *  Created on: 20251215
 *      Author: 14359
 */
#include "task.h"

/*
: Task_250KHZ - ADC + ˫ (50kHz)
Դ: ADC-A SOC4 (ADCAINT1)
:  + Чֵ + ˫PI
 */
interrupt void Task_250KHZ(void)
{
    GetADCValue();

#if go_software
    AC_Phase_Detection(ADC_Data.Vin_AC_Filter);
    CMSS_Get_IL_State();
#else
    //CMSS_Get_IL_State();
    //AC_Phase_Detection(ADC_Data.Vin_AC_Filter);
    Phase_Data.Phase_Angle = ECAP_Get_Phase_Angle();
#endif
    Calculate_RMS_Values();

#if State_Machine
    if (STATE == STATE_RUN && Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
    {
        AC_State_Machine(&common_index);
        ACAC_Current_Limiting();
    }
    else if(STATE == STATE_STOP)
    {
        Duty_Cycle = EPWM1_PERIOD * 0.5f;
        PI_Controllers_Init();
    }
#else
    ACAC_PI_Controller();
    Current_Limiting();
#endif

    //AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    //PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
    if(true == ADC_getInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1))
    {
        ADC_clearInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1);
        ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
    }
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);
}
/*
: Task_250KHZ - PWMռձ (50kHz)
Դ: EPWM-INT1 (EPWMINT1)
: PWMռձ
 */
interrupt void Task_50KHZ(void)
{
    if (STATE == STATE_RUN && Sys_Run_Flag.all == 0 && Short_Circuit_Flag != 1)
    {
        MY_PWM_Update_Duty(Duty_Cycle);
    }
    else if(STATE == STATE_STOP)
    {
        MY_PWM_Update_Duty(EPWM1_PERIOD * 0.5f);
        PI_Controllers_Init();
    }

    //EPwm1Regs.ETCLR.bit.INT = 1;
    //PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP3);
}
/*
:Task_25KHZ - ϱж (25kHz)
Դ: CPU Timer0
PIE: Group1, INT1
 */
interrupt void Task_25KHZ(void)
{
#if Check_Fault
    AC_Fault_Detection();
    Short_Current_Protection(ADC_Data.IL_AC_Filter);
    Check_Faults();
#else

#endif

    //CpuTimer0Regs.TCR.bit.TIF = 1;
    //PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);
}
