//******************************************************************************
//*
//*           Copyright (c) 2011 ZTE holding Corporation
//*                  ALL RIGHTS RESERVED
//*
//******************************************************************************

//******************************************************************************
//*  $Id: Init.c 948 2012-08-31 04:21:45Z wu.zhangzhi $
//*
//*Description:  
//*******************************************************************************

#include "Cpu\include\DSP2833x_Device.h"
#include "App\Include\App.h"

typedef u16_t uint16_t;
extern uint16_t RamfuncsLoadStart;
extern uint16_t RamfuncsLoadEnd;
extern uint16_t RamfuncsRunStart;
extern uint16_t Flash28_API_LoadStart;
extern uint16_t Flash28_API_LoadEnd;
extern uint16_t Flash28_API_RunStart;


struct CPUTIMER_VARS CpuTimer0;
// When using DSP BIOS & other RTOS, comment out CPU Timer 2 code.
struct CPUTIMER_VARS CpuTimer1;
struct CPUTIMER_VARS CpuTimer2;
interrupt void sciaRxFifoIsr(void)
{


    SciaRegs.SCIFFRX.bit.RXFFOVRCLR=1; // жϱ־
    SciaRegs.SCIFFRX.bit.RXFFINTCLR=1; // жϱ־
    PieCtrlRegs.PIEACK.bit.ACK9=1;    // Issue PIE ack
}

interrupt void sciaTxFifoIsr(void)
{


    SciaRegs.SCIFFTX.bit.TXFFINTCLR = 1;
    PieCtrlRegs.PIEACK.all|=PIEACK_GROUP9;    // Issue PIE ack
}

const struct PIE_VECT_TABLE PieVectTableInit = {

      PIE_RESERVED,  // 0  Reserved space
      PIE_RESERVED,  // 1  Reserved space 
      PIE_RESERVED,  // 2  Reserved space 
      PIE_RESERVED,  // 3  Reserved space 
      PIE_RESERVED,  // 4  Reserved space 
      PIE_RESERVED,  // 5  Reserved space 
      PIE_RESERVED,  // 6  Reserved space 
      PIE_RESERVED,  // 7  Reserved space 
      PIE_RESERVED,  // 8  Reserved space 
      PIE_RESERVED,  // 9  Reserved space 
      PIE_RESERVED,  // 10 Reserved space 
      PIE_RESERVED,  // 11 Reserved space 
      PIE_RESERVED,  // 12 Reserved space 


// Non-Peripheral Interrupts
      INT13_ISR,     // XINT13 or CPU-Timer 1
      INT14_ISR,     // CPU-Timer2
      DATALOG_ISR,   // Datalogging interrupt
      RTOSINT_ISR,   // RTOS interrupt
      EMUINT_ISR,    // Emulation interrupt
      NMI_ISR,       // Non-maskable interrupt
      ILLEGAL_ISR,   // Illegal operation TRAP
      USER1_ISR,     // User Defined trap 1
      USER2_ISR,     // User Defined trap 2
      USER3_ISR,     // User Defined trap 3
      USER4_ISR,     // User Defined trap 4
      USER5_ISR,     // User Defined trap 5
      USER6_ISR,     // User Defined trap 6
      USER7_ISR,     // User Defined trap 7
      USER8_ISR,     // User Defined trap 8
      USER9_ISR,     // User Defined trap 9
      USER10_ISR,    // User Defined trap 10
      USER11_ISR,    // User Defined trap 11
      USER12_ISR,    // User Defined trap 12

// Group 1 PIE Vectors
      SEQ1INT_ISR,     // 1.1 ADC  
      SEQ2INT_ISR,     // 1.2 ADC  
      rsvd_ISR,        // 1.3
      XINT1_ISR,       // 1.4     
      XINT2_ISR,       // 1.5
      ADCINT_ISR,      // 1.6 ADC
      TINT0_ISR,       // 1.7 Timer 0
      WAKEINT_ISR,     // 1.8 WD, Low Power

// Group 2 PIE Vectors
      EPWM1_TZINT_ISR, // 2.1 EPWM-1 Trip Zone
      EPWM2_TZINT_ISR, // 2.2 EPWM-2 Trip Zone
      EPWM3_TZINT_ISR, // 2.3 EPWM-3 Trip Zone
      EPWM4_TZINT_ISR, // 2.4 EPWM-4 Trip Zone
      EPWM5_TZINT_ISR, // 2.5 EPWM-5 Trip Zone
      EPWM6_TZINT_ISR, // 2.6 EPWM-6 Trip Zone                        
      rsvd_ISR,        // 2.7
      rsvd_ISR,        // 2.8
      
// Group 3 PIE Vectors
      EPWM1_INT_ISR,   // 3.1 EPWM-1 Interrupt
      EPWM2_INT_ISR,   // 3.2 EPWM-2 Interrupt
      EPWM3_INT_ISR,   // 3.3 EPWM-3 Interrupt
      EPWM4_INT_ISR,   // 3.4 EPWM-4 Interrupt
      EPWM5_INT_ISR,   // 3.5 EPWM-5 Interrupt
      EPWM6_INT_ISR,   // 3.6 EPWM-6 Interrupt                        
      rsvd_ISR,        // 3.7
      rsvd_ISR,        // 3.8
      
// Group 4 PIE Vectors
      ECAP1_INT_ISR,   // 4.1 ECAP-1
      ECAP2_INT_ISR,   // 4.2 ECAP-2
      ECAP3_INT_ISR,   // 4.3 ECAP-3
      ECAP4_INT_ISR,   // 4.4 ECAP-4            
      ECAP5_INT_ISR,   // 4.5 ECAP-5     
      ECAP6_INT_ISR,   // 4.6 ECAP-6          
      rsvd_ISR,        // 4.7      
      rsvd_ISR,        // 4.8      
      
// Group 5 PIE Vectors
      EQEP1_INT_ISR,   // 5.1 EQEP-1
      EQEP2_INT_ISR,   // 5.2 EQEP-2
      rsvd_ISR,        // 5.3      
      rsvd_ISR,        // 5.4           
      rsvd_ISR,        // 5.5      
      rsvd_ISR,        // 5.6      
      rsvd_ISR,        // 5.7      
      rsvd_ISR,        // 5.8   


// Group 6 PIE Vectors
      SPIRXINTA_ISR,   // 6.1 SPI-A
      SPITXINTA_ISR,   // 6.2 SPI-A
      MRINTA_ISR,      // 6.3 McBSP-A
      MXINTA_ISR,      // 6.4 McBSP-A
      MRINTB_ISR,      // 6.5 McBSP-B
      MXINTB_ISR,      // 6.6 McBSP-B
      rsvd_ISR,        // 6.7 
      rsvd_ISR,        // 6.8                  

      
// Group 7 PIE Vectors
      DINTCH1_ISR,     // 7.1  DMA channel 1    
      DINTCH2_ISR,     // 7.2  DMA channel 2
      DINTCH3_ISR,     // 7.3  DMA channel 3      
      DINTCH4_ISR,     // 7.4  DMA channel 4           
      DINTCH5_ISR,     // 7.5  DMA channel 5      
      DINTCH6_ISR,     // 7.6  DMA channel 6      
      rsvd_ISR,        // 7.7      
      rsvd_ISR,        // 7.8   

// Group 8 PIE Vectors
      I2CINT1A_ISR,    // 8.1  I2C    
      I2CINT2A_ISR,    // 8.2  I2C
      rsvd_ISR,        // 8.3      
      rsvd_ISR,        // 8.4           
      SCIRXINTC_ISR,   // 8.5  SCI-C
      SCITXINTC_ISR,   // 8.6  SCI-C      
      rsvd_ISR,        // 8.7      
      rsvd_ISR,        // 8.8    
      
// Group 9 PIE Vectors     
      SCIRXINTA_ISR,   // 9.1 SCI-A
      SCITXINTA_ISR,   // 9.2 SCI-A
      SCIRXINTB_ISR,   // 9.3 SCI-B
      SCITXINTB_ISR,   // 9.4 SCI-B
      ECAN0INTA_ISR,   // 9.5 eCAN-A
      ECAN1INTA_ISR,   // 9.6 eCAN-A
      ECAN0INTB_ISR,   // 9.7 eCAN-B
      ECAN1INTB_ISR,   // 9.8 eCAN-B
      
// Group 10 PIE Vectors
      rsvd_ISR,        // 10.1      
      rsvd_ISR,        // 10.2
      rsvd_ISR,        // 10.3      
      rsvd_ISR,        // 10.4           
      rsvd_ISR,        // 10.5      
      rsvd_ISR,        // 10.6      
      rsvd_ISR,        // 10.7      
      rsvd_ISR,        // 10.8    
            
// Group 11 PIE Vectors
      rsvd_ISR,        // 11.1      
      rsvd_ISR,        // 11.2
      rsvd_ISR,        // 11.3      
      rsvd_ISR,        // 11.4           
      rsvd_ISR,        // 11.5      
      rsvd_ISR,        // 11.6      
      rsvd_ISR,        // 11.7      
      rsvd_ISR,        // 11.8
        
// Group 12 PIE Vectors
      XINT3_ISR,       // 12.1      
      XINT4_ISR,       // 12.2
      XINT5_ISR,       // 12.3      
      XINT6_ISR,       // 12.4           
      XINT7_ISR,       // 12.5      
      rsvd_ISR,        // 12.6      
      LVF_ISR,         // 12.7      
      LUF_ISR,         // 12.8   
};


/*******************************************************************************
* Function Name  : sInitPieVectTable
* Description    : This function initializes the PIE vector table to a known state.
// This function must be executed after boot time.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitPieVectTable(void)
{
    int16   i;
    Uint32 *Source = (void *) &PieVectTableInit;
    Uint32 *Dest = (void *) &PieVectTable;
        
    EALLOW; 
    for(i=0; i < 128; i++)
        *Dest++ = *Source++;    
    EDIS;

    // Enable the PIE Vector Table
    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;  
            
}

// Functions that will be run from RAM need to be assigned to
// a different section.  This section will then be mapped to a load and
// run address using the linker cmd file.

#pragma CODE_SECTION(sInitFlash, "ramfuncs");
/*******************************************************************************
* Function Name  :  sInitFlash
* Description    : This function initializes the Flash Control registers

//                   CAUTION
// This function MUST be executed out of RAM. Executing it
// out of OTP/Flash will yield unpredictable results
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitFlash(void)
{
    EALLOW;
    //Enable Flash Pipeline mode to improve performance
    //of code executed from Flash.
    FlashRegs.FOPT.bit.ENPIPE = 1;

    //                CAUTION
    //Minimum waitstates required for the flash operating
    //at a given CPU rate must be characterized by TI.
    //Refer to the datasheet for the latest information.
#if CPU_FRQ_150MHZ
    //Set the Paged Waitstate for the Flash
    FlashRegs.FBANKWAIT.bit.PAGEWAIT = 5;

    //Set the Random Waitstate for the Flash
    FlashRegs.FBANKWAIT.bit.RANDWAIT = 5;

    //Set the Waitstate for the OTP
    FlashRegs.FOTPWAIT.bit.OTPWAIT = 8;
#endif

#if CPU_FRQ_100MHZ
    //Set the Paged Waitstate for the Flash
    FlashRegs.FBANKWAIT.bit.PAGEWAIT = 3;

    //Set the Random Waitstate for the Flash
    FlashRegs.FBANKWAIT.bit.RANDWAIT = 3;

    //Set the Waitstate for the OTP
    FlashRegs.FOTPWAIT.bit.OTPWAIT = 5;
#endif
    //                CAUTION
    //ONLY THE DEFAULT VALUE FOR THESE 2 REGISTERS SHOULD BE USED
    FlashRegs.FSTDBYWAIT.bit.STDBYWAIT = 0x01FF;
    FlashRegs.FACTIVEWAIT.bit.ACTIVEWAIT = 0x01FF;
    EDIS;

    //Force a pipeline flush to ensure that the write to
    //the last register configured occurs before returning.

    asm(" RPT #7 || NOP");
}

/*******************************************************************************
* Function Name  :  sServiceDog
* Description    : This function resets the watchdog timer.
// Enable this function for using ServiceDog in the application
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sServiceDog(void)
{
    EALLOW;
    SysCtrlRegs.WDKEY = 0x0055;
    SysCtrlRegs.WDKEY = 0x00AA;
    EDIS;
}

/*******************************************************************************
* Function Name  :  sDisableDog
* Description    : This function disables the watchdog timer.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/

void sDisableDog(void)
{
    EALLOW;
    SysCtrlRegs.WDCR= 0x0068;
    EDIS;
}
#define WDPS 7 // WDPS=0ʱʱΪ OSC/512,ֵ ʱΪOSC/512>>(WDPS - 1)
// Ҳ˵ŹΪ 1/OSC * 512 * 2^(WDPS-1) * 256
// OSCΪϵͳʱ
void EnableWDog(void)
{
    EALLOW;
    SysCtrlRegs.WDCR = 0x0028 | WDPS;
    EDIS;
}
/*******************************************************************************
* Function Name  :  sInitPll
* Description    : This function initializes the PLLCR register.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitPll(Uint16 val, Uint16 divsel)
{

    // Make sure the PLL is not running in limp mode
    if (SysCtrlRegs.PLLSTS.bit.MCLKSTS != 0)
    {
        // Missing external clock has been detected
        // Replace this line with a call to an appropriate
        // SystemShutdown(); function.
        asm("        ESTOP0");
    }

    // DIVSEL MUST be 0 before PLLCR can be changed from
    // 0x0000. It is set to 0 by an external reset XRSn
    // This puts us in 1/4
    if (SysCtrlRegs.PLLSTS.bit.DIVSEL != 0)
    {
        EALLOW;
        SysCtrlRegs.PLLSTS.bit.DIVSEL = 0;
        EDIS;
    }

    // Change the PLLCR
    if (SysCtrlRegs.PLLCR.bit.DIV != val)
    {

        EALLOW;
        // Before setting PLLCR turn off missing clock detect logic
        SysCtrlRegs.PLLSTS.bit.MCLKOFF = 1;
        SysCtrlRegs.PLLCR.bit.DIV = val;
        EDIS;

        // Optional: Wait for PLL to lock.
        // During this time the CPU will switch to OSCCLK/2 until
        // the PLL is stable.  Once the PLL is stable the CPU will
        // switch to the new PLL value.
        //
        // This time-to-lock is monitored by a PLL lock counter.
        //
        // Code is not required to sit and wait for the PLL to lock.
        // However, if the code does anything that is timing critical,
        // and requires the correct clock be locked, then it is best to
        // wait until this switching has completed.

        // Wait for the PLL lock bit to be set.

        // The watchdog should be disabled before this loop, or fed within
        // the loop via ServiceDog().

        // Uncomment to disable the watchdog
        sDisableDog();

        while(SysCtrlRegs.PLLSTS.bit.PLLLOCKS != 1)
        {
          // Uncomment to service the watchdog
          // ServiceDog();
        }

        EALLOW;
        SysCtrlRegs.PLLSTS.bit.MCLKOFF = 0;
        EDIS;
    }

    // If switching to 1/2
    if((divsel == 1)||(divsel == 2))
    {
        EALLOW;
        SysCtrlRegs.PLLSTS.bit.DIVSEL = divsel;
        EDIS;
    }


    // NOTE: ONLY USE THIS SETTING IF PLL IS BYPASSED (I.E. PLLCR = 0) OR OFF
    // If switching to 1/1
    // * First go to 1/2 and let the power settle
    //   The time required will depend on the system, this is only an example
    // * Then switch to 1/1
    if(divsel == 3)
    {
        EALLOW;
        SysCtrlRegs.PLLSTS.bit.DIVSEL = 2;
        DELAY_US(50L);
        SysCtrlRegs.PLLSTS.bit.DIVSEL = 3;
        EDIS;
    }
}


/*******************************************************************************
* Function Name  :  sInitPeripheralClocks
* Description    : This function initializes the clocks to the peripheral modules.
// First the high and low clock prescalers are set
// Second the clocks are enabled to each peripheral.
// To reduce power, leave clocks to unused peripherals disabled
//
// Note: If a peripherals clock is not enabled then you cannot
// read or write to the registers for that peripheral
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitPeripheralClocks(void)
{
    EALLOW;

    // HISPCP/LOSPCP prescale register settings, normally it will be set to default values
    SysCtrlRegs.HISPCP.all = 0x0001;
    SysCtrlRegs.LOSPCP.all = 0x0002;

    // XCLKOUT to SYSCLKOUT ratio.  By default XCLKOUT = 1/4 SYSCLKOUT
    // XTIMCLK = SYSCLKOUT/2
    XintfRegs.XINTCNF2.bit.XTIMCLK = 1;
    // XCLKOUT = XTIMCLK/2
    XintfRegs.XINTCNF2.bit.CLKMODE = 1;
    // Enable XCLKOUT
    XintfRegs.XINTCNF2.bit.CLKOFF = 0;

    // Peripheral clock enables set for the selected peripherals.
    // If you are not using a peripheral leave the clock off
    // to save on power.
    //
    // Note: not all peripherals are available on all 2833x derivates.
    // Refer to the datasheet for your particular device.
    //
    // This function is not written to be an example of efficient code.

    SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1;    // ADC

    // *IMPORTANT*
    // The ADC_cal function, which  copies the ADC calibration values from TI reserved
    // OTP into the ADCREFSEL and ADCOFFTRIM registers, occurs automatically in the
    // Boot ROM. If the boot ROM code is bypassed during the debug process, the
    // following function MUST be called for the ADC to function according
    // to specification. The clocks to the ADC MUST be enabled before calling this
    // function.
    // See the device data manual and/or the ADC Reference
    // Manual for more information.

    ADC_cal();


    SysCtrlRegs.PCLKCR0.bit.I2CAENCLK = 1;   // I2C
    SysCtrlRegs.PCLKCR0.bit.SCIAENCLK = 1;   // SCI-A
    SysCtrlRegs.PCLKCR0.bit.SCIBENCLK = 1;   // SCI-B
    SysCtrlRegs.PCLKCR0.bit.SCICENCLK = 1;   // SCI-C
    SysCtrlRegs.PCLKCR0.bit.SPIAENCLK = 1;   // SPI-A
    SysCtrlRegs.PCLKCR0.bit.MCBSPAENCLK = 1; // McBSP-A
    SysCtrlRegs.PCLKCR0.bit.MCBSPBENCLK = 1; // McBSP-B
    SysCtrlRegs.PCLKCR0.bit.ECANAENCLK=1;    // eCAN-A
    SysCtrlRegs.PCLKCR0.bit.ECANBENCLK=1;    // eCAN-B

    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;   // Disable TBCLK within the ePWM
    SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1;  // ePWM1
    SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 1;  // ePWM2
    SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK = 1;  // ePWM3
    SysCtrlRegs.PCLKCR1.bit.EPWM4ENCLK = 1;  // ePWM4
    SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK = 1;  // ePWM5
    SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK = 1;  // ePWM6
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;   // Enable TBCLK within the ePWM

    SysCtrlRegs.PCLKCR1.bit.ECAP3ENCLK = 1;  // eCAP3
    SysCtrlRegs.PCLKCR1.bit.ECAP4ENCLK = 1;  // eCAP4
    SysCtrlRegs.PCLKCR1.bit.ECAP5ENCLK = 1;  // eCAP5
    SysCtrlRegs.PCLKCR1.bit.ECAP6ENCLK = 1;  // eCAP6
    SysCtrlRegs.PCLKCR1.bit.ECAP1ENCLK = 1;  // eCAP1
    SysCtrlRegs.PCLKCR1.bit.ECAP2ENCLK = 1;  // eCAP2
    SysCtrlRegs.PCLKCR1.bit.EQEP1ENCLK = 1;  // eQEP1
    SysCtrlRegs.PCLKCR1.bit.EQEP2ENCLK = 1;  // eQEP2

    SysCtrlRegs.PCLKCR3.bit.CPUTIMER0ENCLK = 1; // CPU Timer 0
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER1ENCLK = 1; // CPU Timer 1
    SysCtrlRegs.PCLKCR3.bit.CPUTIMER2ENCLK = 1; // CPU Timer 2

    SysCtrlRegs.PCLKCR3.bit.DMAENCLK = 1;       // DMA Clock
    SysCtrlRegs.PCLKCR3.bit.XINTFENCLK = 1;     // XTIMCLK
    SysCtrlRegs.PCLKCR3.bit.GPIOINENCLK = 1;    // GPIO input clock

    EDIS;
}

/*******************************************************************************
* Function Name  :  sInitSysCtrl
* Description    :  This function initializes the System Control registers to a known state.
 - Disables the watchdog
 - Set the PLLCR for proper SYSCLKOUT frequency
 - Set the pre-scaler for the high and low frequency peripheral clocks
 - Enable the clocks to the peripherals
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitSysCtrl(void)
{

    // Disable the watchdog
    sDisableDog();

    // Initialize the PLL control: PLLCR and DIVSEL
    // DSP28_PLLCR and DSP28_DIVSEL are defined in DSP2833x_Examples.h
    sInitPll(DSP28_PLLCR,DSP28_DIVSEL);

    // Initialize the peripheral clocks
    sInitPeripheralClocks();
}
/*******************************************************************************
* Function Name  :  sMemCopy
* Description    : 
* Input          : 
* Output         : None.
* Return         : None.
*******************************************************************************/

void sMemCopy(Uint16 *SourceAddr, Uint16* SourceEndAddr, Uint16* DestAddr)
{
    while(SourceAddr < SourceEndAddr)
    { 
       *DestAddr++ = *SourceAddr++;
    }
    return;
}

/*******************************************************************************
* Function Name  :  sInitGpio
* Description    : This function initializes the Gpio to a known (default) state.

 For more details on configuring GPIO's as peripheral functions,
 refer to the individual peripheral examples and/or GPIO setup example. 
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/

void sInitGpio(void)
{
    EALLOW;

    // Each GPIO pin can be: 
    // a) a GPIO input/output
    // b) peripheral function 1
    // c) peripheral function 2
    // d) peripheral function 3
    // By default, all are GPIO Inputs 
    GpioCtrlRegs.GPAMUX1.all = 0x0000;     // GPIO functionality GPIO0-GPIO15
    GpioCtrlRegs.GPAMUX2.all = 0x0000;     // GPIO functionality GPIO16-GPIO31
    GpioCtrlRegs.GPBMUX1.all = 0x0000;     // GPIO functionality GPIO32-GPIO39
    GpioCtrlRegs.GPBMUX2.all = 0x0000;     // GPIO functionality GPIO48-GPIO63
    GpioCtrlRegs.GPCMUX1.all = 0x0000;     // GPIO functionality GPIO64-GPIO79
    GpioCtrlRegs.GPCMUX2.all = 0x0000;     // GPIO functionality GPIO80-GPIO95

    GpioCtrlRegs.GPADIR.all = 0x0000;      // GPIO0-GPIO31 are inputs
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;   //output bit60 testpin
	GpioCtrlRegs.GPBDIR.bit.GPIO60 = 1;   //output bit60 testpin
  //  GpioCtrlRegs.GPBDIR.all = 0x0000;      // GPIO32-GPIO63 are inputs   
    GpioCtrlRegs.GPCDIR.all = 0x0000;      // GPI064-GPIO95 are inputs

    // Each input can have different qualification
    // a) input synchronized to SYSCLKOUT
    // b) input qualified by a sampling window
    // c) input sent asynchronously (valid for peripheral inputs only)
    GpioCtrlRegs.GPAQSEL1.all = 0x0000;    // GPIO0-GPIO15 Synch to SYSCLKOUT 
    GpioCtrlRegs.GPAQSEL2.all = 0x0000;    // GPIO16-GPIO31 Synch to SYSCLKOUT
    GpioCtrlRegs.GPBQSEL1.all = 0x0000;    // GPIO32-GPIO39 Synch to SYSCLKOUT 
    GpioCtrlRegs.GPBQSEL2.all = 0x0000;    // GPIO48-GPIO63 Synch to SYSCLKOUT 

    // Pull-ups can be enabled or disabled. 
    GpioCtrlRegs.GPAPUD.all = 0x0000;      // Pullup's enabled GPIO0-GPIO31
    GpioCtrlRegs.GPBPUD.all = 0x0000;      // Pullup's enabled GPIO32-GPIO63
    GpioCtrlRegs.GPCPUD.all = 0x0000;      // Pullup's enabled GPIO64-GPIO79

  //  GpioCtrlRegs.GPAPUD.all = 0xFFFF;    // Pullup's disabled GPIO0-GPIO31
  //  GpioCtrlRegs.GPBPUD.all = 0xFFFF;    // Pullup's disabled GPIO32-GPIO34
  //  GpioCtrlRegs.GPCPUD.all = 0xFFFF ;    // Pullup's disabled GPIO64-GPIO79

    GpioCtrlRegs.GPADIR.bit.GPIO21 = 1; //AD select
    GpioCtrlRegs.GPADIR.bit.GPIO22 = 1;
    EDIS;

}   

/*******************************************************************************
* Function Name  :  sInitPieCtrl
* Description    : This function initializes the PIE control registers to a known state.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/

void sInitPieCtrl(void)
{
    // Disable Interrupts at the CPU level:
    DINT;

    // Disable the PIE
    PieCtrlRegs.PIECTRL.bit.ENPIE = 0;

    // Clear all PIEIER registers:
    PieCtrlRegs.PIEIER1.all = 0;
    PieCtrlRegs.PIEIER2.all = 0;
    PieCtrlRegs.PIEIER3.all = 0;    
    PieCtrlRegs.PIEIER4.all = 0;
    PieCtrlRegs.PIEIER5.all = 0;
    PieCtrlRegs.PIEIER6.all = 0;
    PieCtrlRegs.PIEIER7.all = 0;
    PieCtrlRegs.PIEIER8.all = 0;
    PieCtrlRegs.PIEIER9.all = 0;
    PieCtrlRegs.PIEIER10.all = 0;
    PieCtrlRegs.PIEIER11.all = 0;
    PieCtrlRegs.PIEIER12.all = 0;

    // Clear all PIEIFR registers:
    PieCtrlRegs.PIEIFR1.all = 0;
    PieCtrlRegs.PIEIFR2.all = 0;
    PieCtrlRegs.PIEIFR3.all = 0;    
    PieCtrlRegs.PIEIFR4.all = 0;
    PieCtrlRegs.PIEIFR5.all = 0;
    PieCtrlRegs.PIEIFR6.all = 0;
    PieCtrlRegs.PIEIFR7.all = 0;
    PieCtrlRegs.PIEIFR8.all = 0;
    PieCtrlRegs.PIEIFR9.all = 0;
    PieCtrlRegs.PIEIFR10.all = 0;
    PieCtrlRegs.PIEIFR11.all = 0;
    PieCtrlRegs.PIEIFR12.all = 0;


}   


/*******************************************************************************
* Function Name  :  sInitCpuTimers
* Description    : This function initializes all three CPU timers to a known state.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void sInitCpuTimers(void)
{
    // CPU Timer 0
    // Initialize address pointers to respective timer registers:
    CpuTimer0.RegsAddr = &CpuTimer0Regs;
    // Initialize timer period to maximum:
    CpuTimer0Regs.PRD.all  = 0xFFFFFFFF;
    // Initialize pre-scale counter to divide by 1 (SYSCLKOUT):
    CpuTimer0Regs.TPR.all  = 0;
    CpuTimer0Regs.TPRH.all = 0;
    // Make sure timer is stopped:
    CpuTimer0Regs.TCR.bit.TSS = 1;
    // Reload all counter register with period value:
    CpuTimer0Regs.TCR.bit.TRB = 1;
    // Reset interrupt counters:
    CpuTimer0.InterruptCount = 0;


    // CpuTimer2 is reserved for DSP BIOS & other RTOS
    // Do not use this timer if you ever plan on integrating
    // DSP-BIOS or another realtime OS.

    // Initialize address pointers to respective timer registers:
    CpuTimer1.RegsAddr = &CpuTimer1Regs;
    CpuTimer2.RegsAddr = &CpuTimer2Regs;
    // Initialize timer period to maximum:
    CpuTimer1Regs.PRD.all  = 0xFFFFFFFF;
    CpuTimer2Regs.PRD.all  = 0xFFFFFFFF;
    // Make sure timers are stopped:
    CpuTimer1Regs.TCR.bit.TSS = 1;
    CpuTimer2Regs.TCR.bit.TSS = 1;
    // Reload all counter register with period value:
    CpuTimer1Regs.TCR.bit.TRB = 1;
    CpuTimer2Regs.TCR.bit.TRB = 1;
    // Reset interrupt counters:
    CpuTimer1.InterruptCount = 0;
    CpuTimer2.InterruptCount = 0;

}

/*******************************************************************************
* Function Name  :  sConfigCpuTimer
* Description    :  This function initializes the selected timer to the period specified
 by the "Freq" and "Period" parameters. The "Freq" is entered as "MHz"
 and the period in "uSeconds". The timer is held in the stopped state
 after configuration.
* Input          : 
* Output         : None.
* Return         : None.
*******************************************************************************/
void sConfigCpuTimer(struct CPUTIMER_VARS *Timer, float Freq, float Period)
{
    Uint32  temp;

    // Initialize timer period:
    Timer->CPUFreqInMHz = Freq;
    Timer->PeriodInUSec = Period;
    temp = (long) (Freq * Period);
    Timer->RegsAddr->PRD.all = temp;

    // Set pre-scale counter to divide by 1 (SYSCLKOUT):
    Timer->RegsAddr->TPR.all  = 0;
    Timer->RegsAddr->TPRH.all  = 0;

    // Initialize timer control register:
    Timer->RegsAddr->TCR.bit.TSS = 1;      // 1 = Stop timer, 0 = Start/Restart Timer
    Timer->RegsAddr->TCR.bit.TRB = 1;      // 1 = reload timer
    Timer->RegsAddr->TCR.bit.SOFT = 1;
    Timer->RegsAddr->TCR.bit.FREE = 1;     // Timer Free Run
    Timer->RegsAddr->TCR.bit.TIE = 1;      // 0 = Disable/ 1 = Enable Timer Interrupt

    // Reset interrupt counter:
    Timer->InterruptCount = 0;
}

/*******************************************************************************
* Function Name  :  sInitSci
* Description    : This function initializes the SCI(s) to a known state.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/

void sInitSci(void)
{
    // Initialize SCI-A:
    EALLOW;

 /* Enable internal pull-up for the selected pins */
 // Pull-ups can be enabled or disabled disabled by the user.
 // This will enable the pullups for the specified pins.

 //  GpioCtrlRegs.GPAPUD.bit.GPIO28 = 0;    // Enable pull-up for GPIO28 (SCIRXDA)
 //  GpioCtrlRegs.GPAPUD.bit.GPIO29 = 0;    // Enable pull-up for GPIO29 (SCITXDA)
     GpioCtrlRegs.GPBPUD.bit.GPIO36 = 0;    // Enable pull-up for GPIO36 (SCIRXDA)
     GpioCtrlRegs.GPBPUD.bit.GPIO35 = 0;    // Enable pull-up for GPIO35 (SCITXDA)

 /* Set qualification for selected pins to asynch only */
 // Inputs are synchronized to SYSCLKOUT by default.
 // This will select asynch (no qualification) for the selected pins.

 //  GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = 3;  // Asynch input GPIO28 (SCIRXDA)
     GpioCtrlRegs.GPBQSEL1.bit.GPIO36 = 3;  // Asynch input GPIO28 (SCIRXDA)

 /* Configure SCI-A pins using GPIO regs*/
 // This specifies which of the possible GPIO pins will be SCI functional pins.

 //  GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;   // Configure GPIO28 for SCIRXDA operation
 //  GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;   // Configure GPIO29 for SCITXDA operation
     GpioCtrlRegs.GPBMUX1.bit.GPIO36 = 1;   // Configure GPIO36 for SCIRXDA operation
     GpioCtrlRegs.GPBMUX1.bit.GPIO35 = 1;   // Configure GPIO35 for SCITXDA operation
     EDIS;

    SciaRegs.SCICCR.all =0x0007;   // 1 stop bit,  No loopback
                                   // No parity,8 char bits,
                                   // async mode, idle-line protocol
    SciaRegs.SCICTL1.all =0x0003;  // enable TX, RX, internal SCICLK,
                                   // Disable RX ERR, SLEEP, TXWAKE
    SciaRegs.SCICTL2.bit.TXINTENA =1;
    SciaRegs.SCICTL2.bit.RXBKINTENA =1;
    SciaRegs.SCIHBAUD = 0x0000;
    SciaRegs.SCILBAUD = (LSPCLK_FREQ / (9600L * 8)) - 1;
    //SciaRegs.SCICCR.bit.LOOPBKENA =1; // Enable loop back
    SciaRegs.SCIFFTX.all = 0x0; //disable FIFO mode
    SciaRegs.SCIFFRX.all=0x0;
    SciaRegs.SCIFFCT.all=0x00;

    SciaRegs.SCIFFTX.bit.SCIRST = 1;
    SciaRegs.SCICTL1.all =0x0023;     // Relinquish SCI from Reset

}   
/*******************************************************************************
* Function Name  :
* Description    :ر
* Input          : .
* Output         : .
* Return         : .
*******************************************************************************/
void PWM_turn_off(void)
{
    // GPIO_setHigh(myGpio,GPIO_Number_17);
    EPwm1Regs.AQCTLA.bit.CAU=1;//ϼʱepwma
    EPwm1Regs.AQCTLA.bit.CAD=1;//¼ʱepwma

    EPwm1Regs.AQCTLB.bit.CAU=1;//ϼʱepwmb
    EPwm1Regs.AQCTLB.bit.CAD=1;//¼ʱepwmb

    EPwm1Regs.DBCTL.bit.OUT_MODE=3;//ʹ˫ʱ
    EPwm1Regs.DBCTL.bit.POLSEL=0;//ABת
    EPwm1Regs.DBCTL.bit.IN_MODE=0;//A½

    EPwm2Regs.AQCTLA.bit.CAU=1;//ϼʱepwma
    EPwm2Regs.AQCTLA.bit.CAD=1;//¼ʱepwma

    EPwm2Regs.AQCTLB.bit.CAU=1;//ϼʱepwmb
    EPwm2Regs.AQCTLB.bit.CAD=1;//¼ʱepwmb

    EPwm2Regs.DBCTL.bit.OUT_MODE=3;//ʹ˫ʱ
    EPwm2Regs.DBCTL.bit.POLSEL=0;//ABת
    EPwm2Regs.DBCTL.bit.IN_MODE=0;//A½
}
/*******************************************************************************
* Function Name  :
* Description    :
* Input          : .
* Output         : .
* Return         : .
*******************************************************************************/
void scia_fifo_init(void)
{
    /*
    SCIĹģʽͲҪûںѧϰУ˽һĴײصˣ
    ࿴оƬֲͼĴ˼
    Ϊ28335ļĴ̫ˣԺѧϰУͲԼĴϸעˡ
    */
    SciaRegs.SCICCR.all =0x0007;    // 1 stop bit,  No loopback 1λֹͣλֹػԼԣģʽ8λλ
                               // No parity,8 char bits,
                               // async mode, idle-line protocol
    SciaRegs.SCICTL1.all =0x0003;   // enable TX, RX, internal SCICLK,ʹܷͽգر˯Լվ
                               // Disable RX ERR, SLEEP, TXWAKE
    SciaRegs.SCICTL2.bit.TXINTENA =1;
    SciaRegs.SCICTL2.bit.RXBKINTENA =1;
    SciaRegs.SCIHBAUD = 0x0001;
    SciaRegs.SCILBAUD = 0x00E7;//150MΪ9600
    SciaRegs.SCIFFTX.bit.TXFIFOXRESET=1;//ܷFIFO
    SciaRegs.SCIFFTX.bit.SCIFFENA=1;//ʹSCIFIFO
    SciaRegs.SCIFFTX.bit.TXFFST=0;//FIFOΪ
    SciaRegs.SCIFFTX.bit.TXFFINT=0;//FIFOж
    SciaRegs.SCIFFTX.bit.TXFFINTCLR=0;//FIFOжϱ־
    SciaRegs.SCIFFTX.bit.TXFFIENA=1;//ʹܷFIFOж
    SciaRegs.SCIFFTX.bit.TXFFIL=0;//FIFOΪʱն
    SciaRegs.SCIFFRX.bit.RXFFOVF=0;//FIFO
    SciaRegs.SCIFFRX.bit.RXFFOVRCLR=0;//RXFFOVF־Ӱ
    SciaRegs.SCIFFRX.bit.RXFIFORESET=1;//ʹܽFIFO־
    SciaRegs.SCIFFRX.bit.RXFFST=0;//FIFOΪ
    SciaRegs.SCIFFRX.bit.RXFFINT=0;//޲ն
    SciaRegs.SCIFFRX.bit.RXFFINTCLR=1;//жϱ־
    SciaRegs.SCIFFRX.bit.RXFFIENA=1;//ʹRXFIFOж
    SciaRegs.SCIFFRX.bit.RXFFIL=1;//Ϊ8ʱж
    SciaRegs.SCICTL1.bit.SWRESET =1;//SCI

}
/*******************************************************************************
* Function Name  :  sInitDsp
* Description    : 
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void InitDSP(void)
{
    sInitSysCtrl();  //Initialize System Control in the DSP2833x_SysCtrl.c;	PLL, WatchDog, enable Peripheral Clocks 
    sMemCopy(&Flash28_API_LoadStart,&Flash28_API_LoadEnd,&Flash28_API_RunStart);
    sMemCopy(&RamfuncsLoadStart,&RamfuncsLoadEnd,&RamfuncsRunStart);
    sInitFlash();//initialize FLASH
    //sInitGpio();	   //Initalize GPIO in the DSP2833x_Gpio.c 

    DINT;		   //Clear all interrupts and initialize PIE vector table: Disable CPU interrupts

    sInitPieCtrl();  //Initialize the PIE control registers in the DSP2833x_PieCtrl.c

    IER = 0x0000;   // Disable CPU interrupts and clear all CPU interrupt flags
    IFR = 0x0000;

    sInitPieVectTable();	// Initialize the PIE vector table with pointers to the shell Interrupt Service Routines (ISR).
    				   // in DSP2833x_PieVect.c
 
    sInitCpuTimers();   // For this example, only initialize the Cpu Timers

    sInitSci();//
	scia_fifo_init();

    EPwmSetup();//PWMʼ
    DELAY_US(1500);
    PWM_turn_off();//OK
	
    sConfigCpuTimer(&CpuTimer0, (cSysClk / 1000000), 1000);

    StartCpuTimer0();

    
    EALLOW;  
    PieVectTable.SCIRXINTA = &sciaRxFifoIsr;
    PieVectTable.SCITXINTA = &sciaTxFifoIsr;

    EDIS;   

    IER |= M_INT9;

    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;	  // Enable the PIE block

    PieCtrlRegs.PIEIER9.bit.INTx1 = 1; //ʹܵ8жĵ5ж--SCIARXж
    //PieCtrlRegs.PIEIER9.bit.INTx2 = 1; //ʹܵ8жĵ6ж--SCIATXж

    //EINT;   // Enable Global interrupt INTM
    //ERTM;   // Enable Global realtime interrupt DBGM

}
