// TI File $Revision: /main/9 $
// Checkin $Date: August 10, 2007   09:05:08 $
//###########################################################################
//
// FILE:	Example_EpwmSetup.c
//
// TITLE:	Frequency measurement using EQEP peripheral
//
// DESCRIPTION:
//
// This file contains source for the ePWM initialization for the
// freq calculation module
//
//###########################################################################
// Original Author: SD
//
// $TI Release: DSP2833x Header Files V1.01 $
// $Release Date: September 26, 2007 $
//###########################################################################

#include "DSP2833x_Device.h"     // DSP2833x Headerfile Include File
#include "DSP2833x_Examples.h"   // DSP2833x Examples Include File


#if (CPU_FRQ_150MHZ)
  #define CPU_CLK   150e6
#endif
#if (CPU_FRQ_100MHZ)
  #define CPU_CLK   100e6
#endif
#define PWM_CLK   40e3                // If diff freq. desired, change freq here.
#define SP        CPU_CLK/(2*PWM_CLK)
#define TBCTLVAL  0x200E              // Up-down cnt, timebase = SYSCLKOUT


void EPwmSetup(void)
{
    InitEPwm1Gpio();
    InitEPwm2Gpio();
	EALLOW;
	SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 0;//pwm1ʱӹر
	SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 0;//pwm2ʱӹر
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;//ʱͬر
	EDIS;
	EALLOW;
	SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1;//pwm1ʱӿ
	SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK = 1;//pwm2ʱӿ
//	EDIS;
    EPwm1Regs.TBPRD=SP;
    EPwm1Regs.CMPA.half.CMPA=SP/2;
    //EPwm1Regs.TBSTS.all=0;//ʱ״̬Ĵ
    EPwm1Regs.TBPHS.half.TBPHS=0;//λĴΪ0
    EPwm1Regs.TBCTR=0;//ʱ
    EPwm1Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;			//üģʽ
    EPwm1Regs.TBCTL.bit.PHSEN = 0;        // Disable phase loading
    EPwm1Regs.TBCTL.bit.PRDLD=TB_SHADOW;//TBPRDӰӼĴģʽ
    EPwm1Regs.TBCTL.bit.HSPCLKDIV=0;//TBƵϵ=1TBƵϵ=1Ĭϣ
    EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;//ȽAӰģʽ
    EPwm1Regs.CMPCTL.bit.LOADAMODE = 0;  // Load on Zero

    	    // Set actions
    EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;
    EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;
    EPwm1Regs.AQCTLB.bit.CAU = AQ_CLEAR;
    EPwm1Regs.AQCTLB.bit.CAD = AQ_SET;

	EPwm1Regs.DBCTL.bit.OUT_MODE=3;//ʹ˫ʱ
	EPwm1Regs.DBCTL.bit.POLSEL=2;//AתBת0
	EPwm1Regs.DBCTL.bit.IN_MODE=0;//A½1
//
	EPwm1Regs.DBRED=37;
	EPwm1Regs.DBFED=37;

	EPwm2Regs.TBPRD=SP;
	EPwm2Regs.CMPA.half.CMPA=SP/2;;
	    //EPwm1Regs.TBSTS.all=0;//ʱ״̬Ĵ
	EPwm2Regs.TBPHS.half.TBPHS=0;//λĴΪ0
	EPwm2Regs.TBCTR=0;//ʱ
	EPwm2Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;			//üģʽ
	EPwm2Regs.TBCTL.bit.PHSEN = 0;        // Disable phase loading
	EPwm2Regs.TBCTL.bit.PRDLD=TB_SHADOW;//TBPRDӰӼĴģʽ
	EPwm2Regs.TBCTL.bit.HSPCLKDIV=0;//TBƵϵ=1TBƵϵ=1Ĭϣ
	EPwm2Regs.CMPCTL.bit.SHDWAMODE = 0;//ȽAӰģʽ
	EPwm2Regs.CMPCTL.bit.LOADAMODE = 0;  // Load on Zero
	    	    // Set actions
	EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;
	EPwm2Regs.AQCTLA.bit.CAD = AQ_SET;
	EPwm2Regs.AQCTLB.bit.CBU = AQ_SET;
	EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;

	EPwm2Regs.DBCTL.bit.OUT_MODE=3;//ʹ˫ʱ
    EPwm2Regs.DBCTL.bit.POLSEL=2;//AתBת
	EPwm2Regs.DBCTL.bit.IN_MODE=0;//A½

	EPwm2Regs.DBRED=37;
	EPwm2Regs.DBFED=37;
	EALLOW;
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;//ʱͬ
	EDIS;

}


