/**
 * ---------------------------------------------------------------------------------------
 * 			ݴӿƼ޹˾
 *
 * 			Copyright 2015 Tronlong All rights reserved
 * ---------------------------------------------------------------------------------------
 * 
 * 	   ʹDACA (װJ5 A0) Ҳ
 * ---------------------------------------------------------------------------------------
 * ʱ䣺2016-10-26
 * ---------------------------------------------------------------------------------------
 */

#include "F28x_Project.h"
#include "SciStdio.h"
#include<math.h>
#include<stdio.h>

// ʼ DAC Ĵָ
volatile struct DAC_REGS* DAC_PTR[4] = {0x0,&DacaRegs,&DacbRegs,&DaccRegs};

//  ADC οѡ
#define REFERENCE_VDAC		0
#define REFERENCE_VREF		1

//  DAC ͨ
#define DACA				1
#define DACB				2
#define DACC				3


#define REFERENCE			REFERENCE_VREF
#define DAC_NUM				DACA
Uint16 dacval = 0;

double a1[3072];

// 
void Gpio_select(void);
void configureDAC(Uint16 dac_num);
void test();


void main(void)
{
	unsigned int n;
    double step = 0;
	// ϵͳʼPLLرտŹʹʱ
    InitSysCtrl();

    // GPIOʼ
    Gpio_select();

    // ж
    DINT;

    // ʼPieƼĴ
    InitPieCtrl();

    // ʹжϣжϱ־
    IER = 0x0000;
    IFR = 0x0000;

    // ʼж
    InitPieVectTable();

    // DAC
    configureDAC(DAC_NUM);

    // ʼ
    SCIStdioInit();
    SCIPuts("\r\n ============Test Start===========.\r\n", -1);
    SCIPuts("Welcome to TL28377 DAC_SIN Demo application.\r\n\r\n", -1);

    //  DACA 
    DAC_PTR[DAC_NUM]->DACVALS.all = dacval;
    test();

    step = 2.0*3.1415926/4096.0;

//    while(1)
//    {
//    	for(n=0; n<=4096; n++)
//    	{
//    		dacval = (Uint16)((sin(step*n)*2048.0)+2047);
//    		DAC_PTR[DAC_NUM]->DACVALS.all = dacval;
//    		DELAY_US(10);
//    	}
//    }
}

void test()
{
    //double a1[1024*3];
    int t1;
    int t2;
    for(t1=0;t1<1024;t1++)
    {
        a1[t1]=1.5+t1/2560;
    }
    for(t1=0;t1<1024;t1++)
    {
        a1[t1+1024]=1.9-t1/2560;
    }
    for(t2=0;t2<512;t2++)
    {
        a1[t2+1024+1024]=1.5+t2/1280;
    }
    for(t2=0;t2<512;t2++)
    {
        a1[t2+1024+1024+512]=1.9-t2/1280;
    }

}


void configureDAC(Uint16 dac_num)
{
	EALLOW;
	DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;
	DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;
	DAC_PTR[dac_num]->DACVALS.all = 0;
	DELAY_US(10); // Delay for buffered DAC to power up
	EDIS;
}

void Gpio_select(void)
{
    EALLOW;
    GpioCtrlRegs.GPDMUX2.bit.GPIO115 = 0;	// led1
    GpioCtrlRegs.GPDDIR.bit.GPIO115 = 1;
    GpioCtrlRegs.GPDMUX2.bit.GPIO116 = 0;	// led2
    GpioCtrlRegs.GPDDIR.bit.GPIO116 = 1;

    GpioCtrlRegs.GPDMUX1.bit.GPIO111 = 0;	// led1
    GpioCtrlRegs.GPDDIR.bit.GPIO111 = 1;
    GpioCtrlRegs.GPDMUX2.bit.GPIO112 = 0;	// led2
    GpioCtrlRegs.GPDDIR.bit.GPIO112 = 1;
    GpioCtrlRegs.GPDMUX2.bit.GPIO113 = 0;	// led3
    GpioCtrlRegs.GPDDIR.bit.GPIO113 = 1;
    GpioCtrlRegs.GPDMUX2.bit.GPIO114 = 0;	// led4
    GpioCtrlRegs.GPDDIR.bit.GPIO114 = 1;

    GpioCtrlRegs.GPDMUX1.bit.GPIO108 = 0;	// key1
    GpioCtrlRegs.GPDDIR.bit.GPIO108 = 0;
    GpioCtrlRegs.GPDMUX1.bit.GPIO109 = 0;	// key2
    GpioCtrlRegs.GPDDIR.bit.GPIO109 = 0;
    GpioCtrlRegs.GPDMUX1.bit.GPIO110 = 0;	// key3
    GpioCtrlRegs.GPDDIR.bit.GPIO110 = 0;
    EDIS;

}

