/*============================================================
File name: CANComm.h (IQ version)

Originator: zj EEA THU

Description: define the structure for CAN communication

Reference: ../aci3_1.c ../UsbCan.h ../UsbCan.c

============================================================
History:
------------------------------------------------------------
2011-11-01 Version 0.01
------------------------------------------------------------*/

#ifndef _CANComm_H_
#define _CANComm_H_

#include "IQmathLib.h"		//for IQ version
#include "DSP281x_Device.h"		//for using CAN registers

typedef struct{
	char SendType;
	char SendDelayTime;
	unsigned int count;
	unsigned char LifeID;
	unsigned int HighL;
	unsigned int HighH;
	unsigned int LowL;
	unsigned int LowH;
	unsigned int Index[4];
	unsigned int mbx[4];  //洢ͺͽյ
	unsigned int SendData[13];  //ͨطͺͽݾΪ13λ
	void (*init)();
	void (*exec)();
}CANComm;

typedef CANComm* CANComm_handle;

#define CANComm_DEFAULTS {0,0,0,0,0,0,0,0, \
						  1,2,3,4,0,0,0,0, \
						  0,1,2,3,4,5,6,7,8,9,0,1,2, \
						  (void (*)(long))CanInit, \
						  (void (*)(long))CanExec }

void PackMbx(char Stype,CANComm_handle);
void UnpackMbx(CANComm_handle);
void CanTransmit(CANComm_handle);
void CanReceive(CANComm_handle);
void CanInit(CANComm_handle);
void CanExec(CANComm_handle);
void InitECan();


#endif
