/*============================================================
File name: PID.h

Originator: XXW THU

Description: define the functions related with PID

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef  PID_H
#define  PID_H

#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//PIDõĽṹͣڴʵʱֻ轫ΪPID_FUNCͼ
//-----------------------------------------------------------------------------
typedef struct { 
	    		  float Give;     //룺ϵͳĸֵ
	    		  float Feedback;  //룺ϵͳķֵ
				 
                                             //PID
				 float Kp;  //룺ϵKp
				 float Ki;   //룺ϵKi
				 float Kd;  //룺΢ϵKd
				 float Ts;    //룺ɢϵͳĲ
				
				 float a0;  //мa0
				 float a1;  //мa1
				 float a2;  //мa2
                 
                 float Ek;     //мe(k)
				 float Ek_1;  //мe(k-1)
				 float Ek_2;  //мe(k-2)

                 float OutMax;  //룺PID޷
                 float OutMin;  //룺PIDС޷
                 float Output;  //PIDu(k)
				 float LastOutput;  //мPIDһڵֵu(k-1)
				 void  (*init)();	// ָ룺ָʼ
				 void  (*calc)();	// ָ룺ָ
			   } PID_FUNC;

//-----------------------------------------------------------------------------
//PID_FUNC_handleΪPID_FUNCָ
//-----------------------------------------------------------------------------
typedef PID_FUNC *PID_FUNC_handle;

//-----------------------------------------------------------------------------
//PIDĳʼֵ
//-----------------------------------------------------------------------------
#define PID_FUNC_DEFAULTS {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(void (*)(Uint32))PID_init,(void (*)(Uint32))PID_calc}

//-----------------------------------------------------------------------------
//                                 
//-----------------------------------------------------------------------------
void PID_init(PID_FUNC_handle);
void PID_calc(PID_FUNC_handle);

#endif
//==============================================================
//End of file.
//==============================================================
