/*============================================================
File name: SCI.h

Originator: XXW THU

Description: define the functions related with SCI

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef SCI_H
#define SCI_H

#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------
#define SCIA  0x1
#define SCIB  0x2
#define SCIC  0x3


//-----------------------------------------------------------------------------
// Define a POSSPEED_handle
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Default initializer for the POSSPEED Object.



//-----------------------------------------------------------------------------
//  Prototypes for the functions in posspeed.c                                 
//-----------------------------------------------------------------------------
void sci_init(Uint16 channel);
void sci_sendonechar( Uint16 channel, Uint16 data);
void sci_sendlistchar(Uint16 channel, char *listchar);
Uint16 sci_recvonechar( Uint16 channel);







#endif

//==============================================================
//End of file.
//==============================================================



