/*============================================================
File name: SVPWM_2L.h

Originator: XXW THU

Description: define the functions related with SVPWM_2L

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-20 Version 1.0
------------------------------------------------------------*/


#ifndef SVPWM_2L_H
#define SVPWM_2L_H

#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------
typedef struct 	{ float  Ualpha;  // Input: reference alpha-axis phase voltage 
				  float  Ubeta;   // Input: reference beta-axis phase voltage 
				  float  Vdc;	  // Input: DC voltage
				  float  T;       // Input: PWM Modulation Period 
				  float  Tcmpa;	// Output: reference phase-a switching function		
				  float  Tcmpb;	// Output: reference phase-b switching function 
				  float  Tcmpc;	// Output: reference phase-c switching function
				  void (*calc)();	    // Pointer to calculation function
				} SVPWM_2L;
																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																				

//-----------------------------------------------------------------------------
// Define a POSSPEED_handle
//-----------------------------------------------------------------------------
typedef SVPWM_2L *SVPWM_2L_handle;


//-----------------------------------------------------------------------------
// Default initializer for the POSSPEED Object.
//-----------------------------------------------------------------------------
#define SVPWM_2L_DEFAULTS {0,0,0,1.0,\
                           1,1,1,\
                           (void (*)(Uint32))svpwm_2l_calc}

//-----------------------------------------------------------------------------
//  Prototypes for the functions in posspeed.c                                 
//-----------------------------------------------------------------------------
void svpwm_2l_calc(SVPWM_2L_handle);





#endif

//==============================================================
//End of file.
//==============================================================



