/*============================================================
File name: abz1z2_to_a1b1a2b.h

Originator: XXW THU

Description: define the functions related with abz1z2_to_a1b1a2b

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef abz1z2_to_a1b1a2b2_H
#define abz1z2_to_a1b1a2b2_H
#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------

typedef struct {  float32  Alpha;  	// Input: phase-a stator variable
				  float32  Beta;		// Input: phase-b stator variable
				  float32  z1;		// Input: phase-b stator variable
				  float32  z2;  	// Input: phase-a stator variable
				  float32  Alpha1;		// Input: phase-b stator variable
				  float32  Beta1;		// Input: phase-b stator variable
				  float32  Alpha2;	// Output: stationary d-axis stator variable
				  float32  Beta2;	// Output: stationary q-axis stator variable
		 	 	  void  (*calc)();	// Pointer to calculation function
				 } abz1z2_to_a1b1a2b2;

//-----------------------------------------------------------------------------
// Define a _handle
//-----------------------------------------------------------------------------
typedef abz1z2_to_a1b1a2b2 *abz1z2_to_a1b1a2b2_handle;


//-----------------------------------------------------------------------------
// Default initializer for the  Object.
//-----------------------------------------------------------------------------

#define abz1z2_to_a1b1a2b2_DEFAULTS { 0, \
                          0, \
                          0, \
                          0, \
						  0, \
                          0, \
                          0, \
                          0, \
              			  (void (*)(Uint32))abz1z2_to_a1b1a2b2_calc }

//-----------------------------------------------------------------------------
//  Prototypes for the functions in .c                                 
//-----------------------------------------------------------------------------
void abz1z2_to_a1b1a2b2_calc(abz1z2_to_a1b1a2b2_handle);



#endif

//==============================================================
//End of file.
//==============================================================



