/*============================================================
File name: cilian.h

Originator: XXW THU

Description: define the functions related with cilian

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef CILIAN_H
#define CILIAN_H

typedef struct 	{
	float  IDs; 		// Input: Syn. rotating d-axis current (pu)
	float  IQs;			// Input: Syn. rotating q-axis current (pu)
	float  Wr;			// Input: Rotor electrically angular velocity (pu)
	float  IMDs;		// Variable: Syn. rotating d-axis magnetizing current (pu)
	float  Theta;		// Output: Rotor flux angle (pu)
	float  Kr;			// Parameter: constant using in magnetizing current calculation
	float  Kt;			// Parameter: constant using in slip calculation
	float  K;			// Parameter: constant using in rotor flux angle calculation
	float  Wslip;		// Variable: Slip
	float  We;			// Variable: Angular freq of the stator
	void  (*calc)();	// Pointer to calculation function
} CILIAN;


//-----------------------------------------------------------------------------
// Define a POSSPEED_handle
//-----------------------------------------------------------------------------

typedef CILIAN  *CILIAN_handle;


/*-----------------------------------------------------------------------------
Default initalizer for the CURMOD object.
-----------------------------------------------------------------------------*/                     
#define CILIAN_DEFAULTS { 0,0,0,0,0,0,0,0,0,0,(void (*)(Uint32))CILIAN_calc }

/*------------------------------------------------------------------------------
 CUR_MOD Macro Definition
------------------------------------------------------------------------------*/

void CILIAN_calc (CILIAN_handle);


#endif

