/*============================================================
File name: clarke.h

Originator: XXW THU

Description: define the functions related with clarke

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef CLARKE_H
#define CLARKE_H
#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------

typedef struct {float32  As;  	// Input: phase-a stator variable
float32  Bs;		// Input: phase-b stator variable
float32  Cs;		// Input: phase-b stator variable
float32  Us;  	// Input: phase-a stator variable
float32  Vs;		// Input: phase-b stator variable
float32  Ws;		// Input: phase-b stator variable
float32  Alpha1;	// Output: stationary d-axis stator variable
float32  Beta1;	// Output: stationary q-axis stator variable
float32  Alpha2;	// Output: stationary d-axis stator variable
float32  Beta2;	// Output: stationary q-axis stator variable
void  (*calc)();	// Pointer to calculation function
} CLARKE;

//-----------------------------------------------------------------------------
// Define a _handle
//-----------------------------------------------------------------------------
typedef CLARKE *CLARKE_handle;


//-----------------------------------------------------------------------------
// Default initializer for the  Object.
//-----------------------------------------------------------------------------

#define CLARKE_DEFAULTS {0, \
		0, \
		0, \
		0, \
		0, \
		0, \
		0, \
		0, \
		0, \
		0, \
		(void (*)(Uint32))clarke_calc }

//-----------------------------------------------------------------------------
//  Prototypes for the functions in .c                                 
//-----------------------------------------------------------------------------
void clarke_calc(CLARKE_handle);



#endif

//==============================================================
//End of file.
//==============================================================



