/*============================================================
File name: ipark.h

Originator: XXW THU

Description: define the functions related with ipark

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef IPARK_H
#define IPARK_H

#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------
typedef struct {  float  Alpha;  		// Output: stationary d-axis stator variable
				  float  Beta;		// Output: stationary q-axis stator variable
				  float  Cos;		// Input: rotating angle (pu)
				  float  Sin;
				  float  Ds;			// Input: rotating d-axis stator variable
				  float  Qs;			// Input: rotating q-axis stator variable
		 	 	  void  (*calc)();	// Pointer to calculation function 
				 } IPARK;
				 	 
//-----------------------------------------------------------------------------
// Define a POSSPEED_handle
//-----------------------------------------------------------------------------
typedef IPARK *IPARK_handle;


//-----------------------------------------------------------------------------
// Default initializer for the POSSPEED Object.
//-----------------------------------------------------------------------------
#define IPARK_DEFAULTS {  0, \
                          0, \
                          0, \
                          0, \
                          0, \
						  0, \
              			  (void (*)(Uint32))ipark_calc }
//-----------------------------------------------------------------------------
//  Prototypes for the functions in posspeed.c                                 
//-----------------------------------------------------------------------------
void ipark_calc(IPARK_handle);




#endif

//==============================================================
//End of file.
//==============================================================



