/*============================================================
File name: park.h

Originator: XXW THU

Description: define the functions related with park

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#ifndef PARK_H
#define PARK_H

#include "C28x_FPU_FastRTS.h"

//-----------------------------------------------------------------------------
//  Define the structure of the POSSPEED Object 
//-----------------------------------------------------------------------------
typedef struct {  float  Alpha;  		// Output: stationary d-axis stator variable
				  float  Beta;		// Output: stationary q-axis stator variable
				  float  Cos;		// Input: rotating angle (pu)
				  float  Sin;
				  float  Ds;			// Input: rotating d-axis stator variable
				  float  Qs;			// Input: rotating q-axis stator variable
		 	 	  void  (*calc)();	// Pointer to calculation function 
				 } PARK;
				 	 
//-----------------------------------------------------------------------------
// Define a POSSPEED_handle
//-----------------------------------------------------------------------------
typedef PARK *PARK_handle;


//-----------------------------------------------------------------------------
// Default initializer for the POSSPEED Object.
//-----------------------------------------------------------------------------
#define PARK_DEFAULTS {  0, \
                          0, \
                          0, \
                          0, \
                          0, \
						  0, \
              			  (void (*)(Uint32))park_calc }
//-----------------------------------------------------------------------------
//  Prototypes for the functions in posspeed.c                                 
//-----------------------------------------------------------------------------
void park_calc(PARK_handle);




#endif

//==============================================================
//End of file.
//==============================================================



